/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.bean;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.AbstractRequest;
import org.wso2.am.integration.test.utils.generic.Utils;

public class APICreationRequestBean
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(APICreationRequestBean.class);
    private String name;
    private String context;
    private JSONObject endpoint;
    private String version;
    private String visibility = "public";
    private String description = "description";
    private String endpointType = "nonsecured";
    private String endpointAuthType = "basicAuth";
    private String httpChecked = "http";
    private String httpsChecked = "https";
    private String mutualSSLChecked = "";
    private String oauth2Checked = "";
    private String tags = "tags";
    private String tier = "Silver";
    private String thumbUrl = "";
    private String tiersCollection = "Gold";
    private String type = "http";
    private String subPolicyCollection = "Gold";
    private String resourceCount = "0";
    private String roles = "";
    private String wsdl = "";
    private String defaultVersion = "";
    private String defaultVersionChecked = "";
    private List<APIResourceBean> resourceBeanList;
    private String epUsername = "";
    private String epPassword = "";
    private String sandbox = "";
    private String provider = "admin";
    private String inSequence = "none";
    private String outSequence = "none";
    private String faultSequence = "none";
    private String bizOwner = "";
    private String bizOwnerMail = "";
    private String techOwner = "";
    private String techOwnerMail = "";
    private JSONObject corsConfiguration;
    private String environment = "Default";
    private String productionTps = null;
    private URL endpointUrl = null;
    private String swagger;

    private String getMutualSSLChecked() {
        return this.mutualSSLChecked;
    }

    public void setMutualSSLChecked(String mutualSSLChecked) {
        this.mutualSSLChecked = mutualSSLChecked;
    }

    private String getOauth2Checked() {
        return this.oauth2Checked;
    }

    public void setOauth2Checked(String oauth2Checked) {
        this.oauth2Checked = oauth2Checked;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public JSONObject getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(JSONObject endpoint) {
        this.endpoint = endpoint;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getBizOwner() {
        return this.bizOwner;
    }

    public void setBizOwner(String bizOwner) {
        this.bizOwner = bizOwner;
    }

    public String getBizOwnerMail() {
        return this.bizOwnerMail;
    }

    public void setBizOwnerMail(String bizOwnerMail) {
        this.bizOwnerMail = bizOwnerMail;
    }

    public String getTechOwner() {
        return this.techOwner;
    }

    public void setTechOwner(String techOwner) {
        this.techOwner = techOwner;
    }

    public String getTechOwnerMail() {
        return this.techOwnerMail;
    }

    public void setTechOwnerMail(String techOwnerMail) {
        this.techOwnerMail = techOwnerMail;
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, String apiTier, String resourceTier, URL endpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.tiersCollection = apiTier;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", resourceTier, "/*"));
        if (endpointUrl != null) {
            try {
                String endpointJson = Utils.generateProductionEndpoints(endpointUrl.toString(), null, endpointUrl.getProtocol());
                this.endpoint = new JSONObject(endpointJson);
            }
            catch (JSONException e) {
                log.error((Object)"JSON construct error", (Throwable)e);
                throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
            }
        }
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, URL endpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.endpointUrl = endpointUrl;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        if (endpointUrl != null) {
            try {
                this.endpoint = new JSONObject("{\"production_endpoints\":{\"url\":\"" + endpointUrl + "\",\"config\":null},\"endpoint_type\":\"http\"}");
                this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
            }
            catch (JSONException e) {
                log.error((Object)"JSON construct error", (Throwable)e);
                throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
            }
        }
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, URL endpointUrl, List<APIResourceBean> resourceBeans) throws APIManagerIntegrationTestException {
        this(apiName, context, version, provider, endpointUrl);
        this.resourceBeanList = resourceBeans;
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, ArrayList<String> productionEndpoints) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        String prodEndpoints = "";
        for (int i = 0; i < productionEndpoints.size(); ++i) {
            String uri = "{\"url\":\"" + productionEndpoints.get(i) + "\",\"config\":null},";
            prodEndpoints = prodEndpoints + uri;
        }
        try {
            this.endpoint = new JSONObject("{\"production_endpoints\":[" + prodEndpoints + "],\"algoCombo\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\"failOver\":\"True\",\"algoClassName\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\"sessionManagement\":\"none\",\"implementation_status\":\"managed\",\"endpoint_type\":\"load_balance\"}");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
        }
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, URL endpointUrl, URL sandboxUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        try {
            this.endpoint = new JSONObject();
            if (endpointUrl != null) {
                this.endpoint.put("production_endpoints", (Object)new JSONObject("{\"url\":\"" + endpointUrl + "\",\"config\":null}"));
                this.endpoint.put("endpoint_type", (Object)"http");
            }
            if (sandboxUrl != null) {
                this.endpoint.put("sandbox_endpoints", (Object)new JSONObject("{\"url\":\"" + sandboxUrl + "\",\"config\":null}"));
                this.endpoint.put("endpoint_type", (Object)"http");
            }
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
        }
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider, List<String> productionEndpoints, List<String> sandboxEndpoints) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        String prodEndpoints = "";
        if (productionEndpoints != null && productionEndpoints.size() > 0) {
            for (int i = 0; i < productionEndpoints.size(); ++i) {
                String uri = "{\"url\":\"" + productionEndpoints.get(i) + "\",\"config\":null},";
                prodEndpoints = prodEndpoints + uri;
            }
            prodEndpoints = "\"production_endpoints\": [" + prodEndpoints + "],";
        }
        String sandBoxEndpoints = "";
        if (sandboxEndpoints != null) {
            for (int i = 0; i < sandboxEndpoints.size(); ++i) {
                String sandboxUri = "{\"url\":\"" + sandboxEndpoints.get(i) + "\",\"config\":null},";
                sandBoxEndpoints = sandBoxEndpoints + sandboxUri;
            }
        }
        try {
            this.endpoint = new JSONObject("{" + prodEndpoints + "\"algoCombo\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\"failOver\":\"False\",\"algoClassName\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\"sessionManagement\":\"none\",\"sandbox_endpoints\":[" + sandBoxEndpoints + "],\"implementation_status\":\"managed\",\"endpoint_type\":\"load_balance\"}");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
        }
    }

    public APICreationRequestBean(String apiName, String context, String version, String provider) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        this.version = version;
        this.provider = provider;
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        try {
            this.endpoint = new JSONObject();
            this.endpoint.put("production_endpoints", (Object)new JSONObject("{\"url\":\"Default\",\"config\":null}"));
            this.endpoint.put("sandbox_endpoints", (Object)new JSONObject("{\"url\":\"Default\",\"config\":null}"));
            this.endpoint.put("endpoint_type", (Object)"default");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
        }
    }

    @Override
    public void setAction() {
        this.setAction("addAPI");
    }

    @Override
    public void setAction(String action) {
        super.setAction(action);
    }

    @Override
    public void init() {
        this.addParameter("name", this.name);
        this.addParameter("context", this.context);
        if (this.endpoint != null) {
            this.addParameter("endpoint_config", this.endpoint.toString());
        }
        this.addParameter("provider", this.provider);
        this.addParameter("visibility", this.visibility);
        this.addParameter("version", this.version);
        this.addParameter("description", this.description);
        this.addParameter("endpointType", this.endpointType);
        if (this.getEndpointType().equals("secured")) {
            this.addParameter("endpointAuthType", this.endpointAuthType);
            this.addParameter("epUsername", this.epUsername);
            this.addParameter("epPassword", this.epPassword);
        }
        this.addParameter("http_checked", this.getHttpChecked());
        this.addParameter("https_checked", this.getHttpsChecked());
        this.addParameter("oauth2_checked", this.getOauth2Checked());
        this.addParameter("mutualssl_checked", this.getMutualSSLChecked());
        this.addParameter("tags", this.getTags());
        this.addParameter("tier", this.getTier());
        this.addParameter("thumbUrl", this.getThumbUrl());
        this.addParameter("tiersCollection", this.getTiersCollection());
        this.addParameter("type", this.getType());
        if (this.resourceBeanList.size() < 2) {
            this.addParameter("resourceCount", "0");
        } else {
            this.addParameter("resourceCount", this.resourceBeanList.size() + "");
        }
        if (!(this.inSequence.equals("none") && this.outSequence.equals("none") && this.faultSequence.equals("none"))) {
            this.addParameter("sequence_check", "on");
        }
        this.addParameter("inSequence", this.inSequence);
        this.addParameter("outSequence", this.outSequence);
        this.addParameter("faultSequence", this.faultSequence);
        int resourceIndex = 0;
        for (APIResourceBean apiResourceBean : this.resourceBeanList) {
            this.addParameter("resourceMethod-" + resourceIndex, apiResourceBean.getResourceMethod());
            this.addParameter("resourceMethodAuthType-" + resourceIndex, apiResourceBean.getResourceMethodAuthType());
            this.addParameter("resourceMethodThrottlingTier-" + resourceIndex, apiResourceBean.getResourceMethodThrottlingTier());
            this.addParameter("uriTemplate-" + resourceIndex, apiResourceBean.getUriTemplate());
            ++resourceIndex;
        }
        if (this.swagger != null && !this.swagger.isEmpty()) {
            this.addParameter("swagger", this.swagger);
        }
        this.addParameter("default_version", this.getDefaultVersion());
        this.addParameter("default_version_checked", this.getDefaultVersionChecked());
        if (this.roles.length() > 1) {
            this.addParameter("roles", this.getRoles());
        }
        if (this.wsdl.length() > 1) {
            this.addParameter("wsdl", this.getWsdl());
        }
        this.addParameter("bizOwner", this.bizOwner);
        this.addParameter("bizOwnerMail", this.bizOwnerMail);
        this.addParameter("techOwner", this.techOwner);
        this.addParameter("techOwnerMail", this.techOwnerMail);
        this.addParameter("environments", this.getEnvironment());
        this.addParameter("corsConfiguration", this.getCorsConfiguration().toString());
        this.addParameter("subPolicyCollection", this.getSubPolicyCollection());
        if (this.productionTps != null) {
            this.addParameter("productionTps", this.getProductionTps());
        }
    }

    public String getEpUsername() {
        return this.epUsername;
    }

    public void setEpUsername(String epUsername) {
        this.epUsername = epUsername;
    }

    public String getEpPassword() {
        return this.epPassword;
    }

    public void setEpPassword(String epPassword) {
        this.epPassword = epPassword;
    }

    public List<APIResourceBean> getResourceBeanList() {
        return this.resourceBeanList;
    }

    public void setResourceBeanList(List<APIResourceBean> resourceBeanList) {
        this.resourceBeanList = resourceBeanList;
    }

    public String getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.name;
    }

    public JSONObject getEndpointConfig() {
        return this.endpoint;
    }

    public String getContext() {
        return this.context;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getEndpointAuthType() {
        return this.endpointAuthType;
    }

    public void setEndpointAuthType(String endpointAuthType) {
        this.endpointAuthType = endpointAuthType;
    }

    public String getHttpChecked() {
        return this.httpChecked;
    }

    public void setHttpChecked(String httpChecked) {
        this.httpChecked = httpChecked;
    }

    public String getHttpsChecked() {
        return this.httpsChecked;
    }

    public void setHttpsChecked(String httpsChecked) {
        this.httpsChecked = httpsChecked;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String getTiersCollection() {
        return this.tiersCollection;
    }

    public void setTiersCollection(String tiersCollection) {
        this.tiersCollection = tiersCollection;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceCount() {
        return this.resourceCount;
    }

    public void setResourceCount(String resourceCount) {
        this.resourceCount = resourceCount;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefault_version(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getDefaultVersionChecked() {
        return this.defaultVersionChecked;
    }

    public void setDefaultVersionChecked(String defaultVersionChecked) {
        this.defaultVersionChecked = defaultVersionChecked;
    }

    public String getInSequence() {
        return this.inSequence;
    }

    public void setInSequence(String inSequence) {
        this.inSequence = inSequence;
    }

    public String getOutSequence() {
        return this.outSequence;
    }

    public void setOutSequence(String outSequence) {
        this.outSequence = outSequence;
    }

    public String getFaultSequence() {
        return this.faultSequence;
    }

    public void setFaultSequence(String faultSequence) {
        this.faultSequence = faultSequence;
    }

    public JSONObject getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(JSONObject corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public String getSubPolicyCollection() {
        return this.subPolicyCollection;
    }

    public void setSubPolicyCollection(String subPolicyCollection) {
        this.subPolicyCollection = subPolicyCollection;
    }

    public String getProductionTps() {
        return this.productionTps;
    }

    public void setProductionTps(String productionTps) {
        this.productionTps = productionTps;
    }

    public URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(URL endpointUrl) {
        this.endpointUrl = endpointUrl;
    }
}

