/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpRequestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse sendGetRequest(String endpoint, String requestParameters) throws IOException {
        if (endpoint.startsWith("http://")) {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in);
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPost(URL endpoint, String postBody, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPost httpPost = new HttpPost(endpoint.toURI());
            httpPost.setEntity((HttpEntity)new StringEntity(postBody));
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    if (key == null) continue;
                    httpPost.addHeader(key, headers.get(key));
                }
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = httpResponse.getEntity().getContent();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(IOUtils.toString((InputStream)content), httpResponse.getStatusLine().getStatusCode(), responseHeaders);
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doGet(String endpoint, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(endpoint);
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                if (key == null) continue;
                httpGet.addHeader(key, headers.get(key));
            }
        }
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        try (InputStream content = httpResponse.getEntity().getContent();){
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse2 = new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(IOUtils.toString((InputStream)content), httpResponse.getStatusLine().getStatusCode(), responseHeaders);
            return httpResponse2;
        }
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPut(URL endpoint, String putBody, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPut httpPut = new HttpPut(endpoint.toURI());
            httpPut.setEntity((HttpEntity)new StringEntity(putBody));
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    if (key == null) continue;
                    httpPut.addHeader(key, headers.get(key));
                }
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            InputStream content = httpResponse.getEntity().getContent();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(IOUtils.toString((InputStream)content), httpResponse.getStatusLine().getStatusCode(), responseHeaders);
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
    }

    public static int doDelete(URL endpoint, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpDelete httpDelete = new HttpDelete(endpoint.toURI());
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    if (key == null) continue;
                    httpDelete.addHeader(key, headers.get(key));
                }
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
            InputStream content = httpResponse.getEntity().getContent();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            return httpResponse.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }
}

