/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationKeyMappingDTO;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.ApIsApi;
import org.wso2.am.integration.clients.store.api.v1.ApiKeysApi;
import org.wso2.am.integration.clients.store.api.v1.ApplicationKeysApi;
import org.wso2.am.integration.clients.store.api.v1.ApplicationsApi;
import org.wso2.am.integration.clients.store.api.v1.CommentsApi;
import org.wso2.am.integration.clients.store.api.v1.GraphQlPoliciesApi;
import org.wso2.am.integration.clients.store.api.v1.KeyManagersCollectionApi;
import org.wso2.am.integration.clients.store.api.v1.RatingsApi;
import org.wso2.am.integration.clients.store.api.v1.SdKsApi;
import org.wso2.am.integration.clients.store.api.v1.SubscriptionsApi;
import org.wso2.am.integration.clients.store.api.v1.TagsApi;
import org.wso2.am.integration.clients.store.api.v1.ThrottlingPoliciesApi;
import org.wso2.am.integration.clients.store.api.v1.TopicsApi;
import org.wso2.am.integration.clients.store.api.v1.UnifiedSearchApi;
import org.wso2.am.integration.clients.store.api.v1.UsersApi;
import org.wso2.am.integration.clients.store.api.v1.WebhooksApi;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyRevokeRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyMappingRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyReGenerateResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.CommentDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.CommentListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.CurrentAndNewPasswordsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.KeyManagerListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.PatchRequestBodyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.PostRequestBodyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SearchResultListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TagListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TopicListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.WebhookSubscriptionListDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.impl.RestAPIGatewayImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RestAPIStoreImpl {
    public static final String appName = "Integration_Test_App_Store";
    public static final String callBackURL = "test.com";
    public static final String tokenScope = "Production";
    public static final String appOwner = "admin";
    public static final String grantType = "password";
    public static final String username = "admin";
    public static final String password = "admin";
    public static final String testNameProperty = "testName";
    private static final Log log = LogFactory.getLog(RestAPIStoreImpl.class);
    public ApIsApi apIsApi = new ApIsApi();
    public ApplicationsApi applicationsApi = new ApplicationsApi();
    public SubscriptionsApi subscriptionIndividualApi = new SubscriptionsApi();
    public ApplicationKeysApi applicationKeysApi = new ApplicationKeysApi();
    public CommentsApi commentsApi = new CommentsApi();
    public RatingsApi ratingsApi = new RatingsApi();
    public TagsApi tagsApi = new TagsApi();
    public SdKsApi sdKsApi = new SdKsApi();
    public ApiKeysApi apiKeysApi = new ApiKeysApi();
    public UnifiedSearchApi unifiedSearchApi = new UnifiedSearchApi();
    public KeyManagersCollectionApi keyManagersCollectionApi = new KeyManagersCollectionApi();
    public GraphQlPoliciesApi graphQlPoliciesApi = new GraphQlPoliciesApi();
    public ThrottlingPoliciesApi throttlingPoliciesApi = new ThrottlingPoliciesApi();
    public UsersApi usersApi = new UsersApi();
    public TopicsApi topicsApi = new TopicsApi();
    public WebhooksApi webhooksApi = new WebhooksApi();
    public String storeURL;
    public String tenantDomain;
    ApiClient apiStoreClient = new ApiClient();
    private RestAPIGatewayImpl restAPIGateway;
    private String accessToken;
    private String disableVerification = System.getProperty("disableVerification");

    public RestAPIStoreImpl(String username, String password, String tenantDomain, String storeURL) {
        String tokenURL = storeURL + "oauth2/token";
        String dcrURL = storeURL + "client-registration/v0.17/register";
        String scopes = "openid apim:subscribe apim:app_update apim:app_manage apim:sub_manage apim:self-signup apim:dedicated_gateway apim:store_settings apim:api_key";
        this.accessToken = ClientAuthenticator.getAccessToken(scopes, appName, callBackURL, tokenScope, "admin", grantType, dcrURL, username, password, tenantDomain, tokenURL);
        this.apiStoreClient.setDebugging(Boolean.valueOf(System.getProperty("okHttpLogs")).booleanValue());
        this.apiStoreClient.addDefaultHeader("Authorization", "Bearer " + this.accessToken);
        this.apiStoreClient.setBasePath(storeURL + "api/am/devportal/v2");
        this.apiStoreClient.setReadTimeout(600000);
        this.apiStoreClient.setConnectTimeout(600000);
        this.apiStoreClient.setWriteTimeout(600000);
        this.apIsApi.setApiClient(this.apiStoreClient);
        this.applicationsApi.setApiClient(this.apiStoreClient);
        this.subscriptionIndividualApi.setApiClient(this.apiStoreClient);
        this.applicationKeysApi.setApiClient(this.apiStoreClient);
        this.commentsApi.setApiClient(this.apiStoreClient);
        this.topicsApi.setApiClient(this.apiStoreClient);
        this.webhooksApi.setApiClient(this.apiStoreClient);
        this.ratingsApi.setApiClient(this.apiStoreClient);
        this.tagsApi.setApiClient(this.apiStoreClient);
        this.unifiedSearchApi.setApiClient(this.apiStoreClient);
        this.apiKeysApi.setApiClient(this.apiStoreClient);
        this.keyManagersCollectionApi.setApiClient(this.apiStoreClient);
        this.graphQlPoliciesApi.setApiClient(this.apiStoreClient);
        this.usersApi.setApiClient(this.apiStoreClient);
        this.throttlingPoliciesApi.setApiClient(this.apiStoreClient);
        this.apiStoreClient.setDebugging(true);
        this.storeURL = storeURL;
        this.tenantDomain = tenantDomain;
        this.restAPIGateway = new RestAPIGatewayImpl("admin", "admin", tenantDomain);
    }

    public RestAPIStoreImpl(String tenantDomain, String storeURL) {
        this.apiStoreClient.setDebugging(Boolean.valueOf(System.getProperty("okHttpLogs")).booleanValue());
        this.apiStoreClient.setBasePath(storeURL + "api/am/devportal/v2");
        this.apiStoreClient.setDebugging(true);
        this.apIsApi.setApiClient(this.apiStoreClient);
        this.applicationsApi.setApiClient(this.apiStoreClient);
        this.subscriptionIndividualApi.setApiClient(this.apiStoreClient);
        this.applicationKeysApi.setApiClient(this.apiStoreClient);
        this.tagsApi.setApiClient(this.apiStoreClient);
        this.keyManagersCollectionApi.setApiClient(this.apiStoreClient);
        this.usersApi.setApiClient(this.apiStoreClient);
        this.storeURL = storeURL;
        this.tenantDomain = tenantDomain;
        this.restAPIGateway = new RestAPIGatewayImpl("admin", "admin", tenantDomain);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public HttpResponse createApplication(String appName, String description, String throttleTier, ApplicationDTO.TokenTypeEnum tokenType) throws APIManagerIntegrationTestException {
        try {
            ApplicationDTO application = new ApplicationDTO();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingPolicy(throttleTier);
            application.setTokenType(tokenType);
            ApplicationDTO createdApp = this.applicationsApi.applicationsPost(application);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)createdApp.getApplicationId())) {
                this.waitUntilApplicationAvailableInGateway(createdApp);
                response = new HttpResponse(createdApp.getApplicationId(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public HttpResponse createApplicationWithOrganization(String appName, String description, String throttleTier, ApplicationDTO.TokenTypeEnum tokenType, List<String> groups) {
        try {
            ApplicationDTO application = new ApplicationDTO();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingPolicy(throttleTier);
            application.setTokenType(tokenType);
            application.setGroups(groups);
            ApplicationDTO createdApp = this.applicationsApi.applicationsPost(application);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)createdApp.getApplicationId())) {
                response = new HttpResponse(createdApp.getApplicationId(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public HttpResponse createApplicationWithCustomAttribute(String appName, String description, String throttleTier, ApplicationDTO.TokenTypeEnum tokenType, Map<String, String> attribute) throws APIManagerIntegrationTestException {
        try {
            ApplicationDTO application = new ApplicationDTO();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingPolicy(throttleTier);
            application.setTokenType(tokenType);
            application.setAttributes(attribute);
            ApplicationDTO createdApp = this.applicationsApi.applicationsPost(application);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)createdApp.getApplicationId())) {
                this.waitUntilApplicationAvailableInGateway(createdApp);
                response = new HttpResponse(createdApp.getApplicationId(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public HttpResponse deleteApplication(String applicationId) {
        try {
            this.applicationsApi.applicationsApplicationIdDelete(applicationId, null);
            this.applicationsApi.applicationsApplicationIdGet(applicationId, null, this.tenantDomain);
            return null;
        }
        catch (ApiException e) {
            HttpResponse response = null;
            if (404 == e.getCode()) {
                response = new HttpResponse(applicationId, 200);
            }
            return response;
        }
    }

    public ApplicationListDTO getAllApps() throws ApiException {
        ApiResponse appResponse = this.applicationsApi.applicationsGetWithHttpInfo(null, null, null, null, null, null, null);
        Assert.assertEquals((int)200, (int)appResponse.getStatusCode());
        return (ApplicationListDTO)appResponse.getData();
    }

    public HttpResponse updateApplicationByID(String applicationId, String appName, String description, String throttleTier, ApplicationDTO.TokenTypeEnum tokenType) {
        try {
            ApplicationDTO application = new ApplicationDTO();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingPolicy(throttleTier);
            application.setTokenType(tokenType);
            ApplicationDTO createdApp = this.applicationsApi.applicationsApplicationIdPut(applicationId, application, null);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)createdApp.getApplicationId())) {
                response = new HttpResponse(createdApp.toString(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public HttpResponse updateApplicationByID(String applicationId, String appName, String description, String throttleTier, ApplicationDTO.TokenTypeEnum tokenType, List<String> groups) {
        HttpResponse response = null;
        try {
            ApplicationDTO application = new ApplicationDTO();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingPolicy(throttleTier);
            application.setTokenType(tokenType);
            application.setGroups(groups);
            ApplicationDTO createdApp = this.applicationsApi.applicationsApplicationIdPut(applicationId, application, null);
            if (StringUtils.isNotEmpty((String)createdApp.getApplicationId())) {
                response = new HttpResponse(createdApp.toString(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            response = new HttpResponse(e.getResponseBody(), e.getCode());
            return response;
        }
    }

    public HttpResponse createSubscription(String apiId, String applicationId, String subscriptionTier) throws APIManagerIntegrationTestException {
        try {
            SubscriptionDTO subscription = new SubscriptionDTO();
            subscription.setApplicationId(applicationId);
            subscription.setApiId(apiId);
            subscription.setThrottlingPolicy(subscriptionTier);
            subscription.setRequestedThrottlingPolicy(subscriptionTier);
            SubscriptionDTO subscriptionResponse = this.subscriptionIndividualApi.subscriptionsPost(subscription, this.tenantDomain);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)subscriptionResponse.getSubscriptionId())) {
                this.waitUntilSubscriptionAvailableInGateway(subscriptionResponse);
                response = new HttpResponse(subscriptionResponse.getSubscriptionId(), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public SubscriptionListDTO getSubscription(String apiId, String applicationId, String apiType, String groupId) throws ApiException {
        ApiResponse suscriptionResponse = this.subscriptionIndividualApi.subscriptionsGetWithHttpInfo(apiId, applicationId, groupId, this.tenantDomain, null, null, null);
        Assert.assertEquals((int)200, (int)suscriptionResponse.getStatusCode());
        return (SubscriptionListDTO)suscriptionResponse.getData();
    }

    public HttpResponse removeSubscription(SubscriptionDTO subscriptionDTO) throws ApiException, APIManagerIntegrationTestException {
        ApiResponse deleteResponse = this.subscriptionIndividualApi.subscriptionsSubscriptionIdDeleteWithHttpInfo(subscriptionDTO.getSubscriptionId(), null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Subscription deleted successfully : sub ID: " + subscriptionDTO.getSubscriptionId(), 200);
            this.waitUntilSubscriptionRemoveFromGateway(subscriptionDTO);
        }
        return response;
    }

    public ApplicationKeyDTO generateKeys(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, ArrayList<String> scopes, List<String> grantTypes) throws ApiException, APIManagerIntegrationTestException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        ApiResponse response = this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.waitUntilApplicationKeyMappingAvailableInGateway(applicationId, (ApplicationKeyDTO)response.getData());
        return (ApplicationKeyDTO)response.getData();
    }

    public ApplicationKeyDTO generateKeys(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, List<String> scopes, List<String> grantTypes, Map<String, Object> additionalProperties, String keyManager) throws ApiException, APIManagerIntegrationTestException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        applicationKeyGenerateRequest.setAdditionalProperties(additionalProperties);
        applicationKeyGenerateRequest.setKeyManager(keyManager);
        ApiResponse response = this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.waitUntilApplicationKeyMappingAvailableInGateway(applicationId, (ApplicationKeyDTO)response.getData());
        return (ApplicationKeyDTO)response.getData();
    }

    public ApplicationKeyDTO generateKeysWithAdditionalProperties(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, List<String> scopes, List<String> grantTypes, Map<String, Object> additionalProperties) throws ApiException, APIManagerIntegrationTestException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        applicationKeyGenerateRequest.setAdditionalProperties(additionalProperties);
        ApiResponse response = this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.waitUntilApplicationKeyMappingAvailableInGateway(applicationId, (ApplicationKeyDTO)response.getData());
        return (ApplicationKeyDTO)response.getData();
    }

    public ApiResponse<ApplicationKeyDTO> generateKeysWithApiResponse(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, List<String> scopes, List<String> grantTypes, Map<String, Object> additionalProperties, String keyManager) throws ApiException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        applicationKeyGenerateRequest.setAdditionalProperties(additionalProperties);
        if (StringUtils.isNotEmpty((String)keyManager)) {
            applicationKeyGenerateRequest.setKeyManager(keyManager);
        }
        ApiResponse response = this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
        return response;
    }

    public APIKeyDTO generateAPIKeys(String applicationId, String keyType, int validityPeriod, String permittedIP, String permittedReferer) throws ApiException {
        APIKeyGenerateRequestDTO keyGenerateRequestDTO = new APIKeyGenerateRequestDTO();
        keyGenerateRequestDTO.setValidityPeriod(Integer.valueOf(validityPeriod));
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("permittedIP", permittedIP);
        additionalProperties.put("permittedReferer", permittedReferer);
        keyGenerateRequestDTO.setAdditionalProperties(additionalProperties);
        ApiResponse response = this.apiKeysApi.applicationsApplicationIdApiKeysKeyTypeGeneratePostWithHttpInfo(applicationId, keyType, null, keyGenerateRequestDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        return (APIKeyDTO)response.getData();
    }

    public void revokeAPIKey(String applicationId, String apiKey) throws ApiException {
        APIKeyRevokeRequestDTO revokeRequestDTO = new APIKeyRevokeRequestDTO();
        revokeRequestDTO.setApikey(apiKey);
        ApiResponse response = this.apiKeysApi.applicationsApplicationIdApiKeysKeyTypeRevokePostWithHttpInfo(applicationId, "PRODUCTION", null, revokeRequestDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    public ApiResponse<ApplicationKeyDTO> updateKeys(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO) throws Exception {
        return this.applicationKeysApi.applicationsApplicationIdKeysKeyTypePutWithHttpInfo(applicationId, keyType, applicationKeyDTO);
    }

    public ApiResponse<ApplicationKeyReGenerateResponseDTO> regenerateConsumerSecret(String applicationId, String keyType) throws Exception {
        return this.applicationKeysApi.applicationsApplicationIdKeysKeyTypeRegenerateSecretPostWithHttpInfo(applicationId, keyType);
    }

    public ApiResponse<ApplicationKeyDTO> getApplicationKeysByKeyType(String applicationId, String keyType) throws Exception {
        return this.applicationKeysApi.applicationsApplicationIdKeysKeyTypeGetWithHttpInfo(applicationId, keyType, null);
    }

    public ApplicationKeyReGenerateResponseDTO regenerateSecretByKeyMappingId(String applicationId, String keyMappingId) throws ApiException {
        ApiResponse responseDTO = this.applicationKeysApi.applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostWithHttpInfo(applicationId, keyMappingId);
        Assert.assertEquals((int)200, (int)responseDTO.getStatusCode());
        return (ApplicationKeyReGenerateResponseDTO)responseDTO.getData();
    }

    public APIDTO getAPI(String apiId) throws ApiException {
        this.setActivityID();
        return this.apIsApi.apisApiIdGet(apiId, null, null);
    }

    public APIDTO getAPI(String apiId, String tenantDomain) throws ApiException {
        this.setActivityID();
        return this.apIsApi.apisApiIdGet(apiId, tenantDomain, null);
    }

    public APIListDTO getAllPublishedAPIs() throws APIManagerIntegrationTestException {
        try {
            return this.apIsApi.apisGet(null, Integer.valueOf(0), null, null, null);
        }
        catch (ApiException e) {
            throw new APIManagerIntegrationTestException("Error when retrieving APIs " + e.getResponseBody(), e);
        }
    }

    public APIListDTO getAllAPIs() throws ApiException {
        return this.getAllAPIs(this.tenantDomain);
    }

    public APIListDTO getAllAPIs(String tenantDomain) throws ApiException {
        ApiResponse apiResponse = this.apIsApi.apisGetWithHttpInfo(null, null, tenantDomain, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (APIListDTO)apiResponse.getData();
    }

    public SearchResultListDTO searchAPIs(String query) throws ApiException {
        ApiResponse searchResponse = this.unifiedSearchApi.searchGetWithHttpInfo(null, null, this.tenantDomain, query, null);
        Assert.assertEquals((int)200, (int)searchResponse.getStatusCode());
        return (SearchResultListDTO)searchResponse.getData();
    }

    public SearchResultListDTO searchAPIs(String query, String tenantDomain) throws ApiException {
        ApiResponse searchResponse = this.unifiedSearchApi.searchGetWithHttpInfo(null, null, tenantDomain, query, null);
        Assert.assertEquals((int)200, (int)searchResponse.getStatusCode());
        return (SearchResultListDTO)searchResponse.getData();
    }

    public APIListDTO getAPIs(int offset, int limit) throws ApiException {
        this.setActivityID();
        ApiResponse apiResponse = this.apIsApi.apisGetWithHttpInfo(Integer.valueOf(limit), Integer.valueOf(offset), this.tenantDomain, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (APIListDTO)apiResponse.getData();
    }

    public ApplicationDTO getApplicationById(String applicationId) throws ApiException {
        ApiResponse applicationDTOApiResponse = this.applicationsApi.applicationsApplicationIdGetWithHttpInfo(applicationId, null, this.tenantDomain);
        Assert.assertEquals((int)applicationDTOApiResponse.getStatusCode(), (int)200);
        return (ApplicationDTO)applicationDTOApiResponse.getData();
    }

    public ApplicationDTO getApplicationById(String applicationId, String tenantDomain) throws ApiException {
        ApiResponse applicationDTOApiResponse = this.applicationsApi.applicationsApplicationIdGetWithHttpInfo(applicationId, null, tenantDomain);
        Assert.assertEquals((int)applicationDTOApiResponse.getStatusCode(), (int)200);
        return (ApplicationDTO)applicationDTOApiResponse.getData();
    }

    public HttpResponse getPublishedAPIsByApplication(String applicationName) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getPublishedAPIsByApplicationId(String applicationName, int applicationId) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse addRating(String apiId, Integer rating, String tenantDomain) throws ApiException {
        RatingDTO ratingDTO = new RatingDTO();
        ratingDTO.setRating(rating);
        Gson gson = new Gson();
        ApiResponse apiResponse = this.ratingsApi.apisApiIdUserRatingPutWithHttpInfo(apiId, ratingDTO, tenantDomain);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        HttpResponse response = null;
        if (apiResponse.getData() != null && StringUtils.isNotEmpty((String)((RatingDTO)apiResponse.getData()).getRatingId())) {
            response = new HttpResponse(gson.toJson(apiResponse.getData()), 200);
        }
        return response;
    }

    public HttpResponse removeRating(String apiId, String tenantDomain) {
        HttpResponse response;
        try {
            this.ratingsApi.apisApiIdUserRatingDelete(apiId, tenantDomain, null);
            response = new HttpResponse("Successfully deleted the rating", 200);
        }
        catch (ApiException e) {
            response = new HttpResponse("Failed to delete the rating", e.getCode());
        }
        return response;
    }

    public HttpResponse removeRatingFromAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse isRatingActivated() throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getAllDocumentationOfAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getApiEndpointUrls(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getAllPaginatedPublishedAPIs(String tenant, String start, String end) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse cleanUpApplicationRegistrationByApplicationId(String applicationId, String keyType) throws APIManagerIntegrationTestException, ApiException {
        ApiResponse httpInfo = this.applicationKeysApi.applicationsApplicationIdKeysKeyTypeCleanUpPostWithHttpInfo(applicationId, keyType, null);
        HttpResponse response = null;
        if (httpInfo.getStatusCode() == 200) {
            response = new HttpResponse("Successfully cleaned up the application registration", 200);
        }
        return response;
    }

    public HttpResponse getAllPaginatedPublishedAPIs(String tenant, int start, int end) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getAllPublishedAPIs(String tenant) throws APIManagerIntegrationTestException {
        return null;
    }

    public ApplicationDTO addApplication(String application, String tier, String callbackUrl, String description) throws ApiException, APIManagerIntegrationTestException {
        ApplicationDTO dto = new ApplicationDTO();
        dto.setName(application);
        dto.setThrottlingPolicy(tier);
        dto.setDescription(description);
        ApiResponse apiResponse = this.applicationsApi.applicationsPostWithHttpInfo(dto);
        Assert.assertEquals((int)201, (int)apiResponse.getStatusCode());
        this.waitUntilApplicationAvailableInGateway((ApplicationDTO)apiResponse.getData());
        return (ApplicationDTO)apiResponse.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsPostWithHttpInfo(String application, String tier, String description) throws ApiException, APIManagerIntegrationTestException {
        ApplicationDTO dto = new ApplicationDTO();
        dto.setName(application);
        dto.setThrottlingPolicy(tier);
        dto.setDescription(description);
        ApiResponse apiResponse = this.applicationsApi.applicationsPostWithHttpInfo(dto);
        return apiResponse;
    }

    public ApplicationDTO addApplicationWithTokenType(String application, String tier, String callbackUrl, String description, String tokenType) throws ApiException, APIManagerIntegrationTestException {
        ApplicationDTO dto = new ApplicationDTO();
        dto.setName(application);
        dto.setThrottlingPolicy(tier);
        dto.setDescription(description);
        dto.setTokenType(ApplicationDTO.TokenTypeEnum.fromValue((String)tokenType));
        ApiResponse apiResponse = this.applicationsApi.applicationsPostWithHttpInfo(dto);
        Assert.assertEquals((int)201, (int)apiResponse.getStatusCode());
        this.waitUntilApplicationAvailableInGateway((ApplicationDTO)apiResponse.getData());
        return (ApplicationDTO)apiResponse.getData();
    }

    public HttpResponse getApplications() throws APIManagerIntegrationTestException {
        return null;
    }

    public void removeApplicationById(String applicationId) throws ApiException {
        if (applicationId == null) {
            return;
        }
        ApiResponse response = this.applicationsApi.applicationsApplicationIdDeleteWithHttpInfo(applicationId, null);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
    }

    public HttpResponse updateApplication(String applicationOld, String applicationNew, String callbackUrlNew, String descriptionNew, String tier) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updateApplicationById(int applicationId, String applicationOld, String applicationNew, String callbackUrlNew, String descriptionNew, String tier) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updateClientApplicationById(String applicationId, ApplicationDTO applicationDTO) {
        try {
            ApplicationDTO responseApplicationDTO = this.applicationsApi.applicationsApplicationIdPut(applicationId, applicationDTO, null);
            HttpResponse response = null;
            if (StringUtils.isNotEmpty((String)responseApplicationDTO.getApplicationId())) {
                Gson gson = new Gson();
                response = new HttpResponse(gson.toJson((Object)responseApplicationDTO), 200);
            }
            return response;
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            return null;
        }
    }

    public HttpResponse regenerateConsumerSecret(String clientId) throws APIManagerIntegrationTestException {
        return null;
    }

    public SubscriptionListDTO getAllSubscriptionsOfApplication(String applicationId) throws ApiException {
        SubscriptionListDTO subscriptionListDTO = this.subscriptionIndividualApi.subscriptionsGet(null, applicationId, null, this.tenantDomain, null, null, null);
        if (subscriptionListDTO.getCount() > 0) {
            return subscriptionListDTO;
        }
        return null;
    }

    public SubscriptionListDTO getAllSubscriptionsOfApplication(String applicationId, String tenantDomain) throws ApiException {
        return this.subscriptionIndividualApi.subscriptionsGet(null, applicationId, null, tenantDomain, null, null, null);
    }

    public HttpResponse getSubscribedAPIs(String applicationName) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getSubscribedAPIs(String applicationName, String domain) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse removeAPISubscription(String API2, String version, String provider, String applicationId) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse removeAPISubscriptionByApplicationName(String API2, String version, String provider, String applicationName) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse removeAPISubscriptionByName(String API2, String version, String provider, String appName) throws APIManagerIntegrationTestException {
        return null;
    }

    public TagListDTO getAllTags() throws ApiException {
        ApiResponse tagsResponse = this.tagsApi.tagsGetWithHttpInfo(Integer.valueOf(25), Integer.valueOf(0), this.tenantDomain, "");
        Assert.assertEquals((int)200, (int)tagsResponse.getStatusCode());
        return (TagListDTO)tagsResponse.getData();
    }

    public HttpResponse addComment(String apiId, String comment, String category, String replyTo) throws ApiException {
        PostRequestBodyDTO postRequestBodyDTO = new PostRequestBodyDTO();
        postRequestBodyDTO.setContent(comment);
        postRequestBodyDTO.setCategory(category);
        Gson gson = new Gson();
        CommentDTO commentDTO = this.commentsApi.addCommentToAPI(apiId, postRequestBodyDTO, replyTo);
        HttpResponse response = null;
        if (commentDTO != null) {
            response = new HttpResponse(gson.toJson((Object)commentDTO), 200);
        }
        return response;
    }

    public HttpResponse getComment(String commentId, String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentDTO commentDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentDTO = this.commentsApi.getCommentOfAPI(commentId, apiId, tenantDomain, null, Boolean.valueOf(includeCommentorInfo), limit, offset);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)commentDTO.getId())) {
            response = new HttpResponse(gson.toJson((Object)commentDTO), 200);
        }
        return response;
    }

    public HttpResponse getComments(String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentListDTO commentListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentListDTO = this.commentsApi.getAllCommentsOfAPI(apiId, tenantDomain, limit, offset, Boolean.valueOf(includeCommentorInfo));
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (commentListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)commentListDTO), 200);
        }
        return response;
    }

    public HttpResponse getTopics(String apiId, String tenantDomain) {
        TopicListDTO topicListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            topicListDTO = this.topicsApi.apisApiIdTopicsGet(apiId, tenantDomain);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (topicListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)topicListDTO), 200);
        }
        return response;
    }

    public HttpResponse getWebhooks(String apiId, String applicationId, String tenantDomain) throws ApiException {
        WebhookSubscriptionListDTO subscriptionListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            subscriptionListDTO = this.webhooksApi.webhooksSubscriptionsGet(applicationId, apiId, tenantDomain);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (subscriptionListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)subscriptionListDTO), 200);
        }
        return response;
    }

    public HttpResponse getReplies(String commentId, String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentListDTO commentListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentListDTO = this.commentsApi.getRepliesOfComment(commentId, apiId, tenantDomain, limit, offset, null, Boolean.valueOf(includeCommentorInfo));
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (commentListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)commentListDTO), 200);
        }
        return response;
    }

    public HttpResponse editComment(String commentId, String apiId, String comment, String category) throws ApiException {
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            PatchRequestBodyDTO patchRequestBodyDTO = new PatchRequestBodyDTO();
            patchRequestBodyDTO.setCategory(category);
            patchRequestBodyDTO.setContent(comment);
            CommentDTO editedCommentDTO = this.commentsApi.editCommentOfAPI(commentId, apiId, patchRequestBodyDTO);
            response = editedCommentDTO != null ? new HttpResponse(gson.toJson((Object)editedCommentDTO), 200) : new HttpResponse(null, 200);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        return response;
    }

    public HttpResponse removeComment(String commentId, String apiId) throws ApiException {
        HttpResponse response;
        try {
            this.commentsApi.deleteComment(commentId, apiId, null);
            response = new HttpResponse("Successfully deleted the comment", 200);
        }
        catch (ApiException e) {
            response = new HttpResponse("Failed to delete the comment", e.getCode());
        }
        return response;
    }

    public HttpResponse isCommentActivated() throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse getRecentlyAddedAPIs(String tenant, String limit) throws APIManagerIntegrationTestException {
        return null;
    }

    private String getApplicationId(String jsonStringOfApplications, String applicationName) throws APIManagerIntegrationTestException {
        return null;
    }

    public APIListDTO getAPIsFilteredWithTags(String apiTag) throws APIManagerIntegrationTestException, ApiException {
        String query = "tag:" + apiTag;
        APIListDTO apis = this.apIsApi.apisGet(null, null, null, query, null);
        if (apis.getCount() > 0) {
            return apis;
        }
        return null;
    }

    public APIListDTO searchPaginatedAPIs(int limit, int offset, String tenantDomain, String query) throws ApiException {
        APIListDTO apis = this.apIsApi.apisGet(Integer.valueOf(limit), Integer.valueOf(offset), tenantDomain, query, null);
        if (apis.getCount() > 0) {
            return apis;
        }
        return null;
    }

    public SubscriptionDTO subscribeToAPI(String apiID, String appID, String tier) throws ApiException, APIManagerIntegrationTestException {
        this.setActivityID();
        SubscriptionDTO subscription = new SubscriptionDTO();
        subscription.setApplicationId(appID);
        subscription.setApiId(apiID);
        subscription.setThrottlingPolicy(tier);
        ApiResponse subscriptionResponse = this.subscriptionIndividualApi.subscriptionsPostWithHttpInfo(subscription, this.tenantDomain);
        Assert.assertEquals((int)201, (int)subscriptionResponse.getStatusCode());
        this.waitUntilSubscriptionAvailableInGateway((SubscriptionDTO)subscriptionResponse.getData());
        return (SubscriptionDTO)subscriptionResponse.getData();
    }

    public SubscriptionDTO subscribeToAPI(String apiID, String appID, String tier, String tenantDomain) throws ApiException, APIManagerIntegrationTestException {
        this.setActivityID();
        SubscriptionDTO subscription = new SubscriptionDTO();
        subscription.setApplicationId(appID);
        subscription.setApiId(apiID);
        subscription.setThrottlingPolicy(tier);
        ApiResponse subscriptionResponse = this.subscriptionIndividualApi.subscriptionsPostWithHttpInfo(subscription, tenantDomain);
        Assert.assertEquals((int)201, (int)subscriptionResponse.getStatusCode());
        this.waitUntilSubscriptionAvailableInGateway((SubscriptionDTO)subscriptionResponse.getData());
        return (SubscriptionDTO)subscriptionResponse.getData();
    }

    private void waitUntilSubscriptionAvailableInGateway(SubscriptionDTO subscribedDto) throws APIManagerIntegrationTestException {
        if (Boolean.parseBoolean(this.disableVerification)) {
            return;
        }
        org.wso2.am.integration.clients.gateway.api.v2.dto.SubscriptionDTO subscriptionDTO = this.restAPIGateway.retrieveSubscription(subscribedDto.getApiId(), subscribedDto.getApplicationId());
        if (subscriptionDTO != null) {
            log.info((Object)("Subscription Available in in memory == " + subscriptionDTO.toString()));
            if (subscribedDto.getStatus().getValue().equals(subscriptionDTO.getSubscriptionState())) {
                return;
            }
        }
        for (long retries = 0L; retries <= 20L; ++retries) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            subscriptionDTO = this.restAPIGateway.retrieveSubscription(subscribedDto.getApiId(), subscribedDto.getApplicationId());
            if (subscriptionDTO == null) continue;
            log.info((Object)("Subscription Available in in memory== " + subscriptionDTO.toString()));
            if (subscribedDto.getStatus().getValue().equals(subscriptionDTO.getSubscriptionState())) break;
        }
        Assert.assertNotNull((Object)subscribedDto, (String)"Subscription not available in the gateway");
    }

    private void waitUntilSubscriptionRemoveFromGateway(SubscriptionDTO subscribedDto) throws APIManagerIntegrationTestException {
        if (Boolean.parseBoolean(this.disableVerification)) {
            return;
        }
        org.wso2.am.integration.clients.gateway.api.v2.dto.SubscriptionDTO subscriptionDTO = this.restAPIGateway.retrieveSubscription(subscribedDto.getApiId(), subscribedDto.getApplicationId());
        if (subscriptionDTO == null) {
            log.info((Object)("Subscription not Available in in-memory == " + subscribedDto.getSubscriptionId()));
        }
        for (long retries = 0L; retries <= 20L; ++retries) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            subscriptionDTO = this.restAPIGateway.retrieveSubscription(subscribedDto.getApiId(), subscribedDto.getApplicationId());
            if (subscriptionDTO != null) continue;
            log.info((Object)("Subscription not Available in in-memory == " + subscribedDto.getSubscriptionId()));
            break;
        }
        Assert.assertNull((Object)subscriptionDTO, (String)"in-memory subscription didn't removed when deleting subscription ");
    }

    public APIListDTO getAPIListFromStoreAsAnonymousUser(String tenantDomain) throws ApiException {
        ApIsApi apIsApi = new ApIsApi();
        ApiClient apiStoreClient = new ApiClient();
        apiStoreClient = apiStoreClient.setBasePath(this.storeURL + "api/am/devportal/v2");
        apIsApi.setApiClient(apiStoreClient);
        ApiResponse apiResponse = apIsApi.apisGetWithHttpInfo(null, null, tenantDomain, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (APIListDTO)apiResponse.getData();
    }

    public HttpResponse logout() throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse signUp(String userName, String password, String firstName, String lastName, String email) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse signUpforTenant(String userName, String password, String claims) throws APIManagerIntegrationTestException {
        return null;
    }

    public APIListDTO getPrototypedAPIs(String tenant) throws APIManagerIntegrationTestException {
        try {
            APIListDTO prototypedAPIs = new APIListDTO();
            APIListDTO apiListDTO = this.apIsApi.apisGet(null, null, tenant, null, null);
            ArrayList<APIInfoDTO> apiInfoDTOList = new ArrayList<APIInfoDTO>();
            for (APIInfoDTO apidto : apiListDTO.getList()) {
                if (!apidto.getLifeCycleStatus().equals("PROTOTYPED")) continue;
                apiInfoDTOList.add(apidto);
            }
            prototypedAPIs.setList(apiInfoDTOList);
            return prototypedAPIs;
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get prototype APIs. Error: " + e.getMessage(), e);
        }
    }

    public ApiResponse<byte[]> generateSDKUpdated(String apiId, String language) throws ApiException, IOException {
        this.sdKsApi.setApiClient(this.apiStoreClient);
        return this.sdKsApi.apisApiIdSdksLanguageGetWithHttpInfo(apiId, language, this.tenantDomain);
    }

    public ApiResponse<byte[]> generateSDKUpdated(String apiId, String language, String tenantDomain) throws ApiException, IOException {
        this.sdKsApi.setApiClient(this.apiStoreClient);
        return this.sdKsApi.apisApiIdSdksLanguageGetWithHttpInfo(apiId, language, tenantDomain);
    }

    public HttpResponse changePassword(String currentPassword, String newPassword) throws ApiException {
        HttpResponse response = null;
        CurrentAndNewPasswordsDTO currentAndNewPasswordsDTO = new CurrentAndNewPasswordsDTO();
        currentAndNewPasswordsDTO.setCurrentPassword(currentPassword);
        currentAndNewPasswordsDTO.setNewPassword(newPassword);
        ApiResponse changePasswordResponse = this.usersApi.changeUserPasswordWithHttpInfo(currentAndNewPasswordsDTO);
        Assert.assertEquals((int)changePasswordResponse.getStatusCode(), (int)200);
        if (changePasswordResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully changed user password", 200);
        }
        return response;
    }

    public String getSwaggerByID(String apiId, String tenantDomain) throws ApiException {
        ApiResponse response = this.apIsApi.apisApiIdSwaggerGetWithHttpInfo(apiId, "Default", null, tenantDomain);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (String)response.getData();
    }

    public HttpResponse generateUserAccessKey(String consumeKey, String consumerSecret, String messageBody, URL tokenEndpointURL) throws APIManagerIntegrationTestException {
        try {
            HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
            String basicAuthHeader = consumeKey + ":" + consumerSecret;
            byte[] encodedBytes = Base64.encodeBase64((byte[])basicAuthHeader.getBytes("UTF-8"));
            authenticationRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            return HTTPSClientUtils.doPost(tokenEndpointURL, messageBody, authenticationRequestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to generate API access token. Error: " + e.getMessage(), e);
        }
    }

    public ApiResponse<Void> downloadWSDLSchemaDefinitionOfAPI(String apiId, String environmentName) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.getWSDLOfAPIWithHttpInfo(apiId, environmentName, null, this.tenantDomain);
        Assert.assertEquals((int)200, (int)apiDtoApiResponse.getStatusCode());
        return apiDtoApiResponse;
    }

    public KeyManagerListDTO getKeyManagers() throws ApiException {
        return this.keyManagersCollectionApi.keyManagersGet(this.tenantDomain);
    }

    public KeyManagerListDTO getKeyManagers(String tenantDomain) throws ApiException {
        return this.keyManagersCollectionApi.keyManagersGet(tenantDomain);
    }

    public ApplicationKeyDTO getApplicationKeyByKeyMappingId(String applicationId, String keyMappingId) throws ApiException {
        return this.applicationKeysApi.applicationsApplicationIdOauthKeysKeyMappingIdGet(applicationId, keyMappingId, null);
    }

    public ApplicationKeyDTO updateApplicationKeyByKeyMappingId(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO) throws ApiException {
        return this.applicationKeysApi.applicationsApplicationIdOauthKeysKeyMappingIdPut(applicationId, keyMappingId, applicationKeyDTO);
    }

    public ApplicationKeyListDTO getApplicationKeysByAppId(String jwtAppId) throws ApiException {
        return this.applicationKeysApi.applicationsApplicationIdKeysGet(jwtAppId);
    }

    public ApplicationKeyDTO mapConsumerKeyWithApplication(String consumerKey, String consumerSecret, String appid, String keyManager) throws ApiException {
        ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO = new ApplicationKeyMappingRequestDTO().consumerKey(consumerKey).consumerSecret(consumerSecret).keyType(ApplicationKeyMappingRequestDTO.KeyTypeEnum.PRODUCTION).keyManager(keyManager);
        return this.applicationKeysApi.applicationsApplicationIdMapKeysPost(appid, applicationKeyMappingRequestDTO, this.tenantDomain);
    }

    public HttpResponse getGraphQLComplexityResponse(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse complexityResponse = this.graphQlPoliciesApi.apisApiIdGraphqlPoliciesComplexityGetWithHttpInfo(apiId);
        if (complexityResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully get the GraphQL Complexity Details", 200);
        }
        return response;
    }

    public HttpResponse getGraphQLSchemaTypeListResponse(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse graphQLSchemaTypeListDTOApiResponse = this.graphQlPoliciesApi.apisApiIdGraphqlPoliciesComplexityTypesGetWithHttpInfo(apiId);
        if (graphQLSchemaTypeListDTOApiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully get the GraphQL Schema Type List", 200);
        }
        return response;
    }

    private void setActivityID() {
        this.apiStoreClient.addDefaultHeader("activityID", System.getProperty(testNameProperty));
    }

    private void waitUntilApplicationAvailableInGateway(ApplicationDTO applicationDTO) throws APIManagerIntegrationTestException {
        if (Boolean.parseBoolean(this.disableVerification)) {
            return;
        }
        ApplicationInfoDTO applicationInfoDTO = this.restAPIGateway.retrieveApplication(applicationDTO.getApplicationId());
        if (applicationInfoDTO != null) {
            log.info((Object)("Application Available in in memory == " + applicationInfoDTO.toString()));
            Assert.assertEquals((String)applicationDTO.getName(), (String)applicationInfoDTO.getName());
            Assert.assertEquals((String)applicationDTO.getThrottlingPolicy(), (String)applicationInfoDTO.getPolicy());
            Assert.assertEquals((String)applicationDTO.getTokenType().getValue(), (String)applicationInfoDTO.getTokenType());
            Assert.assertEquals((Object)applicationDTO.getAttributes(), (Object)applicationInfoDTO.getAttributes());
            return;
        }
        for (long retries = 0L; retries <= 20L; ++retries) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            applicationInfoDTO = this.restAPIGateway.retrieveApplication(applicationDTO.getApplicationId());
            if (applicationInfoDTO == null) continue;
            log.info((Object)("Application Available in in memory == " + applicationInfoDTO.toString()));
            Assert.assertEquals((String)applicationDTO.getName(), (String)applicationInfoDTO.getName());
            Assert.assertEquals((String)applicationDTO.getThrottlingPolicy(), (String)applicationInfoDTO.getPolicy());
            Assert.assertEquals((String)applicationDTO.getTokenType().getValue(), (String)applicationInfoDTO.getTokenType());
            Assert.assertEquals((Object)applicationDTO.getAttributes(), (Object)applicationInfoDTO.getAttributes());
            break;
        }
    }

    private void waitUntilApplicationKeyMappingAvailableInGateway(String applicationId, ApplicationKeyDTO applicationKeyDTO) throws APIManagerIntegrationTestException {
        if (Boolean.parseBoolean(this.disableVerification)) {
            return;
        }
        if ("APPROVED".equals(applicationKeyDTO.getKeyState())) {
            ApplicationInfoDTO applicationInfoDTO = this.restAPIGateway.retrieveApplication(applicationId);
            if (applicationInfoDTO != null) {
                log.info((Object)("Application Available in in-memory == " + applicationInfoDTO.toString()));
                if (applicationInfoDTO.getKeys() != null && applicationInfoDTO.getKeys().size() > 0) {
                    for (ApplicationKeyMappingDTO key : applicationInfoDTO.getKeys()) {
                        if (!key.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) || !key.getKeyType().equals(applicationKeyDTO.getKeyType().getValue())) continue;
                        return;
                    }
                }
            }
            for (long retries = 0L; retries <= 20L; ++retries) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                applicationInfoDTO = this.restAPIGateway.retrieveApplication(applicationId);
                if (applicationInfoDTO == null) continue;
                log.info((Object)("Application Available in in-memory == " + applicationInfoDTO.toString()));
                if (applicationInfoDTO.getKeys() == null || applicationInfoDTO.getKeys().size() <= 0) continue;
                for (ApplicationKeyMappingDTO key : applicationInfoDTO.getKeys()) {
                    if (!key.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) || !key.getKeyType().equals(applicationKeyDTO.getKeyType().getValue())) continue;
                    return;
                }
            }
        }
    }

    public ThrottlingPolicyListDTO getApplicationPolicies(String tenantDomain) throws ApiException {
        return this.throttlingPoliciesApi.throttlingPoliciesPolicyLevelGet(ThrottlingPolicyDTO.PolicyLevelEnum.APPLICATION.getValue(), Integer.valueOf(100), Integer.valueOf(0), null, tenantDomain);
    }

    public ApplicationKeyDTO generateKeys(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, ArrayList<String> scopes, List<String> grantTypes, String keyManager) throws ApiException, APIManagerIntegrationTestException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        applicationKeyGenerateRequest.setKeyManager(keyManager);
        ApiResponse response = this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.waitUntilApplicationKeyMappingAvailableInGateway(applicationId, (ApplicationKeyDTO)response.getData());
        return (ApplicationKeyDTO)response.getData();
    }

    public ApiResponse<ApplicationKeyDTO> generateKeysWithHttpInfo(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyTypeEnum, ArrayList<String> scopes, List<String> grantTypes, String keyManager) throws ApiException {
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = new ApplicationKeyGenerateRequestDTO();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setGrantTypesToBeSupported(grantTypes);
        applicationKeyGenerateRequest.setKeyManager(keyManager);
        return this.applicationKeysApi.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequest, this.tenantDomain);
    }

    public ApplicationKeyListDTO getApplicationOauthKeys(String applicationUUID, String tenantDomain) throws ApiException {
        return this.applicationKeysApi.applicationsApplicationIdOauthKeysGet(applicationUUID, tenantDomain);
    }
}

