/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.bean.DCRParamRequest;

public class ClientAuthenticator {
    public static final double JAVA_VERSION;
    private static TrustManager trustAll;
    private static String consumerKey;
    private static String consumerSecret;
    private static Map<String, ApplicationKeyBean> applicationKeyMap;
    private static final String TLS_PROTOCOL = "TLS";
    private static int count;

    public static String getAccessToken(String scopeList, String appName, String callBackURL, String tokenScope, String appOwner, String grantType, String dcrEndpoint, String username, String password, String tenantDomain, String tokenEndpoint) {
        HttpURLConnection urlConn = null;
        try {
            URL url = new URL(tokenEndpoint);
            urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            ApplicationKeyBean applicationKeyBean = applicationKeyMap.get(appName);
            String clientEncoded = DatatypeConverter.printBase64Binary((byte[])(applicationKeyBean.getConsumerKey() + ':' + applicationKeyBean.getConsumerSecret()).getBytes(StandardCharsets.UTF_8));
            urlConn.setRequestProperty("Authorization", "Basic " + clientEncoded);
            if (!"carbon.super".equalsIgnoreCase(tenantDomain) || username.contains("@")) {
                username = username + "@" + tenantDomain;
            }
            String postParams = "password".equals(grantType) ? "grant_type=password&username=" + username + "&password=" + password : "grant_type=client_credentials";
            if (!scopeList.isEmpty()) {
                postParams = postParams + "&scope=" + scopeList + " device_" + count;
            }
            ((HttpsURLConnection)urlConn).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
            sslContext.init(null, new TrustManager[]{trustAll}, new SecureRandom());
            ((HttpsURLConnection)urlConn).setSSLSocketFactory(sslContext.getSocketFactory());
            urlConn.getOutputStream().write(postParams.getBytes("UTF-8"));
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                String responseStr = ClientAuthenticator.getResponseString(urlConn.getInputStream());
                JsonParser parser = new JsonParser();
                JsonObject obj = parser.parse(responseStr).getAsJsonObject();
                ++count;
                String string = obj.get("access_token").getAsString();
                return string;
            }
            try {
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (Exception e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApplicationKeyBean makeDCRRequest(DCRParamRequest dcrParamRequest) {
        String applicationName = dcrParamRequest.getAppName();
        try {
            String clientEncoded;
            JsonObject json = new JsonObject();
            json.addProperty("callbackUrl", dcrParamRequest.getCallBackURL());
            json.addProperty("clientName", applicationName);
            json.addProperty("tokenScope", dcrParamRequest.getTokenScope());
            json.addProperty("grantType", dcrParamRequest.getGrantType());
            json.addProperty("saasApp", Boolean.valueOf(true));
            if (StringUtils.isEmpty((String)dcrParamRequest.getTenantDomain())) {
                json.addProperty("owner", dcrParamRequest.getAppOwner());
                clientEncoded = DatatypeConverter.printBase64Binary((byte[])(System.getProperty("systemUsername", dcrParamRequest.getUsername()) + ':' + System.getProperty("systemUserPwd", dcrParamRequest.getPassword())).getBytes(StandardCharsets.UTF_8));
            } else {
                json.addProperty("owner", dcrParamRequest.getUsername() + "@" + dcrParamRequest.getTenantDomain());
                clientEncoded = DatatypeConverter.printBase64Binary((byte[])(dcrParamRequest.getUsername() + "@" + dcrParamRequest.getTenantDomain() + ':' + dcrParamRequest.getPassword()).getBytes(StandardCharsets.UTF_8));
            }
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost();
            httpPost.setURI(URI.create(dcrParamRequest.getDcrEndpoint()));
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Authorization", "Basic " + clientEncoded);
            httpPost.setEntity((HttpEntity)new StringEntity(json.toString()));
            try (CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode != 200) throw new RuntimeException("DCR call failed. Status code: " + statusCode);
                try (InputStream content = httpResponse.getEntity().getContent();){
                    String responseStr = IOUtils.toString((InputStream)content);
                    ApplicationKeyBean applicationKeyBean = new ApplicationKeyBean();
                    JsonParser parser = new JsonParser();
                    JsonObject jObj = parser.parse(responseStr).getAsJsonObject();
                    applicationKeyBean.setConsumerKey(jObj.getAsJsonPrimitive("clientId").getAsString());
                    applicationKeyBean.setConsumerSecret(jObj.getAsJsonPrimitive("clientSecret").getAsString());
                    applicationKeyMap.put(dcrParamRequest.getAppName(), applicationKeyBean);
                    ApplicationKeyBean applicationKeyBean2 = applicationKeyBean;
                    return applicationKeyBean2;
                }
            }
        }
        catch (IOException e) {
            String errorMsg = "Can not create OAuth application  : " + applicationName;
            throw new RuntimeException(errorMsg, e);
        }
    }

    private static String getResponseString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String str;
            String file = "";
            while ((str = buffer.readLine()) != null) {
                file = file + str;
            }
            String string = file;
            return string;
        }
    }

    static {
        consumerKey = null;
        consumerSecret = null;
        applicationKeyMap = new HashMap<String, ApplicationKeyBean>();
        count = 0;
        JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
        trustAll = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }
}

