/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.wso2.am.integration.clients.service.catalog.api.ApiClient;
import org.wso2.am.integration.clients.service.catalog.api.ApiException;
import org.wso2.am.integration.clients.service.catalog.api.ApiResponse;
import org.wso2.am.integration.clients.service.catalog.api.v1.ServicesApi;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceInfoListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceListDTO;

public class RestAPIServiceCatalogImpl {
    private String tenantDomain = null;
    ServicesApi servicesApi = new ServicesApi();

    public RestAPIServiceCatalogImpl(String username, String password, String tenantDomain) {
        ApiClient apiClient = new ApiClient();
        String basicEncoded = DatatypeConverter.printBase64Binary((byte[])(username + ':' + password).getBytes(StandardCharsets.UTF_8));
        apiClient.addDefaultHeader("Authorization", "Basic " + basicEncoded);
        apiClient.setDebugging(true);
        apiClient.setBasePath("https://localhost:9943/api/am/service-catalog/v1");
        apiClient.setReadTimeout(600000);
        apiClient.setConnectTimeout(600000);
        apiClient.setWriteTimeout(600000);
        this.servicesApi.setApiClient(apiClient);
        this.tenantDomain = tenantDomain;
    }

    public ServiceListDTO retrieveServices(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset) throws ApiException {
        return this.servicesApi.searchServices(name, version, definitionType, key, shrink, sortBy, sortOrder, limit, offset);
    }

    public ServiceDTO createService(ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        return this.servicesApi.addService(serviceMetadata, definitionFile, inlineContent);
    }

    public ServiceDTO retrieveServiceById(String serviceId) throws ApiException {
        return this.servicesApi.getServiceById(serviceId);
    }

    public ServiceDTO updateService(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        return this.servicesApi.updateService(serviceId, serviceMetadata, definitionFile, inlineContent);
    }

    public ApiResponse deleteService(String serviceId) throws ApiException {
        return this.servicesApi.deleteServiceWithHttpInfo(serviceId);
    }

    public String retrieveServiceDefinition(String serviceId) throws ApiException {
        return this.servicesApi.getServiceDefinition(serviceId);
    }

    public APIListDTO retrieveServiceUsage(String serviceId) throws ApiException {
        return this.servicesApi.getServiceUsage(serviceId);
    }

    public ServiceInfoListDTO importService(File file, Boolean overwrite, String verifier) throws ApiException {
        return this.servicesApi.importService(file, overwrite, verifier);
    }

    public File exportService(String name, String version) throws ApiException {
        return this.servicesApi.exportService(name, version);
    }
}

