/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.bean;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationPolicyDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.AbstractRequest;

public class APIRequest
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(APIRequest.class);
    private String name;
    private String context;
    private JSONObject endpoint;
    private String visibility = "public";
    private String version = "1.0.0";
    private String description = "description";
    private String endpointType = "nonsecured";
    private String http_checked = "http";
    private String https_checked = "https";
    private String tags = "tags";
    private String tier = "Silver";
    private String thumbUrl = "";
    private String tiersCollection = "Gold";
    private String type = "HTTP";
    private String resourceCount = "0";
    private String resourceMethod = "GET,POST,PUT,PATCH,DELETE,HEAD";
    private String resourceMethodAuthType = "Application & Application User,Application & Application User";
    private String resourceMethodThrottlingTier = "Unlimited,Unlimited";
    private String uriTemplate = "/*";
    private String roles = "";
    private String wsdl = "";
    private String default_version = "";
    private String default_version_checked = "";
    private String sandbox = "";
    private String provider = "admin";
    private org.json.JSONObject corsConfiguration;
    private String environment = "Default";
    private String apiTier = "";
    private String accessControl;
    private String accessControlRoles;
    private String businessOwner;
    private String businessOwnerEmail;
    private String technicalOwner;
    private String technicalOwnerEmail;
    private List<String> securityScheme;
    private List<String> apiCategories;
    private List<String> keyManagers;
    private String subscriptionAvailability;
    private List<String> visibleTenants;
    private List<MediationPolicyDTO> mediationPolicies;
    private List<APIOperationsDTO> operationsDTOS;

    public List<String> getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public List<String> getSecurityScheme() {
        return this.securityScheme;
    }

    public void setSecurityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
    }

    public List<MediationPolicyDTO> getMediationPolicies() {
        return this.mediationPolicies;
    }

    public void setMediationPolicies(List<MediationPolicyDTO> mediationPolicies) {
        this.mediationPolicies = mediationPolicies;
    }

    public List<APIOperationsDTO> getOperationsDTOS() {
        return this.operationsDTOS;
    }

    public void setOperationsDTOS(List<APIOperationsDTO> operationsDTOS) {
        this.operationsDTOS = operationsDTOS;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public List<String> getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(List<String> keyManagers) {
        this.keyManagers = keyManagers;
    }

    public APIRequest(String apiName, String context, URL endpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + endpointUrl + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + endpointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\"\n}";
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse(endPointString);
            this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"JSON construct error", e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, URL endpointUrl, boolean isCORSEnabled) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + endpointUrl + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + endpointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\"\n}";
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse(endPointString);
            this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : " + isCORSEnabled + ", \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"JSON construct error", e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, String version, List<String> productionEndpoints, List<String> sandboxEndpoints) throws APIManagerIntegrationTestException {
        String uri;
        this.name = apiName;
        this.context = context;
        this.version = version;
        String productionEPs = "";
        String sandboxEPs = "";
        if (productionEndpoints != null) {
            for (String productionEndpoint : productionEndpoints) {
                uri = "{\n\"url\":\"" + productionEndpoint + "\",\n\"config\":null,\n\"template_not_supported\": false\n},";
                productionEPs = productionEPs + uri;
            }
            productionEPs = "\"production_endpoints\": [\n" + productionEPs + "],";
        }
        if (sandboxEndpoints != null) {
            for (String sandboxEndpoint : sandboxEndpoints) {
                uri = "{\n\"url\":\"" + sandboxEndpoint + "\",\n\"config\":null,\n\"template_not_supported\": false\n },";
                sandboxEPs = sandboxEPs + uri;
            }
            sandboxEPs = "\"sandbox_endpoints\": [\n" + sandboxEPs + "],";
        }
        try {
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse("{ \n" + productionEPs + "\"algoCombo\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\n\"failOver\":\"False\",\n\"algoClassName\":\"org.apache.synapse.endpoints.algorithms.RoundRobin\",\n\"sessionManagement\":\"\",\n" + sandboxEPs + "\"implementation_status\":\"managed\",\n\"endpoint_type\":\"load_balance\"\n}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"Error when constructing JSON", e);
            throw new APIManagerIntegrationTestException("Error when constructing JSON", e);
        }
    }

    public APIRequest(String apiName, String context) {
        this.name = apiName;
        this.context = context;
        this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
    }

    public APIRequest(String apiName, String context, URI productionEndpointUri, URI sandboxEndpointUri) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\":\"" + productionEndpointUri + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + sandboxEndpointUri + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"" + productionEndpointUri.getScheme() + "\"\n}";
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse(endPointString);
            this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"JSON construct error", e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, URL productionEndpointUrl, URL sandboxEndpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\":\"" + productionEndpointUrl + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + sandboxEndpointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"" + productionEndpointUrl.getProtocol() + "\"\n}";
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse(endPointString);
            this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"JSON construct error", e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, boolean prodEndpointAvailability, URL endpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            String endPointString = "{\n  \"sandbox_endpoints\": {\n    \"url\": \"" + endpointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\"\n}";
            if (prodEndpointAvailability) {
                endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + endpointUrl + "\"\n  },\n  \"endpoint_type\": \"http\"\n}";
            }
            JSONParser parser = new JSONParser();
            this.endpoint = (JSONObject)parser.parse(endPointString);
            this.corsConfiguration = new org.json.JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException | ParseException e) {
            log.error((Object)"JSON construct error", e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    @Override
    public void setAction() {
        this.setAction("addAPI");
    }

    @Override
    public void setAction(String action) {
        super.setAction(action);
    }

    @Override
    public void init() {
        this.addParameter("name", this.name);
        this.addParameter("context", this.context);
        this.addParameter("endpoint_config", this.endpoint.toString());
        this.addParameter("provider", this.getProvider());
        this.addParameter("visibility", this.getVisibility());
        this.addParameter("accessControl", this.getAccessControl());
        this.addParameter("accessControlRoles", this.getAccessControlRoles());
        this.addParameter("version", this.getVersion());
        this.addParameter("description", this.getDescription());
        this.addParameter("endpointType", this.getEndpointType());
        this.addParameter("http_checked", this.getHttp_checked());
        this.addParameter("https_checked", this.getHttps_checked());
        this.addParameter("tags", this.getTags());
        this.addParameter("tier", this.getTier());
        this.addParameter("thumbUrl", this.getThumbUrl());
        this.addParameter("tiersCollection", this.getTiersCollection());
        this.addParameter("type", this.getType());
        this.addParameter("resourceCount", this.getResourceCount());
        this.addParameter("resourceMethod-0", this.getResourceMethod());
        this.addParameter("resourceMethodAuthType-0", this.getResourceMethodAuthType());
        this.addParameter("resourceMethodThrottlingTier-0", this.getResourceMethodThrottlingTier());
        this.addParameter("uriTemplate-0", this.getUriTemplate());
        this.addParameter("default_version", this.getDefault_version());
        this.addParameter("default_version_checked", this.getDefault_version_checked());
        this.addParameter("environments", this.getEnvironment());
        this.addParameter("corsConfiguration", this.getCorsConfiguration().toString());
        this.addParameter("apiTier", this.getApiTier());
        if (this.roles.length() > 1) {
            this.addParameter("roles", this.getRoles());
        }
        if (this.wsdl.length() > 1) {
            this.addParameter("wsdl", this.getWsdl());
        }
        if (this.sandbox.length() > 1) {
            this.addParameter("sandbox", this.getSandbox());
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JSONObject getEndpointConfig() {
        return this.endpoint;
    }

    public String getContext() {
        return this.context;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public void setEndpoint(JSONObject endpoint) {
        this.endpoint = endpoint;
    }

    public String getHttp_checked() {
        return this.http_checked;
    }

    public void setHttp_checked(String http_checked) {
        this.http_checked = http_checked;
    }

    public String getHttps_checked() {
        return this.https_checked;
    }

    public void setHttps_checked(String https_checked) {
        this.https_checked = https_checked;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String getTiersCollection() {
        return this.tiersCollection;
    }

    public void setTiersCollection(String tiersCollection) {
        this.tiersCollection = tiersCollection;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceCount() {
        return this.resourceCount;
    }

    public void setResourceCount(String resourceCount) {
        this.resourceCount = resourceCount;
    }

    public String getResourceMethod() {
        return this.resourceMethod;
    }

    public void setResourceMethod(String resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public String getResourceMethodAuthType() {
        return this.resourceMethodAuthType;
    }

    public void setResourceMethodAuthType(String resourceMethodAuthType) {
        this.resourceMethodAuthType = resourceMethodAuthType;
    }

    public String getResourceMethodThrottlingTier() {
        return this.resourceMethodThrottlingTier;
    }

    public void setResourceMethodThrottlingTier(String resourceMethodThrottlingTier) {
        this.resourceMethodThrottlingTier = resourceMethodThrottlingTier;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getDefault_version() {
        return this.default_version;
    }

    public void setDefault_version(String default_version) {
        this.default_version = default_version;
    }

    public String getDefault_version_checked() {
        return this.default_version_checked;
    }

    public void setDefault_version_checked(String default_version_checked) {
        this.default_version_checked = default_version_checked;
    }

    public org.json.JSONObject getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(org.json.JSONObject corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public String getApiTier() {
        return this.apiTier;
    }

    public void setApiTier(String apiTier) {
        this.apiTier = apiTier;
    }

    public String getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(String accessControl) {
        this.accessControl = accessControl;
    }

    public String getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(String accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public String getBusinessOwner() {
        return this.businessOwner;
    }

    public void setBusinessOwner(String businessOwner) {
        this.businessOwner = businessOwner;
    }

    public String getBusinessOwnerEmail() {
        return this.businessOwnerEmail;
    }

    public void setBusinessOwnerEmail(String businessOwnerEmail) {
        this.businessOwnerEmail = businessOwnerEmail;
    }

    public String getTechnicalOwner() {
        return this.technicalOwner;
    }

    public void setTechnicalOwner(String technicalOwner) {
        this.technicalOwner = technicalOwner;
    }

    public String getTechnicalOwnerEmail() {
        return this.technicalOwnerEmail;
    }

    public void setTechnicalOwnerEmail(String technicalOwnerEmail) {
        this.technicalOwnerEmail = technicalOwnerEmail;
    }

    public void setApiCategories(List<String> apiCategories) {
        this.apiCategories = apiCategories;
    }

    public List<String> getApiCategories() {
        return this.apiCategories;
    }

    public String getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(String subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }
}

