/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.clients;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.bean.APIImplementationBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.AddDocumentRequestBean;
import org.wso2.am.integration.test.utils.bean.ClientCertificateCreationBean;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIPublisherRestClient {
    private static final Log log = LogFactory.getLog(APIPublisherRestClient.class);
    private String backendURL;
    private static final String URL_SUFFIX = "publisher-old/site/blocks";
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    public APIPublisherRestClient(String backendURL) {
        this.backendURL = backendURL;
        if (this.requestHeaders.get("Content-Type") == null) {
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    public HttpResponse login(String userName, String password) throws APIManagerIntegrationTestException {
        HttpResponse response;
        log.info((Object)("Login to Publisher " + this.backendURL + " as the user " + userName));
        ArrayList<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
        urlParameters.add((NameValuePair)new BasicNameValuePair("action", "login"));
        urlParameters.add((NameValuePair)new BasicNameValuePair("username", userName));
        urlParameters.add((NameValuePair)new BasicNameValuePair("password", password));
        try {
            response = HTTPSClientUtils.doPost(this.backendURL + URL_SUFFIX + "/user/login/ajax/login.jag", this.requestHeaders, urlParameters);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to login to the publisher app ", e);
        }
        String session = this.getSession(response.getHeaders());
        if (session == null) {
            throw new APIManagerIntegrationTestException("No session cookie found with response");
        }
        this.setSession(session);
        return response;
    }

    public HttpResponse logout() throws APIManagerIntegrationTestException {
        try {
            return HTTPSClientUtils.doGet(this.backendURL + URL_SUFFIX + "/user/login/ajax/login.jag?action=logout", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Failed to logout from publisher. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse addAPI(APIRequest apiRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/add.jag"), apiRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to add API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse copyAPI(String provider, String apiName, String oldVersion, String newVersion, String isDefaultVersion) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/overview/ajax/overview.jag"), "action=createNewAPI&provider=" + provider + "&apiName=" + apiName + "&version=" + oldVersion + "&newVersion=" + newVersion + "&isDefaultVersion=" + isDefaultVersion, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable copy API - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse updateAPI(APIRequest apiRequest) throws Exception {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/add.jag"), apiRequest.generateRequestParameters("updateAPI"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse changeAPILifeCycleStatus(APILifeCycleStateRequest updateRequest) throws APIManagerIntegrationTestException {
        try {
            Thread.sleep(1000L);
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/life-cycles/ajax/life-cycles.jag"), updateRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAPI(String apiName, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/listing/ajax/item-list.jag"), "action=getAPI&name=" + apiName + "&version=1.0.0&provider=" + provider + "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get API " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse deleteAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/remove.jag"), "action=removeAPI&name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get API - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    private String getSession(Map<String, String> responseHeaders) {
        return responseHeaders.get("Set-Cookie");
    }

    private String setSession(String session) {
        return this.requestHeaders.put("Cookie", session);
    }

    private void checkAuthentication() throws APIManagerIntegrationTestException {
        if (this.requestHeaders.get("Cookie") == null) {
            throw new APIManagerIntegrationTestException("No Session Cookie found. Please login first");
        }
    }

    public HttpResponse removeDocumentation(String apiName, String version, String provider, String docName, String docType) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/documentation/ajax/docs.jag"), "action=removeDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove document from API - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse revokeAccessToken(String accessToken, String consumerKey, String authUser) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/tokens/ajax/revokeToken.jag"), "action=revokeAccessToken&accessToken=" + accessToken + "&authUser=" + authUser + "&consumerKey=" + consumerKey, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to revoke access token. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse updatePermissions(String tierName, String permissionType, String roles) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/tiers/ajax/tiers.jag"), "action=updatePermissions&tierName=" + tierName + "&permissiontype=" + permissionType + "&roles=" + roles, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update permission. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse updateResourceOfAPI(String provider, String apiName, String version, String swaggerRes) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/item-design/ajax/add.jag"), "action=manage&provider=" + provider + "&name=" + apiName + "&version=" + version + "&swagger=" + swaggerRes, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update resource of API - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAPI(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/listing/ajax/item-list.jag"), "action=getAPI&name=" + apiName + "&version=" + version + "&provider=" + provider + "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve API information - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse checkValidEndpoint(String type, String endpointUrl, String providerName, String apiName, String apiVersion) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/add.jag"), "action=isURLValid&type=" + type + "&url=" + endpointUrl + "&providerName=" + providerName + "&apiName=" + apiName + "&apiVersion=" + apiVersion, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Check for valid endpoint fails for " + endpointUrl + ". Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse changeAPILifeCycleStatusToPublish(APIIdentifier apiIdentifier, boolean isRequireReSubscription) throws APIManagerIntegrationTestException {
        try {
            Thread.sleep(1000L);
            this.checkAuthentication();
            APILifeCycleStateRequest publishUpdateRequest = new APILifeCycleStateRequest(apiIdentifier.getApiName(), apiIdentifier.getProviderName(), APILifeCycleState.PUBLISHED);
            publishUpdateRequest.setVersion(apiIdentifier.getVersion());
            if (isRequireReSubscription) {
                publishUpdateRequest.setRequireResubscription("true");
            }
            String requestParameters = publishUpdateRequest.generateRequestParameters();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/life-cycles/ajax/life-cycles.jag"), requestParameters, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when change he lifecycle to publish. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getApi(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/listing/ajax/item-list.jag"), "action=getAPI&name=" + apiName + "&version=" + version + "&provider=" + provider + "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving a API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getTierPermissionsPage() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "/publisher-old/site/pages/tiers.jag", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAPIManagePage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "/publisher-old/manage?name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Manage page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAPIInformationPage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/info"), "name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Information page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse addDocument(String apiName, String version, String provider, String docName, String docType, String sourceType, String docUrl, String summary, String docLocation, String mimeType, String newType) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + URL_SUFFIX + "/documentation/ajax/docs.jag"), "action=addDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType + "&sourceType=" + sourceType + "&docUrl=" + docUrl + "&summary=" + summary + "&docLocation=" + docLocation + "&mimeType=" + mimeType + "&newType=" + newType, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse addDocument(String apiName, String version, String provider, String docName, String docType, String sourceType, String docUrl, String summary, String docLocation) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/documentation/ajax/docs.jag"), "action=addDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType + "&sourceType=" + sourceType + "&docUrl=" + docUrl + "=&summary=" + summary + "&docLocation=" + docLocation, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse addDocument(AddDocumentRequestBean addDocRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/documentation/ajax/docs.jag"), "action=addDocumentation&provider=" + addDocRequestBean.getApiProvider() + "&apiName=" + addDocRequestBean.getApiName() + "&version=" + addDocRequestBean.getApiVersion() + "&docName=" + addDocRequestBean.getDocName() + "&docType=" + addDocRequestBean.getDocType() + "&sourceType=" + addDocRequestBean.getDocSourceType() + "&docUrl=" + addDocRequestBean.getDocUrl() + "=&summary=" + addDocRequestBean.getDocSummary() + "&docLocation=" + addDocRequestBean.getDocLocation() + "&mimeType=" + addDocRequestBean.getMimeType() + "&optionsRadios=" + addDocRequestBean.getDocType() + "&optionsRadios1=" + addDocRequestBean.getDocSourceType(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse updateDocument(String apiName, String version, String provider, String docName, String content) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/documentation/ajax/docs.jag"), "action=addInlineContent&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&content=" + content, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when adding inline content to a document. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAllAPIs() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "/publisher-old/site/blocks/listing/ajax/item-list.jag?action=getAllAPIs", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Retrieve the All APIs available for the user in Publisher. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse addAPI(APICreationRequestBean creationRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-add/ajax/add.jag"), creationRequestBean.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding the New API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse uploadCertificate(ClientCertificateCreationBean clientCertificateCreationBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-design/ajax/add.jag"), clientCertificateCreationBean.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding the New API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse updateAPI(APICreationRequestBean creationRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-add/ajax/add.jag"), creationRequestBean.generateRequestParameters("updateAPI"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Retrieve the All APIs available for the user in Publisher. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse designAPI(APIDesignBean designBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-design/ajax/add.jag"), designBean.generateRequestParameters("design"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to design API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse implement(APIImplementationBean implementationBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-design/ajax/add.jag?"), implementationBean.generateRequestParameters("implement"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to prototype API. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getAPIImplementPage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "/publisher-old/prototype?name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Implement page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse checkValidAPIName(String apiName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-add/ajax/add.jag"), "action=isAPINameExist&apiName=" + apiName, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exeption when adding a new API with existing API name. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse getTiers() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-add/ajax/add.jag"), "action=getTiers", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse validateRoles(String role) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/publisher-old/site/blocks/item-add/ajax/add.jag"), "action=validateRoles&roles=" + role, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page. Error: " + e.getMessage(), e);
        }
    }
}

