/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.wso2.am.integration.clients.gateway.api.ApiClient;
import org.wso2.am.integration.clients.gateway.api.ApiException;
import org.wso2.am.integration.clients.gateway.api.v2.DeployApiApi;
import org.wso2.am.integration.clients.gateway.api.v2.GetApiArtifactsApi;
import org.wso2.am.integration.clients.gateway.api.v2.GetApiInfoApi;
import org.wso2.am.integration.clients.gateway.api.v2.GetApplicationInfoApi;
import org.wso2.am.integration.clients.gateway.api.v2.GetSubscriptionInfoApi;
import org.wso2.am.integration.clients.gateway.api.v2.UndeployApiApi;
import org.wso2.am.integration.clients.gateway.api.v2.dto.APIArtifactDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.APIInfoDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.EndpointsDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.LocalEntryDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SequencesDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;

public class RestAPIGatewayImpl {
    private String tenantDomain = null;
    GetApiArtifactsApi getApiArtifactsApi = new GetApiArtifactsApi();
    DeployApiApi deployApiApi = new DeployApiApi();
    UndeployApiApi undeployApiApi = new UndeployApiApi();
    GetApiInfoApi apiInfoApi = new GetApiInfoApi();
    GetApplicationInfoApi applicationInfoApi = new GetApplicationInfoApi();
    GetSubscriptionInfoApi subscriptionInfoApi = new GetSubscriptionInfoApi();

    public RestAPIGatewayImpl(String username, String password, String tenantDomain) {
        ApiClient apiClient = new ApiClient();
        String basicEncoded = DatatypeConverter.printBase64Binary((byte[])(username + ':' + password).getBytes(StandardCharsets.UTF_8));
        apiClient.addDefaultHeader("Authorization", "Basic " + basicEncoded);
        apiClient.setDebugging(true);
        apiClient.setBasePath("https://localhost:9943/api/am/gateway/v2");
        apiClient.setReadTimeout(600000);
        apiClient.setConnectTimeout(600000);
        apiClient.setWriteTimeout(600000);
        this.getApiArtifactsApi.setApiClient(apiClient);
        this.deployApiApi.setApiClient(apiClient);
        this.undeployApiApi.setApiClient(apiClient);
        this.apiInfoApi.setApiClient(apiClient);
        this.applicationInfoApi.setApiClient(apiClient);
        this.subscriptionInfoApi.setApiClient(apiClient);
        this.tenantDomain = tenantDomain;
    }

    public APIArtifactDTO retrieveAPI(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.getAPIArtifacts(name, version, this.tenantDomain);
    }

    public EndpointsDTO retrieveEndpoints(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.getEndpoints(name, version, this.tenantDomain);
    }

    public LocalEntryDTO retrieveLocalEntries(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.getLocalEntries(name, version, this.tenantDomain);
    }

    public SequencesDTO retrieveSequences(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.getSequences(name, version, this.tenantDomain);
    }

    public SubscriptionDTO retrieveSubscription(String apiId, String applicationId) throws APIManagerIntegrationTestException {
        try {
            return this.subscriptionInfoApi.subscriptionsGet(apiId, applicationId, this.tenantDomain);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw new APIManagerIntegrationTestException(e);
        }
    }

    public ApplicationInfoDTO retrieveApplication(String applicationId) throws APIManagerIntegrationTestException {
        try {
            ApplicationListDTO applicationListDTO = this.applicationInfoApi.applicationsGet(null, applicationId, this.tenantDomain);
            if (applicationListDTO != null && applicationListDTO.getList() != null) {
                for (ApplicationInfoDTO applicationInfoDTO : applicationListDTO.getList()) {
                    if (!applicationInfoDTO.getUuid().equals(applicationId)) continue;
                    return applicationInfoDTO;
                }
            }
        }
        catch (ApiException e) {
            throw new APIManagerIntegrationTestException(e);
        }
        return null;
    }

    public APIInfoDTO getAPIInfo(String apiId) throws APIManagerIntegrationTestException {
        try {
            return this.apiInfoApi.apisApiIdGet(apiId, this.tenantDomain);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw new APIManagerIntegrationTestException(e);
        }
    }
}

