/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockServerUtils {
    private static final Log log = LogFactory.getLog(MockServerUtils.class);
    public static String LOCALHOST = "localhost";
    public static final int httpPortLowerRange = 8080;
    public static final int httpPortUpperRange = 8099;
    public static final int httpsPortLowerRange = 9950;
    public static final int httpsPortUpperRange = 9999;
    private static final int[] reservedPorts = new int[]{9960};
    private static int httpOffset = 0;
    private static int httpsOffset = 0;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortFree(int port, String host) {
        if (MockServerUtils.isPortReserved(port)) {
            return false;
        }
        Socket s = null;
        try {
            s = new Socket(host, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort(String host, boolean isHttps) {
        Object object = lock;
        synchronized (object) {
            int lowerPortLimit;
            int upperPortLimit;
            int offset;
            if (isHttps) {
                offset = httpsOffset;
                upperPortLimit = 9999;
                lowerPortLimit = 9950;
            } else {
                offset = httpOffset;
                upperPortLimit = 8099;
                lowerPortLimit = 8080;
            }
            int portRangeLen = upperPortLimit - lowerPortLimit;
            int targetPort = lowerPortLimit + offset % (portRangeLen + 1);
            for (int i = 0; i < portRangeLen; ++i) {
                if (MockServerUtils.isPortFree(targetPort, host)) {
                    if (isHttps) {
                        httpsOffset = (httpsOffset + i + 1) % (portRangeLen + 1);
                    } else {
                        httpOffset = (httpOffset + i + 1) % (portRangeLen + 1);
                    }
                    log.info((Object)("Port " + targetPort + " selected for mock server."));
                    return targetPort;
                }
                if (++targetPort <= upperPortLimit) continue;
                targetPort = lowerPortLimit;
            }
            return -1;
        }
    }

    private static boolean isPortReserved(int port) {
        for (int prohibitedPort : reservedPorts) {
            if (port != prohibitedPort) continue;
            return true;
        }
        return false;
    }

    static {
        Random random = new Random();
        httpOffset = random.nextInt(20) + 8080;
        httpsOffset = random.nextInt(50) + 9950;
        lock = new Object();
    }
}

