/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils;

import java.io.IOException;
import java.net.Socket;

public class ServerPortsUtils {
    public static String LOCALHOST = "localhost";
    public static final int httpPortLowerRange = 8080;
    public static final int httpPortUpperRange = 8099;
    public static final int httpsPortLowerRange = 9950;
    public static final int httpsPortUpperRange = 9999;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortFree(int port, String host) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    public static int getAvailableHttpPort(String host) {
        return ServerPortsUtils.getAvailablePort(8080, 8099, host);
    }

    public static int getAvailableHttpsPort(String host) {
        return ServerPortsUtils.getAvailablePort(9950, 9999, host);
    }

    private static int getAvailablePort(int lowerPortLimit, int upperPortLimit, String host) {
        while (lowerPortLimit < upperPortLimit) {
            if (ServerPortsUtils.isPortFree(lowerPortLimit, host)) {
                return lowerPortLimit;
            }
            ++lowerPortLimit;
        }
        return -1;
    }
}

