/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.monitor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;

class WireMonitor
extends Thread {
    private Log log = LogFactory.getLog(WireMonitor.class);
    private int port;
    private ServerSocket providerSocket;
    private Socket connection = null;
    private WireMonitorServer trigger;

    @Override
    public void run() {
        try (ServerSocket providerSocket = new ServerSocket(this.port, 10);
             Socket connection = providerSocket.accept();
             InputStream in = connection.getInputStream();
             OutputStream out = connection.getOutputStream();){
            int ch;
            this.log.info((Object)"Waiting for connection");
            this.log.info((Object)("Connection received from " + connection.getInetAddress().getHostName()));
            StringBuilder buffer = new StringBuilder();
            StringBuffer headerBuffer = new StringBuffer();
            Long time = System.currentTimeMillis();
            int contentLength = -1;
            while ((ch = in.read()) != 1 && in.available() > 0) {
                buffer.append((char)ch);
                if (contentLength == -1 && buffer.toString().endsWith("\r\n\r\n")) {
                    headerBuffer = new StringBuffer(buffer.toString());
                    if (buffer.toString().contains("Content-Length")) {
                        String headers = buffer.toString();
                        String contentLengthHeader = headers.substring(headers.indexOf("Content-Length:"));
                        contentLengthHeader = contentLengthHeader.substring(0, contentLengthHeader.indexOf("\r\n"));
                        contentLength = Integer.parseInt(contentLengthHeader.split(":")[1].trim());
                        buffer.setLength(0);
                    }
                }
                if (buffer.toString().length() != contentLength && System.currentTimeMillis() <= time + (long)this.trigger.READ_TIME_OUT && !buffer.toString().contains("</soapenv:Envelope>")) continue;
            }
            this.trigger.response = headerBuffer.toString() + buffer.toString();
            this.trigger.setFinished(true);
            out.write("HTTP/1.1 202 Accepted\r\n\r\n".getBytes(Charset.defaultCharset()));
            out.flush();
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Wire monitor error occurred", ioException);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error occurred", (Throwable)e);
        }
    }

    public WireMonitor(int listenPort, WireMonitorServer trigger) {
        this.port = listenPort;
        this.trigger = trigger;
    }
}

