/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDeploymentUtil {
    private static Log log = LogFactory.getLog(ServiceDeploymentUtil.class);

    public static boolean isServiceWSDlExist(String wsdlURL, long synchronizingDelay) throws IOException {
        log.info((Object)("waiting " + synchronizingDelay + " millis for Proxy deployment in worker"));
        boolean isServiceDeployed = false;
        long startTimeMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMs < synchronizingDelay) {
            if (ServiceDeploymentUtil.isWSDLAvailable(wsdlURL)) {
                isServiceDeployed = true;
                log.info((Object)("Proxy Deployed in " + (System.currentTimeMillis() - startTimeMs) + " millis in worker"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {
                log.warn((Object)"Thread  interrupted ", (Throwable)ignored);
            }
        }
        return isServiceDeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWSDLAvailable(String serviceEndpoint) throws IOException {
        URL url = new URL(serviceEndpoint + "?wsdl");
        boolean isWsdlExist = false;
        BufferedReader rd = null;
        HttpURLConnection conn = null;
        try {
            String line;
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(6000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = rd.readLine()) != null) {
                sb.append(line);
                if (!sb.toString().contains("wsdl:definitions")) continue;
                isWsdlExist = true;
                break;
            }
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return isWsdlExist;
    }
}

