/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.resourcebrowse;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class ResourceBrowsePage {
    private static final Log log = LogFactory.getLog(ResourceBrowsePage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public ResourceBrowsePage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        UIElementMapper uiElementMapper = UIElementMapper.getInstance();
        if (!driver.getCurrentUrl().contains("resources")) {
            throw new IllegalStateException("This is not the resource Browse page");
        }
    }

    public ResourceBrowsePage addLifeCycle(String lifeCycleName) throws IOException {
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("resource.lifecycle.minimized"))).click();
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("resource.lifecycle.add"))).click();
        Select lifeCycles = new Select(this.driver.findElement(By.id((String)this.uiElementMapper.getElement("resource.lifecycle.add.select.id"))));
        List lifeCycleList = lifeCycles.getOptions();
        boolean isALifeCycle = false;
        for (WebElement webElement : lifeCycleList) {
            String name = webElement.getText();
            if (!name.equals(lifeCycleName)) continue;
            isALifeCycle = true;
            break;
        }
        if (isALifeCycle) {
            this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("resource.lifecycle.add.button.add"))).click();
        } else {
            log.error((Object)("Life cycle " + lifeCycleName + " does not exist"));
        }
        return new ResourceBrowsePage(this.driver);
    }
}

