/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.metadata;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.am.integration.ui.pages.login.LoginPage;
import org.wso2.am.integration.ui.pages.resourcebrowse.ResourceBrowsePage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class ApiPage {
    private static final Log log = LogFactory.getLog(ApiPage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public ApiPage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        driver.findElement(By.id((String)this.uiElementMapper.getElement("carbon.Main.tab"))).click();
        driver.findElement(By.linkText((String)this.uiElementMapper.getElement("api.add.link"))).click();
        log.info((Object)"API Add Page");
        if (!driver.findElement(By.id((String)this.uiElementMapper.getElement("api.dashboard.middle.text"))).getText().contains("API")) {
            throw new IllegalStateException("This is not the API  Add Page");
        }
    }

    public ResourceBrowsePage uploadApi(String provider, String name, String context, String version) throws InterruptedException, IOException {
        WebElement apiProvider = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("api.provider.id")));
        apiProvider.sendKeys(new CharSequence[]{provider});
        WebElement apiName = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("api.name.id")));
        apiName.sendKeys(new CharSequence[]{name});
        WebElement apiContext = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("api.context.id")));
        apiContext.sendKeys(new CharSequence[]{context});
        WebElement apiVersion = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("api.version.id")));
        apiVersion.sendKeys(new CharSequence[]{version});
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("addEditArtifact()", new Object[0]);
        log.info((Object)"successfully Saved");
        return new ResourceBrowsePage(this.driver);
    }

    public LoginPage logout() throws IOException {
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("home.greg.sign.out.xpath"))).click();
        return new LoginPage(this.driver);
    }
}

