/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.apimanager.store;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Select;
import org.wso2.am.integration.ui.pages.apimanager.subscription.SubscriptionPage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class ApiStorePage {
    private static final Log log = LogFactory.getLog(ApiStorePage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public ApiStorePage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        if (!driver.findElement(By.className((String)this.uiElementMapper.getElement("app.api.manager.class.name.text"))).getText().contains("APIs")) {
            throw new IllegalStateException("This is not the api home Page");
        }
    }

    public SubscriptionPage subscribeToApiManager(String appName) throws IOException, InterruptedException {
        this.driver.findElement(By.cssSelector((String)this.uiElementMapper.getElement("app.factory.subscribe.api.element"))).click();
        Thread.sleep(15000L);
        new Select(this.driver.findElement(By.id((String)this.uiElementMapper.getElement("app.api.select.app.name")))).selectByVisibleText(appName);
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("app.api.subscribe.button"))).click();
        Thread.sleep(10000L);
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("app.go.to.subscriptions.text"))).click();
        return new SubscriptionPage(this.driver);
    }

    public SubscriptionPage gotoSubscribeAPiPage() throws IOException, InterruptedException {
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("app.factory.subscription.page"))).click();
        Thread.sleep(30000L);
        return new SubscriptionPage(this.driver);
    }
}

