/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.tenant;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.wso2.am.integration.ui.pages.login.LoginPage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class TenantListpage {
    private static final Log log = LogFactory.getLog(TenantListpage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public TenantListpage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        log.info((Object)"New Tenant list page");
        if (!driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.role.dashboard.middle.text"))).getText().contains("Tenants List")) {
            throw new IllegalStateException("This is not the correct Page");
        }
    }

    public boolean checkOnUplodedTenant(String tenantName) throws InterruptedException {
        log.info((Object)("---------------------------->>>> " + tenantName));
        Thread.sleep(5000L);
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("configure.tab.id"))).click();
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("view.tenant.link"))).click();
        String tenantNameOnServer = this.driver.findElement(By.xpath((String)"/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div[2]/div/table/tbody/tr/td")).getText();
        log.info((Object)tenantNameOnServer);
        if (tenantName.equals(tenantNameOnServer)) {
            log.info((Object)"newly Created notification exists");
            return true;
        }
        String resourceXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div[2]/div/table/tbody/tr[";
        String resourceXpath2 = "]/td";
        for (int i = 2; i < 10; ++i) {
            String tenantNameOnAppserver = resourceXpath + i + resourceXpath2;
            String actualUsername = this.driver.findElement(By.xpath((String)tenantNameOnAppserver)).getText();
            log.info((Object)("val on app is -------> " + actualUsername));
            log.info((Object)("Correct is    -------> " + tenantName));
            try {
                if (!tenantName.equals(actualUsername)) continue;
                log.info((Object)"newly Created Organization   exists");
                return true;
            }
            catch (NoSuchElementException ex) {
                log.info((Object)"Cannot Find the newly Created organization");
                return false;
            }
        }
        return false;
    }

    public LoginPage logout() throws IOException {
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("home.greg.sign.out.xpath"))).click();
        return new LoginPage(this.driver);
    }
}

