/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.tenant;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.wso2.am.integration.ui.pages.login.LoginPage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class TenantHomePage {
    private static final Log log = LogFactory.getLog(TenantHomePage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public TenantHomePage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        driver.findElement(By.id((String)this.uiElementMapper.getElement("configure.tab.id"))).click();
        driver.findElement(By.linkText((String)this.uiElementMapper.getElement("add.new.tenant.link.text"))).click();
        log.info((Object)"New Tenant add page");
        if (!driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.role.dashboard.middle.text"))).getText().contains("Register A New Organization")) {
            throw new IllegalStateException("This is not the correct Page");
        }
    }

    public void addNewTenant(String tenantDomain, String tenantFirstName, String tenantLastName, String adminUsername, String adminPassWord, String email) throws InterruptedException, IOException {
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.domain"))).sendKeys(new CharSequence[]{tenantDomain});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.first.name"))).sendKeys(new CharSequence[]{tenantFirstName});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.last.name"))).sendKeys(new CharSequence[]{tenantLastName});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.admin.user.name"))).sendKeys(new CharSequence[]{adminUsername});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.admin.password"))).sendKeys(new CharSequence[]{adminPassWord});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.admin.password.repeat"))).sendKeys(new CharSequence[]{adminPassWord});
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("tenant.admin.email.id"))).sendKeys(new CharSequence[]{email});
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("addTenant(false, true)", new Object[0]);
        Thread.sleep(7000L);
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("add.new.tenant.success.button"))).click();
    }

    public LoginPage logout() throws IOException {
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("home.greg.sign.out.xpath"))).click();
        return new LoginPage(this.driver);
    }
}

