/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.apimanager.subscription;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.wso2.am.integration.ui.pages.apimanager.ApiManagerHomePage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class SubscriptionPage {
    private static final Log log = LogFactory.getLog(SubscriptionPage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public SubscriptionPage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        if (!driver.getCurrentUrl().contains("subscriptions.jag")) {
            throw new IllegalStateException("This is not the Api Manager subscription");
        }
    }

    public void generateKeys() throws IOException, InterruptedException {
        this.driver.manage().window().maximize();
        Thread.sleep(5000L);
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("app.api.key.generate.text"))).click();
        Thread.sleep(10000L);
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("app.api.key.generate.text"))).click();
        Thread.sleep(10000L);
        String sandboxDetails = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("app.api.sandbox.details.id"))).getText();
        log.info((Object)"--------------------------------------------------------------------------");
        log.info((Object)sandboxDetails);
        String productionDetails = this.driver.findElement(By.id((String)this.uiElementMapper.getElement("app.api.production.details.id"))).getText();
        log.info((Object)productionDetails);
        log.info((Object)"----------------------------------------------------------------------");
        log.info((Object)"Sand box And production details are added");
    }

    public ApiManagerHomePage gotoApiManagerHomePage() throws IOException {
        try {
            Set handles = this.driver.getWindowHandles();
            String current = this.driver.getWindowHandle();
            handles.remove(current);
            String newTab = (String)handles.iterator().next();
            this.driver.switchTo().window(newTab);
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
        log.info((Object)"shifted to the app factory tab");
        return new ApiManagerHomePage(this.driver);
    }

    public void refresh() throws InterruptedException {
        log.info((Object)"page is refreshing");
        Thread.sleep(20000L);
        this.driver.navigate().refresh();
    }

    public void selectApp(String appKey) throws InterruptedException, IOException {
        log.info((Object)"selecting the application");
        Thread.sleep(5000L);
        String xpath1 = "/html/body/div[4]/div[7]/div/div[2]/div[2]/div/div/a";
        String applicationKey = this.driver.findElement(By.xpath((String)xpath1)).getText();
        if (appKey.equals(applicationKey)) {
            this.generateKeys();
        } else {
            String constructXpath1 = "/html/body/div[4]/div[7]/div/div[2]/div[2]/div[";
            String constructXpath2 = "]/div/a";
            for (int i = 2; i < 10; ++i) {
                String actualXpath = constructXpath1 + i + constructXpath2;
                String applicationKeyValue = this.driver.findElement(By.xpath((String)actualXpath)).getText();
                log.info((Object)("val on app is -------> " + applicationKeyValue));
                log.info((Object)("Correct is    -------> " + appKey));
                if (!appKey.equals(applicationKeyValue)) continue;
                this.driver.findElement(By.xpath((String)actualXpath)).click();
                Thread.sleep(2000L);
                String showKeysXpath1 = "/html/body/div[4]/div[7]/div/div[2]/div[2]/div[" + i + "]/div[2]/div/div/div/div[2]/div/div/div/a";
                String showKeyXpath2 = "/html/body/div[4]/div[7]/div/div[2]/div[2]/div[" + i + "]/div[2]/div/div/div/div[2]/div/div[2]/div/a";
                Thread.sleep(2000L);
                this.driver.findElement(By.xpath((String)showKeysXpath1)).click();
                Thread.sleep(2000L);
                this.driver.findElement(By.xpath((String)showKeyXpath2)).click();
                Thread.sleep(2000L);
                String productionAndSandBoxDetails = "appDetails" + (i - 1) + "_super";
                String allDetails = this.driver.findElement(By.id((String)productionAndSandBoxDetails)).getText();
                log.info((Object)"--------------------------------------------------------------------------");
                log.info((Object)allDetails);
                log.info((Object)"----------------------------------------------------------------------");
                log.info((Object)"Sand box And production details are added");
                break;
            }
            log.info((Object)"Application Not found");
        }
        this.driver.findElement(By.linkText((String)appKey)).click();
        log.info((Object)"application is selected");
    }
}

