/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.ui.pages.apimanager.apilist;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Select;
import org.wso2.am.integration.ui.pages.login.LoginPage;
import org.wso2.am.integration.ui.pages.util.UIElementMapper;

public class ApiListPage {
    private static final Log log = LogFactory.getLog(ApiListPage.class);
    private WebDriver driver;
    private UIElementMapper uiElementMapper;

    public ApiListPage(WebDriver driver) throws IOException {
        this.driver = driver;
        this.uiElementMapper = UIElementMapper.getInstance();
        driver.findElement(By.id((String)this.uiElementMapper.getElement("carbon.Main.tab"))).click();
        driver.findElement(By.linkText((String)this.uiElementMapper.getElement("api.list.link"))).click();
        log.info((Object)"API List Page");
        if (!driver.findElement(By.id((String)this.uiElementMapper.getElement("api.dashboard.middle.text"))).getText().contains("API List")) {
            throw new IllegalStateException("This is not the API  Add Page");
        }
    }

    public boolean checkOnUploadApi(String apiName) throws InterruptedException {
        log.info((Object)apiName);
        this.driver.navigate().refresh();
        String firstElementXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div/div/form[4]/table/tbody/tr/td/a";
        String apiNameOnServer = this.driver.findElement(By.xpath((String)firstElementXpath)).getText();
        log.info((Object)apiNameOnServer);
        if (apiName.equals(apiNameOnServer)) {
            log.info((Object)"Uploaded Api exists");
            return true;
        }
        String resourceXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div/div/form[4]/table/tbody/tr[";
        String resourceXpath2 = "]/td/a";
        for (int i = 2; i < 10; ++i) {
            String apiNameOnAppServer = resourceXpath + i + resourceXpath2;
            String actualApiName = this.driver.findElement(By.xpath((String)apiNameOnAppServer)).getText();
            log.info((Object)("val on app is -------> " + actualApiName));
            log.info((Object)("Correct is    -------> " + apiName));
            try {
                if (apiName.contains(actualApiName)) {
                    log.info((Object)"Uploaded API    exists");
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException ex) {
                log.info((Object)"Cannot Find the Uploaded API");
                continue;
            }
        }
        return false;
    }

    public void lifeCyclePromotion(String lifeCycleName) throws InterruptedException {
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.expand.id"))).click();
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("life.cycle.add"))).click();
        new Select(this.driver.findElement(By.id((String)"aspect"))).selectByVisibleText(lifeCycleName);
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("addAspect()", new Object[0]);
        String lifeCycleStage = this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("life.cycle.stage"))).getText();
        if (lifeCycleStage.contains("Development")) {
            log.info((Object)"lifecycle is at the Testing stage");
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option"))).click();
            Thread.sleep(1500L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option1"))).click();
            Thread.sleep(3000L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option2"))).click();
            Thread.sleep(1500L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.promote"))).click();
            this.driver.findElement(By.cssSelector((String)this.uiElementMapper.getElement("life.cycle.promote.ok.button"))).click();
            String nextLifeCycleStage = this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("life.cycle.stage"))).getText();
            if (!nextLifeCycleStage.contains("Testing")) {
                log.info((Object)"lifecycle is not  at the Testing stage");
                throw new NoSuchElementException();
            }
        } else {
            log.info((Object)"lifecycle is not  at the Development stage");
            throw new NoSuchElementException();
        }
        log.info((Object)"lifecycle is at the Testing stage");
        String lifeCycleStage2 = this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("life.cycle.stage"))).getText();
        if (lifeCycleStage2.contains("Testing")) {
            log.info((Object)"lifecycle is promoting from  Testing stage");
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option"))).click();
            Thread.sleep(1000L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option1"))).click();
            Thread.sleep(1000L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.add.option2"))).click();
            Thread.sleep(1000L);
            this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.promote"))).click();
            this.driver.findElement(By.cssSelector((String)this.uiElementMapper.getElement("life.cycle.promote.ok.button"))).click();
            Thread.sleep(1000L);
            String FinalLifeCycleStage = this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("life.cycle.stage"))).getText();
            if (!FinalLifeCycleStage.contains("Production")) {
                log.info((Object)"lifecycle is not at the production stage");
                throw new NoSuchElementException();
            }
        } else {
            log.info((Object)"cannot promote the lifecycle its not at the Testing stage");
            throw new NoSuchElementException();
        }
        log.info((Object)"lifecycle is at the production stage");
        this.driver.findElement(By.id((String)this.uiElementMapper.getElement("life.cycle.publish"))).click();
        this.driver.findElement(By.cssSelector((String)this.uiElementMapper.getElement("life.cycle.promote.ok.button"))).click();
    }

    public boolean promoteApiLifecycle(String apiName, String lifeCycleName) throws InterruptedException {
        log.info((Object)apiName);
        Thread.sleep(5000L);
        String firstElementXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div/div/form[4]/table/tbody/tr/td/a";
        String apiNameOnServer = this.driver.findElement(By.xpath((String)firstElementXpath)).getText();
        log.info((Object)apiNameOnServer);
        if (apiName.equals(apiNameOnServer)) {
            log.info((Object)"Uploaded Api exists");
            this.driver.findElement(By.xpath((String)firstElementXpath)).click();
            this.lifeCyclePromotion(lifeCycleName);
            return true;
        }
        String resourceXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div/div/form[4]/table/tbody/tr[";
        String resourceXpath2 = "]/td/a";
        for (int i = 2; i < 10; ++i) {
            String apiNameOnAppServer = resourceXpath + i + resourceXpath2;
            String actualApiName = this.driver.findElement(By.xpath((String)apiNameOnAppServer)).getText();
            log.info((Object)("val on app is -------> " + actualApiName));
            log.info((Object)("Correct is    -------> " + apiName));
            try {
                if (apiName.contains(actualApiName)) {
                    log.info((Object)"Uploaded API    exists");
                    this.driver.findElement(By.xpath((String)apiNameOnAppServer)).click();
                    this.lifeCyclePromotion(lifeCycleName);
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException ex) {
                log.info((Object)"Cannot Find the Uploaded API");
                continue;
            }
        }
        return false;
    }

    public boolean checkFilterStatePersistence(String lifecycleName, String lifecycleState) {
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("api.list.link"))).click();
        String lcState = lifecycleState;
        String lcName = lifecycleName;
        new Select(this.driver.findElement(By.id((String)"stateList"))).selectByVisibleText(lcState);
        new Select(this.driver.findElement(By.id((String)"lifeCycleList"))).selectByVisibleText(lcName);
        this.driver.findElement(By.xpath((String)this.uiElementMapper.getElement("filter.search.button"))).click();
        String listSecondPageXpath = "/html/body/table/tbody/tr[2]/td[3]/table/tbody/tr[2]/td/div/div/form[4]/table[2]/tbody/tr/td/a[2]";
        try {
            String paginationText = this.driver.findElement(By.xpath((String)listSecondPageXpath)).getText();
            if (paginationText.equals("2")) {
                this.driver.findElement(By.xpath((String)listSecondPageXpath)).click();
                String newlcState = new Select(this.driver.findElement(By.id((String)"stateList"))).getFirstSelectedOption().getText();
                String newlcName = new Select(this.driver.findElement(By.id((String)"lifeCycleList"))).getFirstSelectedOption().getText();
                if (newlcName.equals(lcName) && newlcState.equals(lcState)) {
                    log.info((Object)"Filter state was presisted correctly");
                    return true;
                }
                log.info((Object)"Filter state was not presisted correctly");
                return false;
            }
        }
        catch (NoSuchElementException ex) {
            log.info((Object)"Not enough API's in the list to check Filter State with pagination");
            return false;
        }
        return false;
    }

    public LoginPage logout() throws IOException {
        this.driver.findElement(By.linkText((String)this.uiElementMapper.getElement("home.greg.sign.out.xpath"))).click();
        return new LoginPage(this.driver);
    }
}

