/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.creation;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APICreationInvocationTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APICreationInvocationTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String apiName = "TestSampleApi1";
    private String apiContext = "testSampleApi1";
    private String appName = "sample-application1";
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    @Factory(dataProvider="userModeDataProvider")
    public APICreationInvocationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String backendEndPoint = this.getBackendEndServiceEndPointHttp("jaxrs_basic/services/customers/customerservice");
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(backendEndPoint));
        HttpResponse serviceResponse = this.apiPublisher.addAPI(apiRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Sample API Publishing", dependsOnMethods={"testAPICreation"})
    public void testAPIPublishing() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        HttpResponse serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Sample Application Creation", dependsOnMethods={"testAPIPublishing"})
    public void testApplicationCreation() throws Exception {
        HttpResponse serviceResponse = this.apiStore.addApplication(this.appName, APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="API Subscription", dependsOnMethods={"testApplicationCreation"})
    public void testAPISubscription() throws Exception {
        String provider = this.user.getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, provider);
        subscriptionRequest.setApplicationName(this.appName);
        subscriptionRequest.setTier("Gold");
        HttpResponse serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Application Key Generation", dependsOnMethods={"testAPISubscription"})
    public void testApplicationKeyGeneration() throws Exception {
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.appName);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        this.log.info((Object)responseString);
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testApplicationKeyGeneration"})
    public void testAPIInvocation() throws Exception {
        this.requestHeaders.put("Accept", "application/xml");
        HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.apiContext + "/1.0.0/customers/123"), this.requestHeaders);
        this.log.info((Object)serviceResponse.getData());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)serviceResponse.getData().contains("<Customer>"), (String)"Response data mismatched when api invocation");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication(this.appName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

