/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIAccessibilityOfOldAndCopyAPITest";
    private final String API_CONTEXT = "APIAccessibilityOfOldAndCopyAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierAPI1Version1;
    private APIIdentifier apiIdentifierAPI1Version2;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherRestClient;
    private APIStoreRestClient apiStoreRestClient;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIAccessibilityOfOldAndCopyAPITest", "APIAccessibilityOfOldAndCopyAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiIdentifierAPI1Version1 = new APIIdentifier(this.providerName, "APIAccessibilityOfOldAndCopyAPITest", "1.0.0");
        this.apiIdentifierAPI1Version2 = new APIIdentifier(this.providerName, "APIAccessibilityOfOldAndCopyAPITest", "2.0.0");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherRestClient = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreRestClient = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreRestClient.addApplication("APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description=" Test Copy API.Copy API version 1.0.0  to 2.0.0 ")
    public void testCopyAPI() throws Exception {
        this.createAndPublishAPI(this.apiIdentifierAPI1Version1, this.apiCreationRequestBean, this.apiPublisherRestClient, false);
        this.waitForAPIDeploymentSync(this.apiCreationRequestBean.getProvider(), this.apiCreationRequestBean.getName(), this.apiCreationRequestBean.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponseCopyAPI = this.apiPublisherRestClient.copyAPI(this.providerName, "APIAccessibilityOfOldAndCopyAPITest", "1.0.0", "2.0.0", "");
        Assert.assertEquals((int)httpResponseCopyAPI.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Copy API request code is invalid." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(httpResponseCopyAPI, "error"), (String)"false", (String)("Copy  API response data is invalid" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + httpResponseCopyAPI.getData()));
        Thread.sleep(1000L);
    }

    @Test(groups={"wso2.am"}, description="Test publish activity of a copied API.", dependsOnMethods={"testCopyAPI"})
    public void testPublishCopiedAPI() throws APIManagerIntegrationTestException {
        APILifeCycleStateRequest publishUpdateRequest = new APILifeCycleStateRequest("APIAccessibilityOfOldAndCopyAPITest", this.providerName, APILifeCycleState.PUBLISHED);
        publishUpdateRequest.setVersion("2.0.0");
        HttpResponse publishAPIResponse = this.apiPublisherRestClient.changeAPILifeCycleStatusToPublish(this.apiIdentifierAPI1Version2, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.CREATED, APILifeCycleState.PUBLISHED), (String)("API status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + publishAPIResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description=" Test availability of old and new API versions in the store.", dependsOnMethods={"testPublishCopiedAPI"})
    public void testAvailabilityOfOldAndNewAPIVersionsInStore() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifierAPI1Version1.getApiName(), this.apiIdentifierAPI1Version1.getVersion(), "\"isApiExists\":true");
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreRestClient.getAPI());
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifierAPI1Version2.getApiName(), this.apiIdentifierAPI1Version2.getVersion(), "\"isApiExists\":true");
        apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreRestClient.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAPI1Version2, (List)apiStoreAPIIdentifierList), (String)("New version Api is not visible in API Store after publish new version." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old API version.", dependsOnMethods={"testAvailabilityOfOldAndNewAPIVersionsInStore"})
    public void testSubscribeOldVersion() throws APIManagerIntegrationTestException {
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version1, "APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase", this.apiStoreRestClient);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(oldVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + oldVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description=" Test availability of old and new API versions i the store.", dependsOnMethods={"testSubscribeOldVersion"})
    public void testSubscribeNewVersion() throws APIManagerIntegrationTestException {
        HttpResponse newVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version2, "APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase", this.apiStoreRestClient);
        Assert.assertEquals((int)newVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertEquals((String)this.getValueFromJSON(newVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + newVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Publish a API and check its visibility in the API Store. Copy and create a new version, publish  the new version, test invocation of both old and new API versions.", dependsOnMethods={"testSubscribeNewVersion"})
    public void testAccessibilityOfPublishedOldAPIAndPublishedCopyAPI() throws Exception {
        String accessToken = this.generateApplicationKeys(this.apiStoreRestClient, "APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase").getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("APIAccessibilityOfOldAndCopyAPI", "1.0.0") + "/" + "customers/123"), requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
        HttpResponse newVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("APIAccessibilityOfOldAndCopyAPI", "2.0.0") + "/" + "customers/123"), requestHeaders);
        Assert.assertEquals((int)newVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)newVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreRestClient.removeApplication("APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase");
        this.deleteAPI(this.apiIdentifierAPI1Version1, this.apiPublisherRestClient);
        this.deleteAPI(this.apiIdentifierAPI1Version2, this.apiPublisherRestClient);
        super.cleanUp();
    }
}

