/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIManagerLifecycleBaseTest
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIManagerLifecycleBaseTest.class);
    protected static final String CARBON_HOME = FrameworkPathUtil.getCarbonHome();
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_UNAUTHORIZED = Response.Status.UNAUTHORIZED.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_TOO_MANY_REQUESTS = 429;
    protected static final int HTTP_RESPONSE_CODE_FORBIDDEN = Response.Status.FORBIDDEN.getStatusCode();
    protected static final String HTTP_RESPONSE_DATA_API_BLOCK = "<am:code>700700</am:code><am:message>API blocked</am:message>";
    protected static final String HTTP_RESPONSE_DATA_NOT_FOUND = "<am:code>404</am:code><am:type>Status report</am:type><am:message>Not Found</am:message>";
    protected static final String HTTP_RESPONSE_DATA_API_FORBIDDEN = "<ams:code>900908</ams:code><ams:message>Resource forbidden </ams:message>";
    protected static final int GOLD_INVOCATION_LIMIT_PER_MIN = 20;
    protected static final int SILVER_INVOCATION_LIMIT_PER_MIN = 5;
    protected static final String TIER_UNLIMITED = "Unlimited";
    protected static final String TIER_GOLD = "Gold";
    protected static final String TIER_SILVER = "Silver";
    protected static final String MESSAGE_THROTTLED_OUT = "<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>";
    protected static final String MESSAGE_THROTTLED_OUT_RESOURCE = "<amt:code>900802</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>";
    protected static final int THROTTLING_UNIT_TIME = 60000;
    protected static final int THROTTLING_ADDITIONAL_WAIT_TIME = 5000;

    protected String getAPIIdentifierString(APIIdentifier apiIdentifier) {
        return " API Name:" + apiIdentifier.getApiName() + " API Version:" + apiIdentifier.getVersion() + " API Provider Name :" + apiIdentifier.getProviderName() + " ";
    }

    protected HttpResponse subscribeToAPI(APIIdentifier apiIdentifier, String applicationName, APIStoreRestClient storeRestClient) throws APIManagerIntegrationTestException {
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiIdentifier.getApiName(), apiIdentifier.getProviderName());
        subscriptionRequest.setVersion(apiIdentifier.getVersion());
        subscriptionRequest.setApplicationName(applicationName);
        if (apiIdentifier.getTier() != null && !apiIdentifier.getTier().equals("")) {
            subscriptionRequest.setTier(apiIdentifier.getTier());
        }
        return storeRestClient.subscribeToAPI(subscriptionRequest);
    }

    protected ApplicationKeyBean generateApplicationKeys(APIStoreRestClient storeRestClient, String applicationName) throws APIManagerIntegrationTestException {
        try {
            ApplicationKeyBean applicationKeyBean = new ApplicationKeyBean();
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(applicationName);
            String responseString = storeRestClient.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject response = new JSONObject(responseString);
            log.info((Object)("Token response: " + response.toString()));
            applicationKeyBean.setAccessToken(response.getJSONObject("data").getJSONObject("key").get("accessToken").toString());
            applicationKeyBean.setConsumerKey(response.getJSONObject("data").getJSONObject("key").get("consumerKey").toString());
            applicationKeyBean.setConsumerSecret(response.getJSONObject("data").getJSONObject("key").get("consumerSecret").toString());
            return applicationKeyBean;
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when get access token", (Throwable)e);
        }
    }

    protected void deleteAPI(APIIdentifier apiIdentifier, APIPublisherRestClient publisherRestClient) throws APIManagerIntegrationTestException {
        HttpResponse deleteHTTPResponse = publisherRestClient.deleteAPI(apiIdentifier.getApiName(), apiIdentifier.getVersion(), apiIdentifier.getProviderName());
        if (deleteHTTPResponse.getResponseCode() != HTTP_RESPONSE_CODE_OK || !this.getValueFromJSON(deleteHTTPResponse, "error").equals("false")) {
            throw new APIManagerIntegrationTestException("Error in API Deletion." + this.getAPIIdentifierString(apiIdentifier) + " API Context :" + deleteHTTPResponse + "Response Code:" + deleteHTTPResponse.getResponseCode() + " Response Data :" + deleteHTTPResponse.getData());
        }
    }

    protected String getValueFromJSON(HttpResponse httpResponse, String key) throws APIManagerIntegrationTestException {
        try {
            JSONObject jsonObject = new JSONObject(httpResponse.getData());
            return jsonObject.get(key).toString();
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Exception thrown when resolving the JSON object in the HTTP response ", (Throwable)e);
        }
    }

    public boolean verifyAPIStatusChange(HttpResponse httpResponse, APILifeCycleState oldStatus, APILifeCycleState newStatus) throws APIManagerIntegrationTestException {
        boolean isStatusChangeCorrect = false;
        try {
            JSONObject jsonRootObject = new JSONObject(httpResponse.getData());
            JSONArray jsonArray = (JSONArray)jsonRootObject.get("lcs");
            JSONObject latestChange = (JSONObject)jsonArray.get(0);
            if (jsonArray.length() > 0) {
                for (int index = 1; index < jsonArray.length(); ++index) {
                    if (Long.parseLong(((JSONObject)jsonArray.get(index)).get("date").toString()) <= Long.parseLong(latestChange.get("date").toString())) continue;
                    latestChange = (JSONObject)jsonArray.get(index);
                }
            }
            if (latestChange.get("oldStatus").toString().equals(oldStatus.getState()) && latestChange.get("newStatus").toString().equals(newStatus.getState())) {
                isStatusChangeCorrect = true;
            }
            return isStatusChangeCorrect;
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Exception thrown when resolving the JSON object in the HTTP response to verify the status change. HTTP response data: " + httpResponse.getData() + " HTTP response message: " + httpResponse.getResponseMessage() + " HTTP response code: " + httpResponse.getResponseCode(), (Throwable)e);
        }
    }

    protected HttpResponse publishAPI(APIIdentifier apiIdentifier, APIPublisherRestClient publisherRestClient, boolean isRequireReSubscription) throws APIManagerIntegrationTestException {
        APILifeCycleStateRequest publishUpdateRequest = new APILifeCycleStateRequest(apiIdentifier.getApiName(), apiIdentifier.getProviderName(), APILifeCycleState.PUBLISHED);
        publishUpdateRequest.setVersion(apiIdentifier.getVersion());
        return publisherRestClient.changeAPILifeCycleStatusToPublish(apiIdentifier, isRequireReSubscription);
    }

    public void createAndPublishAPI(APIIdentifier apiIdentifier, APICreationRequestBean apiCreationRequestBean, APIPublisherRestClient publisherRestClient, boolean isRequireReSubscription) throws APIManagerIntegrationTestException {
        HttpResponse createAPIResponse = publisherRestClient.addAPI(apiCreationRequestBean);
        if (createAPIResponse.getResponseCode() == HTTP_RESPONSE_CODE_OK && this.getValueFromJSON(createAPIResponse, "error").equals("false")) {
            log.info((Object)("API Created :" + this.getAPIIdentifierString(apiIdentifier)));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new APIManagerIntegrationTestException(e.getMessage(), (Throwable)e);
            }
            HttpResponse publishAPIResponse = this.publishAPI(apiIdentifier, publisherRestClient, isRequireReSubscription);
            if (publishAPIResponse.getResponseCode() != HTTP_RESPONSE_CODE_OK || !this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.CREATED, APILifeCycleState.PUBLISHED)) {
                throw new APIManagerIntegrationTestException("Error in API Publishing" + this.getAPIIdentifierString(apiIdentifier) + "Response Code:" + publishAPIResponse.getResponseCode() + " Response Data :" + publishAPIResponse.getData());
            }
        } else {
            throw new APIManagerIntegrationTestException("Error in API Creation." + this.getAPIIdentifierString(apiIdentifier) + "Response Code:" + createAPIResponse.getResponseCode() + " Response Data :" + createAPIResponse.getData());
        }
        log.info((Object)("API Published :" + this.getAPIIdentifierString(apiIdentifier)));
    }

    protected void createAndPublishAPIWithoutRequireReSubscription(APIIdentifier apiIdentifier, APICreationRequestBean apiCreationRequestBean, APIPublisherRestClient publisherRestClient) throws APIManagerIntegrationTestException {
        this.createAndPublishAPI(apiIdentifier, apiCreationRequestBean, publisherRestClient, false);
    }

    protected void copyAPI(APIIdentifier apiIdentifier, String newAPIVersion, APIPublisherRestClient publisherRestClient) throws APIManagerIntegrationTestException {
        HttpResponse httpResponseCopyAPI = publisherRestClient.copyAPI(apiIdentifier.getProviderName(), apiIdentifier.getApiName(), apiIdentifier.getVersion(), newAPIVersion, "");
        if (httpResponseCopyAPI.getResponseCode() != HTTP_RESPONSE_CODE_OK || !this.getValueFromJSON(httpResponseCopyAPI, "error").equals("false")) {
            throw new APIManagerIntegrationTestException("Error in API Copy." + this.getAPIIdentifierString(apiIdentifier) + "  New API Version :" + newAPIVersion + "Response Code:" + httpResponseCopyAPI.getResponseCode() + " Response Data :" + httpResponseCopyAPI.getData());
        }
    }

    protected void copyAndPublishCopiedAPI(APIIdentifier apiIdentifier, String newAPIVersion, APIPublisherRestClient publisherRestClient, boolean isRequireReSubscription) throws APIManagerIntegrationTestException {
        this.copyAPI(apiIdentifier, newAPIVersion, publisherRestClient);
        APIIdentifier copiedAPIIdentifier = new APIIdentifier(apiIdentifier.getProviderName(), apiIdentifier.getApiName(), newAPIVersion);
        this.publishAPI(copiedAPIIdentifier, publisherRestClient, isRequireReSubscription);
    }

    protected void createPublishAndSubscribeToAPI(APIIdentifier apiIdentifier, APICreationRequestBean apiCreationRequestBean, APIPublisherRestClient publisherRestClient, APIStoreRestClient storeRestClient, String applicationName) throws APIManagerIntegrationTestException {
        this.createAndPublishAPI(apiIdentifier, apiCreationRequestBean, publisherRestClient, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiIdentifier.getApiName(), apiIdentifier.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponseSubscribeAPI = this.subscribeToAPI(apiIdentifier, applicationName, storeRestClient);
        if (httpResponseSubscribeAPI.getResponseCode() != HTTP_RESPONSE_CODE_OK || !this.getValueFromJSON(httpResponseSubscribeAPI, "error").equals("false")) {
            throw new APIManagerIntegrationTestException("Error in API Subscribe." + this.getAPIIdentifierString(apiIdentifier) + "Response Code:" + httpResponseSubscribeAPI.getResponseCode() + " Response Data :" + httpResponseSubscribeAPI.getData());
        }
        log.info((Object)("API Subscribed :" + this.getAPIIdentifierString(apiIdentifier)));
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reade which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }
}

