/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIVisibilityByPublicTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIVisibilityByPublicTestCase.class);
    private final String API_NAME = "APIVisibilityByPublicTest";
    private final String API_CONTEXT = "APIVisibilityByPublic";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private APIStoreRestClient apiStoreClientAnotherUserSameDomain;
    private APIPublisherRestClient apiPublisherClientUserAnotherUserSameDomain;
    private APIStoreRestClient apiStoreClientAnotherUserOtherDomain;
    private APIPublisherRestClient apiPublisherClientAnotherUserOtherDomain;
    private APIStoreRestClient apiStoreClientAdminOtherDomain;
    private APIPublisherRestClient apiPublisherClientAdminOtherDomain;
    private String providerName;
    private APIPublisherRestClient apiPublisherClientUser2;
    private APIStoreRestClient apiStoreClientUser2;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private String otherDomain;
    private String apiCreatorStoreDomain;
    private String storeURLHttp;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        String publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiPublisherClientUser2 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser2 = new APIStoreRestClient(this.storeURLHttp);
        this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
        this.apiPublisherClientUser2.login(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiStoreClientUser2.login(this.storeContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.storeContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserSameDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientUserAnotherUserSameDomain = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientAnotherUserSameDomain.login(this.storeContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.storeContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.apiPublisherClientUserAnotherUserSameDomain.login(this.publisherContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.init("wso2.com", "admin");
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAnotherUserOtherDomain = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientAnotherUserOtherDomain.login(this.storeContext.getContextTenant().getTenantUser("user1").getUserName(), this.storeContext.getContextTenant().getTenantUser("user1").getPassword());
        this.apiPublisherClientAnotherUserOtherDomain.login(this.publisherContext.getContextTenant().getTenantUser("user1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("user1").getPassword());
        this.apiStoreClientAdminOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAdminOtherDomain = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientAdminOtherDomain.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiPublisherClientAdminOtherDomain.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws Exception {
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByPublicTest", "1.0.0");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIVisibilityByPublicTest", "APIVisibilityByPublic", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiPublisherClientUser2.addAPI(apiCreationRequestBean);
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByPublicTest", "1.0.0");
        this.publishAPI(apiIdentifier, this.apiPublisherClientUser2, false);
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to creator in APi Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser2.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to creator in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInStore"})
    public void testVisibilityForAdminInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to admin in same domain in API Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForAdminInSameDomainInPublisher"})
    public void testVisibilityForAdminInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser1.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to admin in same domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminInSameDomainInStore"})
    public void testVisibilityForAnotherUserInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientUserAnotherUserSameDomain.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to another user in same domain in API Publisher. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAnotherUserSameDomain.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to another user in same domain in API Store. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInStore"})
    public void testVisibilityForAnotherUserInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to another user in other domain in API Publisher. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAnotherUserOtherDomain.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to another user in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInStore"})
    public void testVisibilityForAdminInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to admin in other domain in API Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminInOtherDomainInPublisher"})
    public void testVisibilityForAdminInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAdminOtherDomain.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAdminInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws APIManagerIntegrationTestException {
        HttpResponse httpResponse = new APIStoreRestClient(this.storeURLHttp).getAPIListFromStoreAsAnonymousUser(this.otherDomain);
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByPublicTest"), (String)("API is  visible to anonymous user in other domain API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws APIManagerIntegrationTestException {
        long currentTime;
        long maxLookupTime = 60000L;
        boolean apiFound = false;
        long startTime = System.currentTimeMillis();
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"InterruptedException occurs while sleeping 500 milliseconds", (Throwable)e);
            }
            currentTime = System.currentTimeMillis();
            String response = apiStoreRestClient.getAPIListFromStoreAsAnonymousUser(this.apiCreatorStoreDomain).getData();
            this.log.info((Object)("Received data: " + response));
            if (response.contains("APIVisibilityByPublicTest")) {
                apiFound = true;
                break;
            }
            this.log.info((Object)("APIVisibilityByPublicTest API is not visible for anonymous user in same domain in store after :" + (currentTime - startTime) + " milliseconds"));
        } while (currentTime - startTime < maxLookupTime);
        Assert.assertTrue((boolean)apiFound, (String)("API is not visible to anonymous user in same domain API Store After " + (currentTime - startTime) + " milliseconds. When Visibility is public.  " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }
}

