/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIVisibilityByRoleTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME_ADMIN_VISIBILITY = "APIVisibilityByRoleTest";
    private final String API_NAME_SUBSCRIBER_VISIBILITY = "APIVisibilityByRole";
    private final String API_CONTEXT1 = "testAPI1";
    private final String API_CONTEXT2 = "testAPI2";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String CARBON_SUPER_SUBSCRIBER_USERNAME = "subscriberUser1";
    private final char[] CARBON_SUPER_SUBSCRIBER_PASSWORD = "password@123".toCharArray();
    private final String TENANT_SUBSCRIBER_USERNAME = "subscriberUser2";
    private final char[] TENANT_SUBSCRIBER_PASSWORD = "password@123".toCharArray();
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String ROLE_SUBSCRIBER = "subscriber";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIPublisherRestClient apiPublisherClientCarbonSuperUser1;
    private APIStoreRestClient apiStoreClientCarbonSuperUser1;
    private APIPublisherRestClient apiPublisherClientCarbonSuperAdmin;
    private APIStoreRestClient apiStoreClientCarbonSuperAdmin;
    private APIIdentifier apiIdentifierAdminVisibility;
    private APIIdentifier apiIdentifierSubscriberVisibility;
    private APIStoreRestClient apiStoreClientCarbonSuperUser2;
    private APIPublisherRestClient apiPublisherClientCarbonSuperUser2;
    private APIStoreRestClient apiStoreClientAnotherUserOtherDomain;
    private APIPublisherRestClient apiPublisherClientAnotherUserOtherDomain;
    private APIStoreRestClient apiStoreClientAdminOtherDomain;
    private APIPublisherRestClient apiPublisherClientAdminOtherDomain;
    private UserManagementClient userManagementClient1;
    private UserManagementClient userManagementClient2;
    private APIStoreRestClient apiStoreClientSubscriberUserSameDomain;
    private APIStoreRestClient apiStoreClientSubscriberUserOtherDomain;
    private String apiCreatorStoreDomain;
    private String storeURLHttp;
    private String otherDomain;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        String publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientCarbonSuperAdmin = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientCarbonSuperAdmin = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientCarbonSuperAdmin.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientCarbonSuperAdmin.login(this.user.getUserName(), this.user.getPassword());
        this.apiPublisherClientCarbonSuperUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientCarbonSuperUser1 = new APIStoreRestClient(this.storeURLHttp);
        this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
        this.apiPublisherClientCarbonSuperUser1.login(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiStoreClientCarbonSuperUser1.login(this.storeContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.storeContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientCarbonSuperUser2 = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientCarbonSuperUser2 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientCarbonSuperUser2.login(this.storeContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.storeContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.apiPublisherClientCarbonSuperUser2.login(this.publisherContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        if (this.userManagementClient1.userNameExists("Internal/subscriber", "subscriberUser1")) {
            this.userManagementClient1.deleteUser("subscriberUser1");
        }
        this.userManagementClient1.addUser("subscriberUser1", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD), new String[]{"Internal/subscriber"}, null);
        this.apiStoreClientSubscriberUserSameDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiStoreClientSubscriberUserSameDomain.login("subscriberUser1", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD));
        this.init("wso2.com", "admin");
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAnotherUserOtherDomain = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientAnotherUserOtherDomain.login(this.storeContext.getContextTenant().getTenantUser("user1").getUserName(), this.storeContext.getContextTenant().getTenantUser("user1").getUserName());
        this.apiPublisherClientAnotherUserOtherDomain.login(this.publisherContext.getContextTenant().getTenantUser("user1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("user1").getUserName());
        this.apiStoreClientAdminOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAdminOtherDomain = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientAdminOtherDomain.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiPublisherClientAdminOtherDomain.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.userManagementClient2 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        if (this.userManagementClient2.roleNameExists("Internal/subscriber")) {
            this.userManagementClient2.deleteRole("Internal/subscriber");
        }
        this.userManagementClient2.addInternalRole("subscriber", new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
        if (this.userManagementClient2.userNameExists("Internal/subscriber", "subscriberUser2")) {
            this.userManagementClient2.deleteUser("subscriberUser2");
        }
        this.userManagementClient2.addUser("subscriberUser2", String.valueOf(this.TENANT_SUBSCRIBER_PASSWORD), new String[]{"Internal/subscriber"}, null);
        this.apiStoreClientSubscriberUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiStoreClientSubscriberUserOtherDomain.login("subscriberUser2", String.valueOf(this.TENANT_SUBSCRIBER_PASSWORD));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws APIManagerIntegrationTestException, MalformedURLException, XPathExpressionException {
        this.apiIdentifierAdminVisibility = new APIIdentifier(this.providerName, "APIVisibilityByRoleTest", "1.0.0");
        this.apiIdentifierSubscriberVisibility = new APIIdentifier(this.providerName, "APIVisibilityByRole", "1.0.0");
        APICreationRequestBean apiCreationReqBeanVisibilityAdmin = new APICreationRequestBean("APIVisibilityByRoleTest", "testAPI1", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationReqBeanVisibilityAdmin.setTags("testTag1, testTag2, testTag3");
        apiCreationReqBeanVisibilityAdmin.setDescription("This is test API create by API manager integration test");
        apiCreationReqBeanVisibilityAdmin.setVisibility("restricted");
        apiCreationReqBeanVisibilityAdmin.setRoles("admin");
        this.apiPublisherClientCarbonSuperUser1.addAPI(apiCreationReqBeanVisibilityAdmin);
        this.publishAPI(this.apiIdentifierAdminVisibility, this.apiPublisherClientCarbonSuperUser1, false);
        this.waitForAPIDeploymentSync(this.apiIdentifierAdminVisibility.getProviderName(), this.apiIdentifierAdminVisibility.getApiName(), this.apiIdentifierAdminVisibility.getVersion(), "\"isApiExists\":true");
        APICreationRequestBean apiCreationReqBeanVisibilityInternalSubscriber = new APICreationRequestBean("APIVisibilityByRole", "testAPI2", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationReqBeanVisibilityInternalSubscriber.setTags("testTag1, testTag2, testTag3");
        apiCreationReqBeanVisibilityInternalSubscriber.setDescription("This is test API create by API manager integration test");
        apiCreationReqBeanVisibilityInternalSubscriber.setVisibility("restricted");
        apiCreationReqBeanVisibilityInternalSubscriber.setRoles("Internal/subscriber");
        this.apiPublisherClientCarbonSuperUser1.addAPI(apiCreationReqBeanVisibilityInternalSubscriber);
        this.publishAPI(this.apiIdentifierSubscriberVisibility, this.apiPublisherClientCarbonSuperUser1, false);
        this.waitForAPIDeploymentSync(this.apiIdentifierSubscriberVisibility.getProviderName(), this.apiIdentifierSubscriberVisibility.getApiName(), this.apiIdentifierSubscriberVisibility.getVersion(), "\"isApiExists\":true");
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to creator in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is not visible to creator in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperUser1.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to creator in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to creator in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInStore"})
    public void testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperAdmin.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to Admin user with Admin and subscriber role in same domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is not visible to Admin user with Admin and subscriber role in same domain  in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInPublisher"})
    public void testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperAdmin.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to Admin user with Admin and subscriber role in same domain  in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to Admin user with Admin and subscriber role in same domain  in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to another user with Admin and subscriber role in same domain  in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is not visible to another user with Admin and subscriber role in same domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperUser2.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to another user with Admin and subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to another user with Admin and subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is  visible to another user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAnotherUserOtherDomain.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with Admin and subscriber role in other domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to another user with Admin and subscriber role in other domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInPublisher"})
    public void testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAdminOtherDomain.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to Admin user with Admin and subscriber role in other domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAnotherUserWithSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientSubscriberUserSameDomain.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to another user with subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserWithSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientSubscriberUserOtherDomain.getAllPublishedAPIs(this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to another user with subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnotherUserWithSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws APIManagerIntegrationTestException {
        HttpResponse httpResponse = new APIStoreRestClient(this.storeURLHttp).getAPIListFromStoreAsAnonymousUser(this.apiCreatorStoreDomain);
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByRoleTest"), (String)("API with  Role admin  visibility  is  visible to anonymous user in other domain API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByRole"), (String)("API with  Role Internal/subscriber is  visible to anonymous user in other domain API Store." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws APIManagerIntegrationTestException {
        HttpResponse httpResponse = new APIStoreRestClient(this.storeURLHttp).getAPIListFromStoreAsAnonymousUser(this.otherDomain);
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByRoleTest"), (String)("API with  Role admin  visibility  is not visible to anonymous user in same domain API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByRole"), (String)("API with  Role Internal/subscriber is not visible to anonymous user in same domain API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.deleteAPI(this.apiIdentifierAdminVisibility, this.apiPublisherClientCarbonSuperAdmin);
        this.deleteAPI(this.apiIdentifierSubscriberVisibility, this.apiPublisherClientCarbonSuperAdmin);
        this.userManagementClient1.deleteUser("subscriberUser1");
        this.userManagementClient2.deleteUser("subscriberUser2");
    }
}

