/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "CopyAPIWithOutReSubscriptionTest";
    private final String API_CONTEXT = "CopyAPIWithOutReSubscription";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierAPI1Version1;
    private APIIdentifier apiIdentifierAPI1Version2;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("CopyAPIWithOutReSubscriptionTest", "CopyAPIWithOutReSubscription", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiIdentifierAPI1Version1 = new APIIdentifier(this.providerName, "CopyAPIWithOutReSubscriptionTest", "1.0.0");
        this.apiIdentifierAPI1Version2 = new APIIdentifier(this.providerName, "CopyAPIWithOutReSubscriptionTest", "2.0.0");
        String publisherURLHttp = this.getPublisherURLHttps();
        String storeURLHttp = this.getStoreURLHttps();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.addApplication("AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old api version.")
    public void testSubscriptionOfOldAPI() throws APIManagerIntegrationTestException, IOException, XPathExpressionException {
        this.createAndPublishAPI(this.apiIdentifierAPI1Version1, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        this.waitForAPIDeploymentSync(this.apiCreationRequestBean.getProvider(), this.apiCreationRequestBean.getName(), this.apiCreationRequestBean.getVersion(), "\"isApiExists\":true");
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version1, "AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase", this.apiStoreClientUser1);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(oldVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + oldVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test publishing of copied API with out re-subscription required", dependsOnMethods={"testSubscriptionOfOldAPI"})
    public void testPublishCopiedAPIWithOutReSubscriptionRequired() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.copyAPI(this.apiIdentifierAPI1Version1, "2.0.0", this.apiPublisherClientUser1);
        HttpResponse publishAPIResponse = this.apiPublisherClientUser1.changeAPILifeCycleStatusToPublish(this.apiIdentifierAPI1Version2, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.CREATED, APILifeCycleState.PUBLISHED), (String)("API status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + publishAPIResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version before the new version is subscribed.", dependsOnMethods={"testPublishCopiedAPIWithOutReSubscriptionRequired"})
    public void testInvokeNewAPIWithoutSubscribeTheNewVersion() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CopyAPIWithOutReSubscriptionTest", "2.0.0", "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("CopyAPIWithOutReSubscription", "2.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke new api before subscribe the new version when re-subscription is not required.");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke new API version before subscribe the new version whenre-subscription is not required. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase");
        this.deleteAPI(this.apiIdentifierAPI1Version1, this.apiPublisherClientUser1);
        this.deleteAPI(this.apiIdentifierAPI1Version2, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

