/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfRetireAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "RetireAPITest";
    private final String API_CONTEXT = "RetireAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfRetireAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherRestClient;
    private APIStoreRestClient apiStoreRestClient;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("RetireAPITest", "RetireAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherRestClient = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreRestClient = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "RetireAPITest", "1.0.0");
        this.apiStoreRestClient.addApplication("AccessibilityOfRetireAPITestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before retire")
    public void testInvokeAPIBeforeChangeAPILifecycleToRetired() throws Exception {
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherRestClient, this.apiStoreRestClient, "AccessibilityOfRetireAPITestCase");
        String accessToken = this.generateApplicationKeys(this.apiStoreRestClient, "AccessibilityOfRetireAPITestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RetireAPITest", "1.0.0", "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("RetireAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before Retire");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before Retire Response Data:" + oldVersionInvokeResponse.getData()));
        Thread.sleep(1000L);
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to Retired", dependsOnMethods={"testInvokeAPIBeforeChangeAPILifecycleToRetired"})
    public void testChangeAPILifecycleToDepricated() throws Exception {
        APILifeCycleStateRequest deprecateUpdateRequest = new APILifeCycleStateRequest("RetireAPITest", this.providerName, APILifeCycleState.DEPRECATED);
        deprecateUpdateRequest.setVersion("1.0.0");
        HttpResponse blockAPIActionResponse = this.apiPublisherRestClient.changeAPILifeCycleStatus(deprecateUpdateRequest);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(blockAPIActionResponse, APILifeCycleState.PUBLISHED, APILifeCycleState.DEPRECATED), (String)("API status Change is invalid when retire an API :" + this.getAPIIdentifierString(this.apiIdentifier) + " Response Code:" + blockAPIActionResponse.getData()));
        Thread.sleep(1000L);
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to Retired", dependsOnMethods={"testChangeAPILifecycleToDepricated"})
    public void testChangeAPILifecycleToRetired() throws APIManagerIntegrationTestException {
        APILifeCycleStateRequest retireUpdateRequest = new APILifeCycleStateRequest("RetireAPITest", this.providerName, APILifeCycleState.RETIRED);
        retireUpdateRequest.setVersion("1.0.0");
        HttpResponse blockAPIActionResponse = this.apiPublisherRestClient.changeAPILifeCycleStatus(retireUpdateRequest);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(blockAPIActionResponse, APILifeCycleState.DEPRECATED, APILifeCycleState.RETIRED), (String)("API status Change is invalid when retire an API :" + this.getAPIIdentifierString(this.apiIdentifier) + " Response Code:" + blockAPIActionResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the availability of retired API in the store", dependsOnMethods={"testChangeAPILifecycleToRetired"})
    public void testAvailabilityOfRetiredAPIInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreRestClient.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("Api is  visible in API Store after retire." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of the API after retire", dependsOnMethods={"testAvailabilityOfRetiredAPIInStore"})
    public void testInvokeAPIAfterChangeAPILifecycleToRetired() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RetireAPITest", "1.0.0", "\"isApiExists\":false");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("RetireAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Response code mismatched when invoke api after retire");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<am:code>404</am:code><am:type>Status report</am:type><am:message>Not Found</am:message>"), (String)("Response data mismatched when invoke  API  after retire Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.apiStoreRestClient.removeApplication("AccessibilityOfRetireAPITestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherRestClient);
    }
}

