/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAPIEndPointURLTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAPIEndPointURLTest";
    private final String API_CONTEXT = "ChangeAPIEndPointURLTest";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API1_END_POINT_METHOD = "customers/123";
    private final String API1_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API2_RESPONSE_DATA = "HelloWSO2";
    private final String API2_END_POINT_POSTFIX_URL = "name-check1_SB/name";
    private final String APPLICATION_NAME = "ChangeAPIEndPointURLTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String api1EndPointUrl;
    private String api2EndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.api1EndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("ChangeAPIEndPointURLTest", "ChangeAPIEndPointURLTest", "1.0.0", this.providerName, new URL(this.api1EndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeAPIEndPointURLTest", "1.0.0");
        this.apiStoreClientUser1.addApplication("ChangeAPIEndPointURLTestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test  invocation of API before change the  api end point URL.")
    public void testAPIInvocationBeforeChangeTheEndPointURL() throws Exception {
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "ChangeAPIEndPointURLTestCase");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "ChangeAPIEndPointURLTestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "*/*");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeAPIEndPointURLTest", "1.0.0", "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPIEndPointURLTest", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before change the end point URL");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before change the end point URL Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "<id>123</id><name>John</name></Customer>"));
    }

    @Test(groups={"wso2.am"}, description="Test changing of the API end point URL", dependsOnMethods={"testAPIInvocationBeforeChangeTheEndPointURL"})
    public void testEditEndPointURL() throws APIManagerIntegrationTestException, MalformedURLException {
        this.api2EndPointUrl = this.getGatewayURLHttp() + "name-check1_SB/name";
        APICreationRequestBean apiCreationRequestBeanUpdate = new APICreationRequestBean("ChangeAPIEndPointURLTest", "ChangeAPIEndPointURLTest", "1.0.0", this.providerName, new URL(this.api2EndPointUrl));
        apiCreationRequestBeanUpdate.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBeanUpdate.setDescription("This is test API create by API manager integration test");
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBeanUpdate);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API end point URL Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)("Error in API end point URL Update in " + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + updateAPIHTTPResponse.getData()));
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using new end point URL  after end point URL  change", dependsOnMethods={"testEditEndPointURL"})
    public void testInvokeAPIAfterChangeAPIEndPointURLWithNewEndPointURL() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("ChangeAPIEndPointURLTest", "1.0.0"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke  API  after change the end point URL");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("HelloWSO2"), (String)("Response data mismatched when invoke  API  after change the end point URL Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "HelloWSO2"));
        Assert.assertFalse((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  after change the end point URL. It contains the Old end point URL response data. Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "HelloWSO2"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("ChangeAPIEndPointURLTestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

