/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAuthTypeOfResourceTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAuthTypeOfResourceTest999";
    private final String API_CONTEXT = "ChangeAuthTypeOfResource999";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";
    private final String API_GET_ENDPOINT_METHOD = "customers/123";
    private String APPLICATION_NAME = "ChangeAuthTypeOfResourceTestCase";
    private APIPublisherRestClient apiPublisherClientUser1;
    private String apiEndPointUrl;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private ApplicationKeyBean applicationKeyBean;
    private HashMap<String, String> requestHeadersGet;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.apiStoreClientUser1.addApplication(this.APPLICATION_NAME, "50PerMin", "", "");
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application And Application User")
    public void testInvokeResourceWithAuthTypeApplicationAndApplicationUser() throws Exception {
        this.apiStoreClientUser1.addApplication(this.APPLICATION_NAME, "50PerMin", "", "");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeAuthTypeOfResourceTest999", "ChangeAuthTypeOfResource999", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeAuthTypeOfResourceTest999", "1.0.0");
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, this.APPLICATION_NAME);
        this.applicationKeyBean = this.generateApplicationKeys(this.apiStoreClientUser1, this.APPLICATION_NAME);
        String accessToken = this.applicationKeyBean.getAccessToken();
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeAuthTypeOfResourceTest999", "1.0.0", "\"isApiExists\":true");
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application & Application User");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application & Application User. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application", dependsOnMethods={"testInvokeResourceWithAuthTypeApplicationAndApplicationUser"})
    public void testInvokeResourceWithAuthTypeApplication() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeAuthTypeOfResourceTest999", "ChangeAuthTypeOfResource999", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application User", dependsOnMethods={"testInvokeResourceWithAuthTypeApplication"})
    public void testInvokeGETResourceWithAuthTypeApplicationUser() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeAuthTypeOfResourceTest999", "ChangeAuthTypeOfResource999", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application User", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        String requestBody = "grant_type=password&username=admin&password=admin&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStoreClientUser1.generateUserAccessKey(this.applicationKeyBean.getConsumerKey(), this.applicationKeyBean.getConsumerSecret(), requestBody, tokenEndpointURL).getData());
        this.requestHeadersGet.put("Authorization", "Bearer " + accessTokenGenerationResponse.getString("access_token"));
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application User");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application User. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type None", dependsOnMethods={"testInvokeGETResourceWithAuthTypeApplicationUser"})
    public void testInvokeGETResourceWithAuthTypeNone() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeAuthTypeOfResourceTest999", "ChangeAuthTypeOfResource999", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "None", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type None");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Non3. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication(this.APPLICATION_NAME);
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

