/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class EditAPIAndCheckUpdatedInformationTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "EditAPIAndCheckUpdatedInformationTest";
    private final String API_CONTEXT = "EditAPIAndCheckUpdatedInformation";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String NEW_API_TAG = "newTag";
    private final String NEW_API_DESCRIPTION = "This is test API create by API manager integration test New Description";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APICreationRequestBean apiCreationRequestBean;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("EditAPIAndCheckUpdatedInformationTest", "EditAPIAndCheckUpdatedInformation", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        APIStoreRestClient apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "EditAPIAndCheckUpdatedInformationTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Edit the API Information")
    public void testEditAPIInformation() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.createAndPublishAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        this.waitForAPIDeploymentSync(this.apiIdentifier.getProviderName(), this.apiIdentifier.getApiName(), this.apiIdentifier.getVersion(), "\"isApiExists\":true");
        String apiNewTags = "testTag1, testTag2, testTag3, newTag";
        this.apiCreationRequestBean.setTags(apiNewTags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test New Description");
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        this.waitForAPIDeployment();
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)("Error in API Update in " + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + updateAPIHTTPResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test whether the updated information available in the publisher ", dependsOnMethods={"testEditAPIInformation"})
    public void testUpdatedAPIInformationFromAPIPublisher() throws APIManagerIntegrationTestException {
        APIBean apiBeanAfterUpdate = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)this.apiPublisherClientUser1.getApi("EditAPIAndCheckUpdatedInformationTest", this.providerName, "1.0.0"));
        Assert.assertEquals((String)apiBeanAfterUpdate.getDescription(), (String)"This is test API create by API manager integration test New Description", (String)"Updated Description is not available");
        Assert.assertTrue((boolean)apiBeanAfterUpdate.getTags().contains("newTag"), (String)"Newly added Tag is not available");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }
}

