/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class EditAPIContextAndCheckAccessibilityTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "EditAPIContextAndCheckAccessibilityTest";
    private final String API_CONTEXT = "EditAPIContextAndCheckAccessibility";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "EditAPIContextAndCheckAccessibilityTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private String newContext;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("EditAPIContextAndCheckAccessibilityTest", "EditAPIContextAndCheckAccessibility", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "EditAPIContextAndCheckAccessibilityTest", "1.0.0");
        this.apiStoreClientUser1.addApplication("EditAPIContextAndCheckAccessibilityTestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test invoke the API before the context change")
    public void testInvokeAPIBeforeChangeAPIContext() throws Exception {
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "EditAPIContextAndCheckAccessibilityTestCase");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "EditAPIContextAndCheckAccessibilityTestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifier.getApiName(), this.apiIdentifier.getVersion(), "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("EditAPIContextAndCheckAccessibility", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before change the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before change the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test changing of the API context", dependsOnMethods={"testInvokeAPIBeforeChangeAPIContext"})
    public void testEditAPIContext() throws APIManagerIntegrationTestException, MalformedURLException {
        this.newContext = "newEditAPIContextAndCheckAccessibility";
        this.apiCreationRequestBean = new APICreationRequestBean("EditAPIContextAndCheckAccessibilityTest", this.newContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)("Error in API Update in " + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + updateAPIHTTPResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using old context after Context change after the API context change", dependsOnMethods={"testEditAPIContext"})
    public void testInvokeAPIAfterChangeAPIContextWithOldContext() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("EditAPIContextAndCheckAccessibility", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Response code mismatched when invoke api before changing the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<am:code>404</am:code><am:type>Status report</am:type><am:message>Not Found</am:message>"), (String)("Response data mismatched when invoke  API  before changing the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using new context after Context change", dependsOnMethods={"testInvokeAPIAfterChangeAPIContextWithOldContext"})
    public void testInvokeAPIAfterChangeAPIContextWithNewContext() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.newContext, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api after changing the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  after changing the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("EditAPIContextAndCheckAccessibilityTestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

