/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceExceptionException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class EditTiersXMLAndVerifyInPublisherTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "EditTiersXMLAndVerifyInPublisherTest";
    private final String API_CONTEXT = "EditTiersXMLAndVerifyInPublisher";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String TIER_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/tiers.xml";
    private final String TIER_XML_REG_CONFIG_APP_LOCATION = "/_system/governance/apimgt/applicationdata/app-tiers.xml";
    private final String TIER_XML_REG_CONFIG_RES_LOCATION = "/_system/governance/apimgt/applicationdata/res-tiers.xml";
    private final String TIER_PERMISSION_PAGE_TIER_GOLD = "<td>Gold</td>";
    private final String TIER_PERMISSION_PAGE_TIER_PLATINUM = "<td>Platinum</td>";
    private final String TIER_MANAGE_PAGE_TIER_GOLD = "value=\"Silver\"";
    private final String TIER_MANAGE_PAGE_TIER_PLATINUM = "value=\"Platinum\"";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String originalTiersXML;
    private String originalAppTiersXML;
    private String originalResTiersXML;
    private String newTiersXML;
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private APIPublisherRestClient apiPublisherClientUser1;
    private ServerConfigurationManager serverConfigurationManager;
    protected AutomationContext superTenantKeyManagerContext;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "apiManagerXmlWithoutAdvancedThrottling" + File.separator + "api-manager.xml"));
        this.serverConfigurationManager.restartGracefully();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("EditTiersXMLAndVerifyInPublisherTest", "EditTiersXMLAndVerifyInPublisher", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        APIStoreRestClient apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "EditTiersXMLAndVerifyInPublisherTest", "1.0.0");
        String artifactsLocation = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + "tiers.xml";
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.publisherContext.getContextUrls().getBackEndUrl(), this.createSession(this.publisherContext));
        this.originalTiersXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/tiers.xml");
        this.originalAppTiersXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/app-tiers.xml");
        this.originalResTiersXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/res-tiers.xml");
        this.newTiersXML = this.readFile(artifactsLocation);
    }

    @Test(groups={"wso2.am"}, description="test availability of tiers in Permission Page before change tiers XML")
    public void testAvailabilityOfTiersInPermissionPageBeforeChangeTiersXML() throws APIManagerIntegrationTestException {
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "EditTiersXMLAndVerifyInPublisherTest", "1.0.0");
        this.createAndPublishAPI(apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        HttpResponse tierPermissionPageHttpResponse = this.apiPublisherClientUser1.getTierPermissionsPage();
        Assert.assertEquals((int)tierPermissionPageHttpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke to get Tier Permission Page");
        Assert.assertTrue((boolean)tierPermissionPageHttpResponse.getData().contains("<td>Gold</td>"), (String)"default tier Gold is not available in Tier Permission page before  add new tear in tiers.xml");
        Assert.assertFalse((boolean)tierPermissionPageHttpResponse.getData().contains("<td>Platinum</td>"), (String)"new tier Platinum available in Tier Permission page before  add new tear in tiers.xml");
    }

    @Test(groups={"wso2.am"}, description="Test availability of tiers in API Manage Page before change tiers XML", dependsOnMethods={"testAvailabilityOfTiersInPermissionPageBeforeChangeTiersXML"})
    public void testAvailabilityOfTiersInAPIManagePageBeforeChangeTiersXML() throws APIManagerIntegrationTestException {
        HttpResponse tierManagePageHttpResponse = this.apiPublisherClientUser1.getAPIManagePage("EditTiersXMLAndVerifyInPublisherTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)tierManagePageHttpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke to get Tier Permission Page");
        Assert.assertTrue((boolean)tierManagePageHttpResponse.getData().contains("value=\"Silver\""), (String)"default tier  Gold is not available in Tier Permission page before  add new tear in tiers.xml");
        Assert.assertFalse((boolean)tierManagePageHttpResponse.getData().contains("value=\"Platinum\""), (String)"new tier Platinum available in Tier Permission page before  add new tear in tiers.xml");
    }

    @Test(groups={"wso2.am"}, description="test availability of tiers in Permission Page after change tiers XML", dependsOnMethods={"testAvailabilityOfTiersInAPIManagePageBeforeChangeTiersXML"})
    public void testAvailabilityOfTiersInPermissionPageAfterChangeTiersXML() throws RemoteException, ResourceAdminServiceExceptionException, APIManagerIntegrationTestException {
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/tiers.xml", this.newTiersXML);
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/app-tiers.xml", this.newTiersXML);
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/res-tiers.xml", this.newTiersXML);
        HttpResponse tierPermissionPageHttpResponse = this.apiPublisherClientUser1.getTierPermissionsPage();
        Assert.assertEquals((int)tierPermissionPageHttpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke to get Tier Permission Page");
        Assert.assertTrue((boolean)tierPermissionPageHttpResponse.getData().contains("<td>Gold</td>"), (String)"default tier Gold is not available in Tier Permission page before  add new tear in tiers.xml");
        Assert.assertTrue((boolean)tierPermissionPageHttpResponse.getData().contains("<td>Platinum</td>"), (String)"new tier Platinum  is not available in Tier Permission page before  add new tear in tiers.xml");
    }

    @Test(groups={"wso2.am"}, description="Test availability of tiers in API Manage Page after change tiers XML", dependsOnMethods={"testAvailabilityOfTiersInPermissionPageAfterChangeTiersXML"})
    public void testAvailabilityOfTiersInAPIManagePageAfterChangeTiersXML() throws APIManagerIntegrationTestException {
        HttpResponse tierManagePageHttpResponse = this.apiPublisherClientUser1.getAPIManagePage("EditTiersXMLAndVerifyInPublisherTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)tierManagePageHttpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke to get Tier Permission Page");
        Assert.assertTrue((boolean)tierManagePageHttpResponse.getData().contains("value=\"Silver\""), (String)"default tier Gold is not available in Tier Permission page before  add new tear in tiers.xml");
        Assert.assertTrue((boolean)tierManagePageHttpResponse.getData().contains("value=\"Platinum\""), (String)"new tier Platinum available in Tier Permission page before  add new tear in tiers.xml");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/tiers.xml", this.originalTiersXML);
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/app-tiers.xml", this.originalAppTiersXML);
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/res-tiers.xml", this.originalResTiersXML);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

