/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.logging.view.stub.LogViewerLogViewerException;

public class PluggableVersioningStrategyTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(PluggableVersioningStrategyTestCase.class);
    private final String API_NAME = "PluggableVersionTestAPI";
    private final String API_CONTEXT = "{version}/PluggableVersionTestAPI";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String INVOKABLE_API_CONTEXT = "1.0.0/PluggableVersionTestAPI";
    private final String API_TAGS = "Pluggable, Version, testTag3";
    private final String API_DESCRIPTION = "This is test API to test pluggable version strategy";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String APPLICATION_NAME = "PluggableVersionTestApp";
    private String providerName;
    private APIIdentifier apiIdentifier;
    private APIPublisherRestClient apiPublisherClientUser;
    private APIStoreRestClient apiStoreClientUser;
    private APICreationRequestBean apiCreationRequestBean;
    private static final String API_GET_ENDPOINT_METHOD = "/customers/123";
    private static final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "PluggableVersionTestAPI", "1.0.0");
        this.apiCreationRequestBean = new APICreationRequestBean("PluggableVersionTestAPI", "{version}/PluggableVersionTestAPI", "1.0.0", this.providerName, new URL(apiEndPointUrl));
        this.apiCreationRequestBean.setTags("Pluggable, Version, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API to test pluggable version strategy");
        this.apiCreationRequestBean.setTier("Gold");
        this.apiCreationRequestBean.setTiersCollection("Gold");
    }

    @Test(groups={"wso2.am"}, description="This test method tests the pluggable versioning stratergy")
    public void testPluggableVersioningStratergy() throws Exception, IOException, LogViewerLogViewerException {
        this.apiStoreClientUser.addApplication("PluggableVersionTestApp", "50PerMin", "", "");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "PluggableVersionTestAPI", "1.0.0");
        apiIdentifier.setTier("Gold");
        this.createPublishAndSubscribeToAPI(apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser, this.apiStoreClientUser, "PluggableVersionTestApp");
        this.waitForAPIDeploymentSync(apiIdentifier.getProviderName(), apiIdentifier.getApiName(), apiIdentifier.getVersion(), "\"isApiExists\":true");
        HashMap<String, String> requestHeadersGet = new HashMap<String, String>();
        requestHeadersGet.put("accept", "text/xml");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser, "PluggableVersionTestApp").getAccessToken();
        requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/PluggableVersionTestAPI") + API_GET_ENDPOINT_METHOD), requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertTrue((boolean)httpResponse.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request. Expected value : <id>123</id><name>John</name></Customer> not contains in response data " + httpResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStoreClientUser != null) {
            this.apiStoreClientUser.removeApplication("PluggableVersionTestApp");
        }
        if (this.apiPublisherClientUser != null) {
            this.apiPublisherClientUser.deleteAPI("PluggableVersionTestAPI", "1.0.0", this.providerName);
        }
    }
}

