/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.AddDocumentRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class UsersAndDocsInAPIOverviewTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "UsersAndDocsInAPIOverviewTest";
    private final String API_CONTEXT = "UsersAndDocsInAPIOverview";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String USER_KEY_USER2 = "userKey1";
    private final String APPLICATION_NAME = "UsersAndDocsInAPIOverviewTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APIStoreRestClient apiStoreClientUser2;
    private APICreationRequestBean apiCreationRequestBean;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("UsersAndDocsInAPIOverviewTest", "UsersAndDocsInAPIOverview", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser2 = new APIStoreRestClient(storeURLHttp);
        this.apiStoreClientUser2.login(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "UsersAndDocsInAPIOverviewTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="test the user count in API overview is correct")
    public void testNumberOfUsersInAPIOverview() throws APIManagerIntegrationTestException {
        String applicationDescription = "";
        String applicationCallBackUrl = "";
        this.apiStoreClientUser1.addApplication("UsersAndDocsInAPIOverviewTestCase", "50PerMin", applicationCallBackUrl, applicationDescription);
        this.apiStoreClientUser2.addApplication("UsersAndDocsInAPIOverviewTestCase", "50PerMin", applicationCallBackUrl, applicationDescription);
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "UsersAndDocsInAPIOverviewTest", "1.0.0");
        apiIdentifier.setTier("Gold");
        this.createPublishAndSubscribeToAPI(apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "UsersAndDocsInAPIOverviewTestCase");
        HttpResponse publisherOverviewPageResponse1 = this.apiPublisherClientUser1.getAPIInformationPage("UsersAndDocsInAPIOverviewTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)publisherOverviewPageResponse1.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when retrieving the Publisher Overview page");
        Assert.assertTrue((boolean)this.getUserStringInOverview(publisherOverviewPageResponse1.getData()).contains("1 User"), (String)"User count is not equal to 1 , when only one user subscription is available");
        this.subscribeToAPI(this.apiIdentifier, "UsersAndDocsInAPIOverviewTestCase", this.apiStoreClientUser2);
        HttpResponse publisherOverviewPageResponse2 = this.apiPublisherClientUser1.getAPIInformationPage("UsersAndDocsInAPIOverviewTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)publisherOverviewPageResponse2.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)this.getUserStringInOverview(publisherOverviewPageResponse2.getData()).contains("2 Users"), (String)"User count is not equal to 2 , when only one user subscription is available");
    }

    @Test(groups={"wso2.am"}, description="test user information in API overview Users tab is correct", dependsOnMethods={"testNumberOfUsersInAPIOverview"})
    public void testUsersInformationInUserTabInAPIOverview() throws APIManagerIntegrationTestException {
        HttpResponse publisherOverviewPageResponse = this.apiPublisherClientUser1.getAPIInformationPage("UsersAndDocsInAPIOverviewTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)publisherOverviewPageResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when retrieving the Publisher Overview page");
        Assert.assertTrue((boolean)this.isUserAvailableInActiveSubscriptionInUserTab(publisherOverviewPageResponse.getData(), this.providerName), (String)"");
        Assert.assertTrue((boolean)this.isUserAvailableInActiveSubscriptionInUserTab(publisherOverviewPageResponse.getData(), this.providerName), (String)"");
    }

    @Test(groups={"wso2.am"}, description="test user information in API overview Docs tab is correct", dependsOnMethods={"testUsersInformationInUserTabInAPIOverview"})
    public void testDocInformationInDocsTabInAPIOverview() throws APIManagerIntegrationTestException {
        AddDocumentRequestBean addDocumentRequestBean1 = new AddDocumentRequestBean();
        addDocumentRequestBean1.setApiName("UsersAndDocsInAPIOverviewTest");
        addDocumentRequestBean1.setApiVersion("1.0.0");
        addDocumentRequestBean1.setApiProvider(this.providerName);
        addDocumentRequestBean1.setDocName("Doc1");
        addDocumentRequestBean1.setDocType("how to");
        addDocumentRequestBean1.setDocSourceType("inline");
        addDocumentRequestBean1.setDocSummary("test doc 1");
        addDocumentRequestBean1.setDocLocation("");
        addDocumentRequestBean1.setDocUrl("");
        AddDocumentRequestBean addDocumentRequestBean2 = new AddDocumentRequestBean();
        addDocumentRequestBean2.setApiName("UsersAndDocsInAPIOverviewTest");
        addDocumentRequestBean2.setApiVersion("1.0.0");
        addDocumentRequestBean2.setApiProvider(this.providerName);
        addDocumentRequestBean2.setDocName("Doc2");
        addDocumentRequestBean2.setDocType("how to");
        addDocumentRequestBean2.setDocSourceType("inline");
        addDocumentRequestBean2.setDocSummary("test doc 2");
        addDocumentRequestBean2.setDocLocation("");
        addDocumentRequestBean2.setDocUrl("");
        this.apiPublisherClientUser1.addDocument(addDocumentRequestBean1);
        this.apiPublisherClientUser1.addDocument(addDocumentRequestBean2);
        HttpResponse publisherOverviewPageResponse = this.apiPublisherClientUser1.getAPIInformationPage("UsersAndDocsInAPIOverviewTest", this.providerName, "1.0.0");
        Assert.assertEquals((int)publisherOverviewPageResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when retrieving the Publisher Overview page");
        Assert.assertTrue((boolean)publisherOverviewPageResponse.getData().contains("id=\"UsersAndDocsInAPIOverviewTest-" + addDocumentRequestBean1.getDocName() + "\""), (String)(" Doc Name:" + addDocumentRequestBean1.getDocName() + " is not available in API overview Page"));
        Assert.assertTrue((boolean)publisherOverviewPageResponse.getData().contains("id=\"UsersAndDocsInAPIOverviewTest-" + addDocumentRequestBean2.getDocName() + "\""), (String)(" Doc Name:" + addDocumentRequestBean2.getDocName() + " is not available in API overview Page"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.apiStoreClientUser1.removeApplication("UsersAndDocsInAPIOverviewTestCase");
        this.apiStoreClientUser2.removeApplication("UsersAndDocsInAPIOverviewTestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }

    private boolean isUserAvailableInActiveSubscriptionInUserTab(String responsePageOfUsersTabData, String userName) {
        String temp1 = responsePageOfUsersTabData.substring(responsePageOfUsersTabData.indexOf("Active Subscriptions<"));
        String temp2 = temp1.substring(temp1.indexOf("Active Subscriptions<"), temp1.indexOf("Usage by Current Subscribers"));
        return temp2.contains(userName);
    }

    private String getUserStringInOverview(String responseData) {
        String temp1 = responseData.substring(responseData.indexOf("<span class=\"userCount\">"));
        String temp2 = temp1.substring(temp1.indexOf("<span class=\"userCount\">"), temp1.indexOf("</span>"));
        return temp2.replaceAll("<span class=\"userCount\">", "").trim();
    }
}

