/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import org.apache.axiom.om.OMElement;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class APIMANAGER4568TLSTestCase
extends APIMIntegrationBaseTest {
    static int port = 443;
    static String addressString = "http://127.0.0.1:8280/ContentTypeAPI";
    static String searchText = "*** ClientHello, TLSv1.2";
    PrintWriter out;
    BufferedReader in;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl());
        String session = login.login("admin", "admin", "localhost");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "TLS_TEST.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)session);
        Thread.sleep(5000L);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
    @Test(groups={"wso2.am"}, description="Test TSL version")
    public void testTLS_VERSIONTest() throws Exception {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpGet httpget = new HttpGet(addressString);
        httpclient.execute((HttpUriRequest)httpget);
        File f = new File("/tmp/ssl_debug.log");
        boolean isTextThere = APIMANAGER4568TLSTestCase.find(f, searchText);
        Assert.assertTrue((boolean)isTextThere, (String)"TSL version  1.2 is not found!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean find(File f, String searchString) {
        boolean result = false;
        Scanner in = null;
        try {
            in = new Scanner(new FileReader(f));
            while (in.hasNextLine() && !result) {
                result = in.nextLine().indexOf(searchString) >= 0;
            }
        }
        catch (IOException e) {
            Assert.fail((String)"An exception thrown while reading log file");
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.cleanUp();
    }
}

