/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class CORSHeadersTestCase
extends APIManagerLifecycleBaseTest {
    private String publisherURLHttp;
    private APIPublisherRestClient apiPublisher;
    private static final String API_NAME = "CorsHeadersTestAPI";
    private static final String APPLICATION_NAME = "CorsHeadersApp";
    private static final String API_CONTEXT = "corsHeadersTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String TAGS = "cors, test";
    private static final String DESCRIPTION = "This is test API create by API manager integration test";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE = "*";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE = "GET";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE = "authorization,Access-Control-Allow-Origin,Content-Type,SOAPAction";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String accessToken;
    Log log = LogFactory.getLog(CORSHeadersTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String providerName = this.user.getUserName();
        URL endpointUrl = new URL(this.getSuperTenantAPIInvocationURLHttp("response", API_VERSION));
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean(ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE, "Application & Application User", "Unlimited", "/*"));
        this.apiCreationRequestBean = new APICreationRequestBean(API_NAME, API_CONTEXT, API_VERSION, providerName, endpointUrl, resourceBeanList);
        this.apiCreationRequestBean.setTags(TAGS);
        this.apiCreationRequestBean.setDescription(DESCRIPTION);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(providerName, API_NAME, API_VERSION);
        this.apiIdentifier.setTier("Gold");
        this.apiStoreClientUser1.addApplication(APPLICATION_NAME, "50PerMin", "", "");
        this.accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, APPLICATION_NAME).getAccessToken();
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, APPLICATION_NAME);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Checking CORS headers in pre-flight response")
    public void CheckCORSHeadersInPreFlightResponse() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpOptions option = new HttpOptions(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION));
        option.addHeader("Origin", "http://localhost");
        HttpResponse response = httpclient.execute((HttpUriRequest)option);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckCORSHeadersInPreFlightResponse");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE, (String)"Access-Control-Allow-Origin header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_METHODS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Methods header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE, (String)"Access-Control-Allow-Methods header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_HEADERS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Headers header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE, (String)"Access-Control-Allow-Headers header value mismatch.");
        Assert.assertNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is available in the response, but it should not be.");
    }

    @Test(groups={"wso2.am"}, description="Checking CORS headers in response", dependsOnMethods={"CheckCORSHeadersInPreFlightResponse"})
    public void CheckCORSHeadersInResponse() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION));
        get.addHeader("Origin", "http://localhost");
        get.addHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckCORSHeadersInResponse");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE, (String)"Access-Control-Allow-Origin header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_METHODS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Methods header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE, (String)"Access-Control-Allow-Methods header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_HEADERS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Headers header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE, (String)"Access-Control-Allow-Headers header value mismatch.");
        Assert.assertNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is available in the response, but it should not be.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public CORSHeadersTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

