/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.login;

import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class LoginValidationTestCase
extends APIMIntegrationBaseTest {
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String ROLE_SUBSCRIBER = "subscriber";
    private String publisherURLHttp;
    private String storeURLHttp;
    private UserManagementClient userManagementClient1;
    private String invalidUserName;
    private String subscriberUser;

    @Factory(dataProvider="userModeDataProvider")
    public LoginValidationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        if (this.storeContext.getContextTenant().getDomain().equals("carbon.super")) {
            this.invalidUserName = this.storeContext.getContextTenant().getContextUser().getUserName() + "invalid";
            this.subscriberUser = "subscriberUser";
        } else {
            this.invalidUserName = this.storeContext.getContextTenant().getTenantAdmin().getUserName().replace("admin", "admininvalid");
            this.subscriberUser = "subscriberUser@wso2.com";
        }
    }

    @Test(groups={"wso2.am"}, description="Login as invalid user to publisher")
    public void testInvalidLoginAsPublisherTestCase() throws Exception {
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        HttpResponse httpResponse = apiPublisherRestClient.login(this.invalidUserName, this.publisherContext.getContextTenant().getContextUser().getPassword());
        JSONObject response = new JSONObject(httpResponse.getData());
        Assert.assertTrue((response.getString("error").toString().equals("true") && response.getString("message").toString().contains("Please recheck the username and password and try again") ? 1 : 0) != 0, (String)"Invalid user can login to the API publisher");
    }

    @Test(groups={"wso2.am"}, description="Login to publisher as subscriber user")
    public void testInvalidLoginAsSubscriberTestCase() throws Exception {
        HttpResponse httpResponse;
        JSONObject response;
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        if (!this.userManagementClient1.roleNameExists("Internal/subscriber")) {
            String[] subscriberPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
            this.userManagementClient1.addInternalRole("subscriber", null, subscriberPermissions);
        }
        if (this.userManagementClient1 != null && !this.userManagementClient1.userNameExists("Internal/subscriber", "subscriberUser")) {
            this.userManagementClient1.addUser("subscriberUser", "password@123", new String[]{"Internal/subscriber"}, null);
        }
        Assert.assertTrue(((response = new JSONObject((httpResponse = apiPublisherRestClient.login(this.subscriberUser, "password@123")).getData())).getString("error").toString().equals("true") && response.getString("message").toString().contains("Login failed. Insufficient privileges") ? 1 : 0) != 0, (String)"Invalid subscriber can login to the API publisher");
    }

    @Test(groups={"wso2.am"}, description="Login to API store test scenario")
    public void testLoginToStoreTestCase() throws Exception {
        HttpResponse httpResponse;
        JSONObject response;
        String APICreatorRole = "APICreatorRole";
        String APIPublisherRole = "APIPublisherRole";
        String APIPublisherUser = "APIPublisherUser";
        String APICreatorUser = "APICreatorUser";
        String password = "password@123";
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        String[] createPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/create"};
        if (!this.userManagementClient1.roleNameExists(APICreatorRole)) {
            this.userManagementClient1.addRole(APICreatorRole, null, createPermissions);
        }
        if (this.userManagementClient1 != null && !this.userManagementClient1.userNameExists(APICreatorRole, APICreatorUser)) {
            this.userManagementClient1.addUser(APICreatorUser, password, new String[]{APICreatorRole}, null);
        }
        String[] publishPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/publish"};
        if (!this.userManagementClient1.roleNameExists(APIPublisherRole)) {
            this.userManagementClient1.addRole(APIPublisherRole, null, publishPermissions);
        }
        if (this.userManagementClient1 != null && !this.userManagementClient1.userNameExists(APIPublisherRole, APIPublisherUser)) {
            this.userManagementClient1.addUser(APIPublisherUser, password, new String[]{APIPublisherRole}, null);
        }
        Assert.assertTrue(((response = new JSONObject((httpResponse = apiStoreRestClient.login("invaliduser", "invaliduser@123")).getData())).getString("error").toString().equals("true") && response.getString("message").toString().contains("Login failed. Please recheck the username and password and try again") ? 1 : 0) != 0, (String)"Invalid user can login to the API store");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

