/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIImportExportTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIImportExportTestCase.class);
    private final String API_NAME = "APIImportExportTestCaseAPIName";
    private final String NEW_API_NAME = "NewAPIImportExportTestCaseAPIName";
    private final String PRESERVE_PUBLISHER_API_NAME = "preserveNewAPIImportExportAPIName";
    private final String NOT_PRESERVE_PUBLISHER_API_NAME = "notPreserveNewAPIImportExportAPIName";
    private final String PRESERVE_PUBLISHER_API_CONTEXT = "preserveAPIImportExportContext";
    private final String NOT_PRESERVE_PUBLISHER_API_CONTEXT = "notPreserveAPIImportExportContext";
    private final String API_CONTEXT = "APIImportExportTestCaseContext";
    private final String NEW_API_CONTEXT = "NewAPIImportExportTestCaseContext";
    private final String ALLOWED_ROLE = "allowedRole";
    private final String VISIBILITY_ROLE = "visibilityRole";
    private final String NOT_ALLOWED_ROLE = "denyRole";
    private final String ADMIN_ROLE = "admin";
    private final String[] PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private final char[] ALLOWED_USER_PASS = "pass@123".toCharArray();
    private final char[] DENIED_USER_PASS = "pass@123".toCharArray();
    private final char[] PUBLISHER_USER_PASS = "pass@123".toCharArray();
    private final String SCOPE_NAME = "ImportExportScope";
    private final String TAG1 = "import";
    private final String TAG2 = "export";
    private final String TAG3 = "test";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "APIImportExportTestCaseApp";
    private final String NEW_APP_NAME = "newAPIImportExportTestCaseApp";
    private String allowedUser = "allowedUser";
    private String deniedUser = "deniedUser";
    private String publisherUser = "importExportPublisher";
    private String publisherURLHttps;
    private String storeURLHttp;
    private File zipTempDir;
    private File apiZip;
    private File newApiZip;
    private File preservePublisherApiZip;
    private File notPreservePublisherApiZip;
    private String importUrl;
    private String exportUrl;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String tags;
    private String tierCollection;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @Factory(dataProvider="userModeDataProvider")
    public APIImportExportTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.tags = "import,export,test";
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
        this.importUrl = this.publisherURLHttps + "api-import-export-test" + "/import-api";
        this.exportUrl = this.publisherURLHttps + "api-import-export-test" + "/export-api";
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient.addRole("allowedRole", null, this.PERMISSIONS);
        this.userManagementClient.addRole("denyRole", null, this.PERMISSIONS);
        this.userManagementClient.addRole("visibilityRole", null, this.PERMISSIONS);
        this.userManagementClient.addUser(this.allowedUser, String.valueOf(this.ALLOWED_USER_PASS), new String[]{"allowedRole", "visibilityRole"}, null);
        this.userManagementClient.addUser(this.deniedUser, String.valueOf(this.DENIED_USER_PASS), new String[]{"denyRole", "visibilityRole"}, null);
        this.userManagementClient.addUser(this.publisherUser, String.valueOf(this.PUBLISHER_USER_PASS), new String[]{"admin"}, null);
        if (!this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super")) {
            this.allowedUser = this.allowedUser + "@" + this.keyManagerContext.getContextTenant().getDomain();
            this.deniedUser = this.deniedUser + "@" + this.keyManagerContext.getContextTenant().getDomain();
            this.publisherUser = this.publisherUser + "@" + this.keyManagerContext.getContextTenant().getDomain();
        }
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIImportExportTestCaseAPIName", "APIImportExportTestCaseContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Plus", "/post");
        APIResourceBean res2 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "Basic", "/get");
        APIResourceBean res3 = new APIResourceBean("PUT", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_USER.getAuthType(), "Ultimate", "/put");
        APIResourceBean res4 = new APIResourceBean("DELETE", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Unlimited", "/delete");
        APIResourceBean res5 = new APIResourceBean("PATCH", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Basic", "/patch");
        APIResourceBean res6 = new APIResourceBean("HEAD", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Basic", "/head");
        APIResourceBean res7 = new APIResourceBean("OPTIONS", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Basic", "/options");
        this.resList.add(res1);
        this.resList.add(res2);
        this.resList.add(res3);
        this.resList.add(res4);
        this.resList.add(res5);
        this.resList.add(res6);
        this.resList.add(res7);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIImportExportTestCaseAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API", dependsOnMethods={"testAPICreation"})
    public void testAPIExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "APIImportExportTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + this.user.getUserName());
        this.zipTempDir = Files.createTempDir();
        String fileName = this.user.getUserDomain() + "_" + "APIImportExportTestCaseAPIName";
        this.apiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportAPI(exportRequest, this.apiZip);
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testAPIExport"})
    public void testAPIImport() throws Exception {
        HttpResponse serviceResponse = this.apiPublisher.deleteAPI("APIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.verifyResponse(serviceResponse);
        this.importAPI(this.importUrl, this.apiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
    }

    @Test(groups={"wso2.am"}, description="Checking status of the imported API", dependsOnMethods={"testAPIImport"})
    public void testAPIState() throws Exception {
        HttpResponse response = this.apiPublisher.getAPI("APIImportExportTestCaseAPIName", this.user.getUserName(), "1.0.0");
        this.verifyResponse(response);
        JSONObject responseObj = new JSONObject(response.getData());
        JSONObject apiObj = responseObj.getJSONObject("api");
        String state = apiObj.getString("status");
        Assert.assertEquals((String)state, (String)APILifeCycleState.CREATED.getState(), (String)"Imported API not in Created state");
        Assert.assertEquals((String)"APIImportExportTestCaseAPIName", (String)apiObj.getString("name"), (String)"Imported API Name is incorrect");
        Assert.assertEquals((String)"1.0.0", (String)apiObj.getString("version"), (String)"Imported API version is incorrect");
        Assert.assertEquals((String)"This is test API create by API manager integration test", (String)apiObj.getString("description"), (String)"Imported API description is incorrect");
        Assert.assertTrue((boolean)this.tags.contains("import"), (String)"Imported API not contain tag: import");
        Assert.assertTrue((boolean)this.tags.contains("export"), (String)"Imported API not contain tag: export");
        Assert.assertTrue((boolean)this.tags.contains("test"), (String)"Imported API not contain tag: test");
        Assert.assertTrue((boolean)apiObj.getString("availableTiersDisplayNames").contains("Gold"), (String)"Imported API not contain Tier: Gold");
        Assert.assertTrue((boolean)apiObj.getString("availableTiersDisplayNames").contains("Bronze"), (String)"Imported API not contain Tier: Bronze");
        Assert.assertTrue((boolean)apiObj.getString("availableTiersDisplayNames").contains("Silver"), (String)"Imported API not contain Tier: Silver");
        Assert.assertTrue((boolean)apiObj.getString("availableTiersDisplayNames").contains("Unlimited"), (String)"Imported API not contain Tier: Unlimited");
        Assert.assertEquals((String)"checked", (String)apiObj.getString("transport_http"), (String)"Imported API HTTP transport status is incorrect");
        Assert.assertEquals((String)"checked", (String)apiObj.getString("transport_https"), (String)"Imported API HTTPS transport status is incorrect");
        Assert.assertEquals((String)"Disabled", (String)apiObj.getString("responseCache"), (String)"Imported API response Cache status is incorrect");
        Assert.assertEquals((String)"public", (String)apiObj.getString("visibility"), (String)"Imported API visibility is incorrect");
        Assert.assertEquals((String)"false", (String)apiObj.getString("isDefaultVersion"), (String)"Imported API Default Version status is incorrect");
        JSONArray resourcesList = new JSONArray(apiObj.getString("resources"));
        Assert.assertEquals((int)this.resList.size(), (int)resourcesList.length(), (String)"Imported API not in Created state");
        String method = null;
        String authType = null;
        String tier = null;
        String urlPattern = null;
        for (int i = 0; i < this.resList.size(); ++i) {
            APIResourceBean res = this.resList.get(i);
            for (int j = 0; j < resourcesList.length(); ++j) {
                JSONObject verb = resourcesList.getJSONObject(j).getJSONObject("http_verbs");
                Iterator it = verb.keys();
                if (!it.hasNext()) continue;
                method = (String)it.next();
                if (!StringUtils.equals((String)res.getResourceMethod(), (String)method)) continue;
                JSONObject resProp = verb.getJSONObject(method);
                authType = resProp.getString("auth_type");
                tier = resProp.getString("throttling_tier");
                urlPattern = resourcesList.getJSONObject(j).getString("url_pattern");
                break;
            }
            Assert.assertEquals((String)res.getResourceMethod(), method, (String)"Imported API Resource method is incorrect");
            Assert.assertEquals((String)res.getResourceMethodAuthType(), authType, (String)"Imported API Resource Auth Type is incorrect");
            Assert.assertEquals((String)res.getResourceMethodThrottlingTier(), tier, (String)"Imported API Resource Tier is incorrect");
            Assert.assertEquals((String)res.getUriTemplate(), urlPattern, (String)"Imported API Resource URL template is incorrect");
        }
    }

    @Test(groups={"wso2.am"}, description="Implementing sample api for scope test", dependsOnMethods={"testAPIState"})
    public void testNewAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("NewAPIImportExportTestCaseAPIName", "NewAPIImportExportTestCaseContext", "1.0.0", providerName, new URL(this.endpointUrl));
        String swagger = "{\"paths\": {\"/add\": {\"get\": {\"x-auth-type\": \"" + URLEncoder.encode("Application & Application User", "UTF-8") + "\"," + "\"x-throttling-tier\": \"" + "Unlimited" + "\"," + "\"x-scope\": \"" + "ImportExportScope" + "\"," + "\"responses\": {" + "\"200\": {}" + "}," + "\"parameters\": [{" + "\"name\": \"x\"," + "\"paramType\": \"query\"," + "\"required\": false," + "\"type\": \"string\"," + "\"description\": \"First value\"," + "\"in\": \"query\"" + "}, {" + "\"name\": \"y\"," + "\"paramType\": \"query\"," + "\"required\": false," + "\"type\": \"string\"," + "\"description\": \"Second Value\"," + "\"in\": \"query\"" + "}]" + "}" + "}" + "}," + "\"swagger\": \"2.0\"," + "\"x-wso2-security\": {" + "\"apim\": {" + "\"x-wso2-scopes\": [{" + "\"description\": \"Sample Scope\"," + "\"name\": \"" + "ImportExportScope" + "\"," + "\"roles\": \"" + "allowedRole" + "\"," + "\"key\": \"" + "ImportExportScope" + "\"" + "}]" + "}" + "}," + "\"info\": {" + "\"title\": \"" + "NewAPIImportExportTestCaseAPIName" + "\"," + "\"" + "1.0.0" + "\": \"1.0.0\"" + "}" + "}";
        this.apiCreationRequestBean.setSwagger(swagger);
        this.apiCreationRequestBean.setVisibility("restricted");
        this.apiCreationRequestBean.setRoles("visibilityRole");
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("NewAPIImportExportTestCaseAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Invoke the API before export", dependsOnMethods={"testNewAPICreation"})
    public void testNewAPIInvoke() throws Exception {
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.allowedUser, String.valueOf(this.ALLOWED_USER_PASS));
        HttpResponse serviceResponse = this.apiStore.addApplication("APIImportExportTestCaseApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        String provider = this.user.getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("NewAPIImportExportTestCaseAPIName", provider);
        subscriptionRequest.setApplicationName("APIImportExportTestCaseApp");
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APIImportExportTestCaseApp");
        generateAppKeyRequest.setTokenScope("ImportExportScope");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("NewAPIImportExportTestCaseContext", "1.0.0");
        serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)200, (int)serviceResponse.getResponseCode(), (String)"Imported API not in Created state");
    }

    @Test(groups={"wso2.am"}, description="Exporting above created new API", dependsOnMethods={"testNewAPIInvoke"})
    public void testNewAPIExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "NewAPIImportExportTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + this.user.getUserName());
        String fileName = this.user.getUserDomain() + "_" + "NewAPIImportExportTestCaseAPIName";
        this.newApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportAPI(exportRequest, this.newApiZip);
    }

    @Test(groups={"wso2.am"}, description="Importing new API", dependsOnMethods={"testNewAPIExport"})
    public void testNewAPIImport() throws Exception {
        HttpResponse serviceResponse = this.apiStore.removeApplication("APIImportExportTestCaseApp");
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiPublisher.deleteAPI("NewAPIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.verifyResponse(serviceResponse);
        this.importAPI(this.importUrl, this.newApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
    }

    @Test(groups={"wso2.am"}, description="Checking newly imported API status", dependsOnMethods={"testNewAPIImport"})
    public void testNewAPIState() throws Exception {
        HttpResponse response = this.apiPublisher.getAPI("NewAPIImportExportTestCaseAPIName", this.user.getUserName(), "1.0.0");
        this.verifyResponse(response);
        JSONObject responseObj = new JSONObject(response.getData());
        JSONObject apiObj = responseObj.getJSONObject("api");
        String state = apiObj.getString("status");
        Assert.assertEquals((String)state, (String)APILifeCycleState.CREATED.getState(), (String)"Imported API not in Created state");
        Assert.assertEquals((String)"NewAPIImportExportTestCaseAPIName", (String)apiObj.getString("name"), (String)"Imported API name is incorrect");
        Assert.assertEquals((String)"1.0.0", (String)apiObj.getString("version"), (String)"Imported API version is incorrect");
        Assert.assertEquals((String)"restricted", (String)apiObj.getString("visibility"), (String)"Imported API Visibility is incorrect");
        String endpointConfig = apiObj.getString("endpointConfig");
        Assert.assertEquals((String)this.endpointUrl, (String)new JSONObject(endpointConfig).getJSONObject("production_endpoints").getString("url"), (String)"Imported API Endpoint url is incorrect");
    }

    @Test(groups={"wso2.am"}, description="Invoke the newly imported API", dependsOnMethods={"testNewAPIState"})
    public void testNewAPIInvokeAfterImport() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("NewAPIImportExportTestCaseAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        HttpResponse serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.deniedUser, String.valueOf(this.DENIED_USER_PASS));
        serviceResponse = this.apiStore.addApplication("newAPIImportExportTestCaseApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        String provider = this.user.getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("NewAPIImportExportTestCaseAPIName", provider);
        subscriptionRequest.setApplicationName("newAPIImportExportTestCaseApp");
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("newAPIImportExportTestCaseApp");
        generateAppKeyRequest.setTokenScope("ImportExportScope");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("NewAPIImportExportTestCaseContext", "1.0.0");
        serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)403, (int)serviceResponse.getResponseCode(), (String)"Imported API not in Created state");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testNewAPIInvokeAfterImport"})
    public void testPreserveProviderTrueAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("preserveNewAPIImportExportAPIName", "preserveAPIImportExportContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Plus", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("preserveNewAPIImportExportAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API", dependsOnMethods={"testPreserveProviderTrueAPICreation"})
    public void testPreserveProviderTrueApiExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "preserveNewAPIImportExportAPIName" + "&version=" + "1.0.0" + "&provider=" + this.user.getUserName());
        String fileName = this.user.getUserDomain() + "_" + "preserveNewAPIImportExportAPIName";
        this.preservePublisherApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportAPI(exportRequest, this.preservePublisherApiZip);
        HttpResponse serviceResponse = this.apiPublisher.deleteAPI("preserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testPreserveProviderTrueApiExport"})
    public void testPreserveProviderTrueSameProviderApiImport() throws Exception {
        this.importAPI(this.importUrl + "?preserveProvider=true", this.preservePublisherApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
        HttpResponse response = this.apiPublisher.getAPI("preserveNewAPIImportExportAPIName", this.user.getUserName(), "1.0.0");
        this.verifyResponse(response);
        JSONObject responseObj = new JSONObject(response.getData());
        JSONObject apiObj = responseObj.getJSONObject("api");
        String provider = apiObj.getString("provider");
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=true");
        HttpResponse serviceResponse = this.apiPublisher.deleteAPI("preserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.verifyResponse(serviceResponse);
        this.importAPI(this.importUrl + "?preserveProvider=true", this.preservePublisherApiZip, this.publisherUser, this.PUBLISHER_USER_PASS);
        response = this.apiPublisher.getAPI("preserveNewAPIImportExportAPIName", this.user.getUserName(), "1.0.0");
        this.verifyResponse(response);
        responseObj = new JSONObject(response.getData());
        apiObj = responseObj.getJSONObject("api");
        provider = apiObj.getString("provider");
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=true");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testPreserveProviderTrueSameProviderApiImport"})
    public void testPreserveProviderFalseAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("notPreserveNewAPIImportExportAPIName", "notPreserveAPIImportExportContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "Plus", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("notPreserveNewAPIImportExportAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API", dependsOnMethods={"testPreserveProviderFalseAPICreation"})
    public void testPreserveProviderFalseApiExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "notPreserveNewAPIImportExportAPIName" + "&version=" + "1.0.0" + "&provider=" + this.user.getUserName());
        String fileName = this.user.getUserDomain() + "_" + "notPreserveNewAPIImportExportAPIName";
        this.notPreservePublisherApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportAPI(exportRequest, this.notPreservePublisherApiZip);
        HttpResponse serviceResponse = this.apiPublisher.deleteAPI("notPreserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testPreserveProviderFalseApiExport"})
    public void testPreserveProviderFalseSameProviderApiImport() throws Exception {
        this.importAPI(this.importUrl + "?preserveProvider=false", this.notPreservePublisherApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
        HttpResponse response = this.apiPublisher.getAPI("notPreserveNewAPIImportExportAPIName", this.user.getUserName(), "1.0.0");
        this.verifyResponse(response);
        JSONObject responseObj = new JSONObject(response.getData());
        JSONObject apiObj = responseObj.getJSONObject("api");
        String provider = apiObj.getString("provider");
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=false");
        this.importAPI(this.importUrl + "?preserveProvider=false", this.notPreservePublisherApiZip, this.publisherUser, this.PUBLISHER_USER_PASS);
        response = this.apiPublisher.getAPI("notPreserveNewAPIImportExportAPIName", this.publisherUser, "1.0.0");
        this.verifyResponse(response);
        responseObj = new JSONObject(response.getData());
        apiObj = responseObj.getJSONObject("api");
        provider = apiObj.getString("provider");
        Assert.assertEquals((String)provider, (String)this.publisherUser, (String)"Provider is not as expected when 'preserveProvider'=false");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("newAPIImportExportTestCaseApp");
        this.apiPublisher.deleteAPI("APIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.apiPublisher.deleteAPI("NewAPIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        boolean deleteStatus = this.apiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.newApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.preservePublisherApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.notPreservePublisherApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.zipTempDir.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp directory delete not successful");
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private String encodeCredentials(String user, char[] pass) {
        StringBuilder builder = new StringBuilder(user).append(':').append(pass);
        String cred = builder.toString();
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        return new String(encodedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportAPI(URL exportRequest, File fileName) throws URISyntaxException, IOException {
        CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();
        HttpGet get = new HttpGet(exportRequest.toURI());
        get.addHeader("Authorization", "Basic " + this.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            FileOutputStream outStream = new FileOutputStream(fileName);
            try {
                entity.writeTo((OutputStream)outStream);
            }
            finally {
                outStream.close();
            }
        }
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Response code is not as expected");
        Assert.assertTrue((boolean)fileName.exists(), (String)"File save was not successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importAPI(String importUrl, File fileName, String user, char[] pass) throws IOException {
        String temp;
        URL url = new URL(importUrl);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        FileBody fileBody = new FileBody(fileName);
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        multipartEntity.addPart("file", (ContentBody)fileBody);
        connection.setRequestProperty("Content-Type", multipartEntity.getContentType().getValue());
        connection.setRequestProperty("Authorization", "Basic " + this.encodeCredentials(user, pass));
        OutputStream out = connection.getOutputStream();
        try {
            multipartEntity.writeTo(out);
        }
        finally {
            out.close();
        }
        int status = connection.getResponseCode();
        BufferedReader read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((temp = read.readLine()) != null) {
            response.append(temp);
        }
        Assert.assertEquals((int)status, (int)201, (String)("Response code is not as expected : " + response));
    }
}

