/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM710AllSubscriptionsByApplicationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM710AllSubscriptionsByApplicationTestCase.class);
    private String apiName = "SubscriptionAPITest";
    private String apiContext = "subscriptionapicontext";
    private final String version = "1.0.0";
    private final String visibility = "public";
    private final String description = "API subscription";
    private String providerName;
    private final String tier = "Unlimited";
    private final String tags = "subscription";
    private final String applicationName = "APIM710SubscribeApplication";
    private static final String webApp = "jaxrs_basic";
    private final String endPointType = "http";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String gatewayUrl;
    private int numberOfApis = 5;
    List<String> apiNameList = new ArrayList<String>();
    List<String> apiContextList = new ArrayList<String>();
    private String accessUrl;
    private boolean isApisDeleted = false;
    private int defaultAppListIndex;
    private String newApplicationName = "APIM710NewApplication1";

    @Factory(dataProvider="userModeDataProvider")
    public APIM710AllSubscriptionsByApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        String fileFormat = ".war";
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String path = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator;
        String sourcePath = path + webApp + fileFormat;
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePath);
        boolean isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
        Assert.assertTrue((boolean)isWebAppDeployed, (String)"Web APP is not deployed");
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String uri = "customers/{id}/";
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", uri));
        String endpoint = "/services/customers/customerservice";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + webApp + endpoint;
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        int count = 1;
        for (int apiCount = 0; apiCount < this.numberOfApis; ++apiCount) {
            String tempApiName = this.apiName + count;
            String tempApiContext = this.apiContext + count;
            APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(tempApiName, tempApiContext, "1.0.0", this.providerName, new URL(endpointUrl));
            apiCreationRequestBean.setEndpointType("http");
            apiCreationRequestBean.setTiersCollection("Unlimited");
            apiCreationRequestBean.setTags("subscription");
            apiCreationRequestBean.setResourceBeanList(resourceBeanList);
            apiCreationRequestBean.setDescription("API subscription");
            apiCreationRequestBean.setVisibility("public");
            HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
            Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
            JSONObject createApiJsonObject = new JSONObject(apiCreateResponse.getData());
            Assert.assertEquals((boolean)createApiJsonObject.getBoolean("error"), (boolean)false, (String)"Error in API Creation");
            HttpResponse verifyApiResponse = this.apiPublisher.getApi(tempApiName, this.providerName, "1.0.0");
            JSONObject verifyApiJsonObject = new JSONObject(verifyApiResponse.getData());
            Assert.assertFalse((boolean)verifyApiJsonObject.getBoolean("error"), (String)"Error in Verify API Response");
            this.apiNameList.add(tempApiName);
            this.apiContextList.add(tempApiContext);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(tempApiName, this.providerName, APILifeCycleState.PUBLISHED);
            HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
            JSONObject statusUpdateJsonObject = new JSONObject(statusUpdateResponse.getData());
            Assert.assertFalse((boolean)statusUpdateJsonObject.getBoolean("error"), (String)"API is not published");
            Thread.sleep(10000L);
            ++count;
        }
        this.gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        HttpResponse createAppResponse = this.apiStore.addApplication("APIM710SubscribeApplication", "Unlimited", "", "");
        Assert.assertEquals((int)createAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Application Creation");
        JSONObject createAppJsonObject = new JSONObject(createAppResponse.getData());
        Assert.assertFalse((boolean)createAppJsonObject.getBoolean("error"), (String)"Error in Application creation Response: APIM710SubscribeApplication");
        for (int apiCount = 0; apiCount < this.numberOfApis - 2; ++apiCount) {
            this.accessUrl = this.gatewayUrl + this.apiContextList.get(apiCount) + "/" + "1.0.0" + "/customers/123";
            SubscriptionRequest apiSubscriptionRequest = new SubscriptionRequest(this.apiNameList.get(apiCount), "1.0.0", this.providerName, "APIM710SubscribeApplication", "Unlimited");
            HttpResponse subscriptionResponse = this.apiStore.subscribe(apiSubscriptionRequest);
            Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Subscription Response Code is Mismatched");
            JSONObject subscriptionResponseJsonObject = new JSONObject(subscriptionResponse.getData());
            Assert.assertFalse((boolean)subscriptionResponseJsonObject.getBoolean("error"), (String)"Subscription Response is Mismatched");
            Thread.sleep(3000L);
        }
        HttpResponse createNewAppResponse = this.apiStore.addApplication(this.newApplicationName, "Unlimited", "", "");
        Assert.assertEquals((int)createAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Application Creation");
        JSONObject createNewAppJsonObject = new JSONObject(createNewAppResponse.getData());
        Assert.assertFalse((boolean)createAppJsonObject.getBoolean("error"), (String)"Error in Application creation Response: APIM710SubscribeApplication");
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        for (int apiCount = this.numberOfApis - 2; apiCount < this.numberOfApis; ++apiCount) {
            this.accessUrl = this.gatewayUrl + this.apiContextList.get(apiCount) + "/" + "1.0.0" + "/customers/123";
            SubscriptionRequest apiSubscriptionRequestDefaultApp = new SubscriptionRequest(this.apiNameList.get(apiCount), "1.0.0", this.providerName, this.newApplicationName, "Unlimited");
            HttpResponse subscriptionResponseDefaultApp = this.apiStore.subscribe(apiSubscriptionRequestDefaultApp);
            Assert.assertEquals((int)subscriptionResponseDefaultApp.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Subscription Response Code is Mismatched");
            JSONObject subscriptionResponseJsonObject = new JSONObject(subscriptionResponseDefaultApp.getData());
            Assert.assertFalse((boolean)subscriptionResponseJsonObject.getBoolean("error"), (String)"Subscription Response is Mismatched");
            Thread.sleep(3000L);
        }
    }

    @Test(description="List all Subscriptions By Application Name")
    public void testAllSubscriptionsByAppName() throws Exception {
        HttpResponse publishedApiByAppResponse = this.apiStore.getPublishedAPIsByApplication("APIM710SubscribeApplication");
        Assert.assertEquals((int)publishedApiByAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched: APIM710SubscribeApplication");
        JSONObject publishedApiByAppJsonObject = new JSONObject(publishedApiByAppResponse.getData());
        Assert.assertFalse((boolean)publishedApiByAppJsonObject.getBoolean("error"), (String)"Response Data Mismatched: APIM710SubscribeApplication");
        log.info((Object)publishedApiByAppJsonObject);
        JSONArray applicationSubscribedJsonArray = publishedApiByAppJsonObject.getJSONArray("apis");
        Assert.assertTrue((applicationSubscribedJsonArray.length() >= this.apiNameList.size() - 2 ? 1 : 0) != 0, (String)"Api Count is mismatched");
        boolean isApisAvailable = false;
        for (int index = 0; index < applicationSubscribedJsonArray.length(); ++index) {
            isApisAvailable = true;
            Assert.assertEquals((String)applicationSubscribedJsonArray.getJSONObject(index).getString("apiName"), (String)this.apiNameList.get(index), (String)"Api Name is Mismatched");
        }
        Assert.assertTrue((boolean)isApisAvailable, (String)"Response Error in Apis");
        publishedApiByAppResponse = this.apiStore.getPublishedAPIsByApplication(this.newApplicationName);
        Assert.assertEquals((int)publishedApiByAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Response Code Mismatched: " + this.newApplicationName));
        publishedApiByAppJsonObject = new JSONObject(publishedApiByAppResponse.getData());
        Assert.assertFalse((boolean)publishedApiByAppJsonObject.getBoolean("error"), (String)("Response Data Mismatched: " + this.newApplicationName));
        log.info((Object)publishedApiByAppJsonObject);
        JSONArray defaultApplicationSubscribedJsonArray = publishedApiByAppJsonObject.getJSONArray("apis");
        Assert.assertTrue((defaultApplicationSubscribedJsonArray.length() >= 2 ? 1 : 0) != 0, (String)"Api Count is mismatched");
        isApisAvailable = false;
        int defaultAppListIndex = this.numberOfApis - 2;
        for (int index = 0; index < defaultApplicationSubscribedJsonArray.length(); ++index) {
            isApisAvailable = true;
            Assert.assertEquals((String)defaultApplicationSubscribedJsonArray.getJSONObject(index).getString("apiName"), (String)this.apiNameList.get(defaultAppListIndex), (String)"Api Name is Mismatched");
            ++defaultAppListIndex;
        }
        Assert.assertTrue((boolean)isApisAvailable, (String)"Response Error in Apis");
    }

    @Test(description="Remove Subscription by Application Name", dependsOnMethods={"testAllSubscriptionsByAppName"})
    public void testRemoveSubscriptionByAppName() throws Exception {
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        for (int apiCount = 0; apiCount < this.numberOfApis - 2; ++apiCount) {
            HttpResponse removeSubscriptionByAppName = this.apiStore.removeAPISubscriptionByName(this.apiNameList.get(apiCount), "1.0.0", this.providerName, "APIM710SubscribeApplication");
            Assert.assertEquals((int)removeSubscriptionByAppName.getResponseCode(), (int)Response.Status.OK.getStatusCode());
            JSONObject removeSubscriptionByAppNameJsonObject = new JSONObject(removeSubscriptionByAppName.getData());
            Assert.assertFalse((boolean)removeSubscriptionByAppNameJsonObject.getBoolean("error"), (String)"Error in Remove Subscription By Application Name: APIM710SubscribeApplication");
            Thread.sleep(3000L);
        }
        HttpResponse verifySubscriptionResponse = this.apiStore.getPublishedAPIsByApplication("APIM710SubscribeApplication");
        Assert.assertEquals((int)verifySubscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Subscription verification Response");
        JSONObject verifySubscriptionJsonObject = new JSONObject(verifySubscriptionResponse.getData());
        Assert.assertFalse((boolean)verifySubscriptionJsonObject.getBoolean("error"), (String)"Error in Subscription verification Response");
        JSONArray apisJsonArray = verifySubscriptionJsonObject.getJSONArray("apis");
    }

    @Test(description="Remove Subscription By Application Id", dependsOnMethods={"testAllSubscriptionsByAppName"})
    public void testRemoveSubscriptionByAppId() throws Exception {
        this.defaultAppListIndex = this.numberOfApis - 2;
        HttpResponse getAllAppResponse = this.apiStore.getAllApplications();
        Assert.assertEquals((int)getAllAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Get All Apps Response");
        JSONObject getAllAppJsonObject = new JSONObject(getAllAppResponse.getData());
        Assert.assertFalse((boolean)getAllAppJsonObject.getBoolean("error"), (String)"Error in get Applications Response");
        JSONArray getAllAppsJsonArray = getAllAppJsonObject.getJSONArray("applications");
        for (int arrayIndex = 0; arrayIndex < getAllAppsJsonArray.length(); ++arrayIndex) {
            if (!getAllAppsJsonArray.getJSONObject(arrayIndex).getString("name").equals(this.newApplicationName)) continue;
            String defaultAppId = getAllAppsJsonArray.getJSONObject(arrayIndex).getString("id");
            HttpResponse removeSubscriptionByIdResponse = this.apiStore.removeAPISubscription(this.apiNameList.get(this.defaultAppListIndex), "1.0.0", this.providerName, defaultAppId);
            Assert.assertEquals((int)removeSubscriptionByIdResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
            JSONObject removeSubscriptionByIdJsonObject = new JSONObject(removeSubscriptionByIdResponse.getData());
            Assert.assertFalse((boolean)removeSubscriptionByIdJsonObject.getBoolean("error"), (String)"Error in Removal Subscription By Application Id");
            Thread.sleep(2000L);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        int listIndex;
        this.apiStore.removeApplication("APIM710SubscribeApplication");
        this.isApisDeleted = false;
        for (listIndex = 0; listIndex < this.apiNameList.size() - 2; ++listIndex) {
            this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
            this.apiPublisher.deleteAPI(this.apiNameList.get(listIndex), "1.0.0", this.providerName);
            this.isApisDeleted = true;
        }
        Assert.assertTrue((boolean)this.isApisDeleted, (String)"Application and Apis are Not deleted");
        this.isApisDeleted = false;
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        for (listIndex = 0; listIndex < 2; ++listIndex) {
            this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
            this.apiPublisher.deleteAPI(this.apiNameList.get(this.defaultAppListIndex), "1.0.0", this.providerName);
            this.isApisDeleted = true;
            ++this.defaultAppListIndex;
            Thread.sleep(5000L);
        }
        Assert.assertTrue((boolean)this.isApisDeleted, (String)"Error in Application Deleted: APIM710SubscribeApplication");
        this.apiStore.removeApplication(this.newApplicationName);
        super.cleanUp();
    }
}

