/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM714GetAllDocumentationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM714GetAllDocumentationTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final String apiName = "DocumentTestAPI";
    private static final String apiVersion = "1.0.0";
    private final String applicationName = "NewApplication";
    private static final String apiContext = "documenttestapi";
    private final String tags = "document";
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private final String description = "testApiWithDocument";
    private String apiProvider;
    private static final String webApp = "jaxrs_basic";
    private String endpointUrl;
    private final String endPointType = "http";
    private final String visibility = "public";
    private int documentsCount;
    private String sourceTypeInLine = "";
    private String sourceTypeUrl = "";
    private String sourceTypeFile = "";
    private String docType = "";
    private String docName = "";
    private String docNameWithUrl = "";
    private String docNameWithFile = "";
    private String docUrl = "";
    private String sourceDocUrl = "";

    @Factory(dataProvider="userModeDataProvider")
    public APIM714GetAllDocumentationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        String fileFormat = ".war";
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String path = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator;
        String sourcePath = path + webApp + fileFormat;
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePath);
        boolean isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
        Assert.assertTrue((boolean)isWebAppDeployed, (String)"Web APP is not deployed: jaxrs_basic");
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse publisherLogin = this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)publisherLogin.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Publisher Login Response Code is Mismatched: ");
        HttpResponse loginResponse = this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)loginResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code is Mismatched in Login Response");
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Response data error in Login Request");
        String uri = "customers/{id}/";
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, uri));
        String endpoint = "/services/customers/customerservice";
        this.endpointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + webApp + endpoint;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, apiVersion, this.apiProvider, new URL(this.endpointUrl));
        apiCreationRequestBean.setEndpointType("http");
        apiCreationRequestBean.setTier(this.tier);
        apiCreationRequestBean.setTags("document");
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setDescription("testApiWithDocument");
        apiCreationRequestBean.setVisibility("public");
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        JSONObject createApiJsonObject = new JSONObject(apiCreateResponse.getData());
        Assert.assertEquals((boolean)createApiJsonObject.getBoolean("error"), (boolean)false, (String)"Error in API Creation");
        HttpResponse verifyApiResponse = this.apiPublisher.getApi(apiName, this.apiProvider, apiVersion);
        JSONObject verifyApiJsonObject = new JSONObject(verifyApiResponse.getData());
        Assert.assertFalse((boolean)verifyApiJsonObject.getBoolean("error"), (String)"Error in Verify API Response");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.apiProvider, APILifeCycleState.PUBLISHED);
        HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
        JSONObject statusUpdateJsonObject = new JSONObject(statusUpdateResponse.getData());
        Assert.assertFalse((boolean)statusUpdateJsonObject.getBoolean("error"), (String)"API is not published");
        this.docName = "TestDocumentInLine";
        this.docType = "how to";
        this.sourceTypeInLine = "inline";
        String summary = "TestFile";
        String docLocation = "";
        HttpResponse addDocumentResponse = this.apiPublisher.addDocument(apiName, apiVersion, this.apiProvider, this.docName, this.docType, this.sourceTypeInLine, this.docUrl, summary, docLocation);
        Assert.assertEquals((int)addDocumentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Add Document Response Code");
        JSONObject addDocumentJsonObject = new JSONObject(addDocumentResponse.getData());
        Assert.assertFalse((boolean)addDocumentJsonObject.getBoolean("error"), (String)("Response Error in Add Document: " + this.docName));
        this.sourceDocUrl = "https://docs.wso2.com/display/AM191/Tutorials";
        this.sourceTypeUrl = "url";
        this.docNameWithUrl = "TestDocumentWithUrl";
        HttpResponse addDocumentWithUrlResponse = this.apiPublisher.addDocument(apiName, apiVersion, this.apiProvider, this.docNameWithUrl, this.docType, this.sourceTypeUrl, this.sourceDocUrl, summary, docLocation);
        Assert.assertEquals((int)addDocumentWithUrlResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched in Add Document");
        JSONObject addDocumentWithUrlJsonObject = new JSONObject(addDocumentWithUrlResponse.getData());
        Assert.assertFalse((boolean)addDocumentWithUrlJsonObject.getBoolean("error"), (String)"Error in Add Document with Response");
        this.documentsCount = 2;
    }

    @Test(description="Get All Documents")
    public void testAllDocuments() throws Exception {
        this.apiProvider = this.storeContext.getContextTenant().getContextUser().getUserName();
        HttpResponse getAllDocumentsResponse = this.apiStore.getAllDocumentationOfAPI(apiName, apiVersion, this.apiProvider);
        Assert.assertEquals((int)getAllDocumentsResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Get All Documents Response: DocumentTestAPI");
        JSONObject getAllDocumentsJsonObject = new JSONObject(getAllDocumentsResponse.getData());
        Assert.assertFalse((boolean)getAllDocumentsJsonObject.getBoolean("error"), (String)"Error in Get All Documentation Response: DocumentTestAPI");
        JSONArray getAllDocumentJsonArray = getAllDocumentsJsonObject.getJSONArray("documentations");
        Assert.assertEquals((int)getAllDocumentJsonArray.length(), (int)this.documentsCount, (String)"Invalid Documents Count");
        boolean isDocumentWithUrlAppAvailable = false;
        boolean isDocumentAppAvailable = false;
        for (int arrayIndex = 0; arrayIndex < getAllDocumentJsonArray.length(); ++arrayIndex) {
            if (getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("name").equals(this.docNameWithUrl)) {
                isDocumentWithUrlAppAvailable = true;
                Assert.assertTrue((boolean)getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("sourceType").equalsIgnoreCase(this.sourceTypeUrl), (String)"Error in Source Type");
                Assert.assertTrue((boolean)getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("sourceUrl").contains(this.sourceDocUrl), (String)"Error in Document Source Url: ");
                Assert.assertTrue((boolean)getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("type").equalsIgnoreCase(this.docType), (String)("Error in Doc Type: " + this.docType));
                continue;
            }
            if (!getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("name").equals(this.docName)) continue;
            isDocumentAppAvailable = true;
            Assert.assertTrue((boolean)getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("sourceType").equalsIgnoreCase(this.sourceTypeInLine), (String)"Error in Source Type");
            Assert.assertTrue((boolean)getAllDocumentJsonArray.getJSONObject(arrayIndex).getString("type").equalsIgnoreCase(this.docType), (String)("Error in Doc Type: " + this.docType));
        }
        Assert.assertTrue((boolean)isDocumentWithUrlAppAvailable, (String)"Error: Document With Url is not available");
        Assert.assertTrue((boolean)isDocumentAppAvailable, (String)"Error: Document App is not available");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        HttpResponse apiDeleteResponse = this.apiPublisher.deleteAPI(apiName, apiVersion, this.apiProvider);
        Assert.assertEquals((int)apiDeleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in API delete Response Code");
        JSONObject apiDeleteJsonObject = new JSONObject(apiDeleteResponse.getData());
        Assert.assertFalse((boolean)apiDeleteJsonObject.getBoolean("error"), (String)"Response data Error in Api Deletion: DocumentTestAPI");
        super.cleanUp();
    }
}

