/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM720GetAllEndPointsTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM720GetAllEndPointsTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final String apiName = "EndPointTestAPI";
    private static final String apiVersion = "1.0.0";
    private static final String apiContext = "endpointtestapi";
    private final String tags = "document";
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private final String description = "testApi";
    private String apiProvider;
    private static final String webApp = "jaxrs_basic";
    private String endpointUrl;
    private final String endPointType = "http";
    private final String visibility = "public";
    private String gatewayUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM720GetAllEndPointsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        String fileFormat = ".war";
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse publisherLogin = this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)publisherLogin.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Publisher Login Response Code is Mismatched: ");
        HttpResponse loginResponse = this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)loginResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code is Mismatched in Login Response");
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Response data error in Login Request");
        String uri = "customers/{id}/";
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, uri));
        String endpointProduction = "/services/customers/customerservice";
        String endpointSandbox = "/services/customers/customerservice";
        ArrayList<String> prodEndpointList = new ArrayList<String>();
        prodEndpointList.add(endpointProduction);
        ArrayList<String> sandboxEndpointList = new ArrayList<String>();
        sandboxEndpointList.add(endpointSandbox);
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, apiVersion, this.apiProvider, prodEndpointList, sandboxEndpointList);
        apiCreationRequestBean.setEndpointType("http");
        apiCreationRequestBean.setTier(this.tier);
        apiCreationRequestBean.setTags("document");
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setDescription("testApi");
        apiCreationRequestBean.setVisibility("public");
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        JSONObject createApiJsonObject = new JSONObject(apiCreateResponse.getData());
        Assert.assertEquals((boolean)createApiJsonObject.getBoolean("error"), (boolean)false, (String)"Error in API Creation");
        HttpResponse verifyApiResponse = this.apiPublisher.getApi(apiName, this.apiProvider, apiVersion);
        JSONObject verifyApiJsonObject = new JSONObject(verifyApiResponse.getData());
        Assert.assertFalse((boolean)verifyApiJsonObject.getBoolean("error"), (String)"Error in Verify API Response");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.apiProvider, APILifeCycleState.PUBLISHED);
        HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
        this.waitForAPIDeploymentSync(this.apiProvider, apiName, apiVersion, "\"isApiExists\":true");
        JSONObject statusUpdateJsonObject = new JSONObject(statusUpdateResponse.getData());
        Assert.assertFalse((boolean)statusUpdateJsonObject.getBoolean("error"), (String)"API is not published");
        this.gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
    }

    @Test(description="Get All Endpoints")
    public void getAllEndpointUrlsTest() throws Exception {
        HttpResponse getApiResponse = this.apiStore.getAllPublishedAPIs();
        Assert.assertEquals((int)getApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject getApiJsonObject = new JSONObject(getApiResponse.getData());
        Assert.assertFalse((boolean)getApiJsonObject.getBoolean("error"), (String)"Response code Mismatched in Get Api Response");
        JSONArray getApiJsonArray = getApiJsonObject.getJSONArray("apis");
        boolean isApiAvailable = false;
        boolean isEndpointUrlValid = false;
        boolean isHttpsUrlAvailable = false;
        boolean isHttpUrlAvailable = false;
        String environmentName = "Production and Sandbox";
        String environmentType = "hybrid";
        for (int apiIndex = 0; apiIndex < getApiJsonArray.length(); ++apiIndex) {
            if (!getApiJsonArray.getJSONObject(apiIndex).getString("name").equals(apiName)) continue;
            isApiAvailable = true;
            HttpResponse getEndpointApiResponse = this.apiStore.getApiEndpointUrls(apiName, apiVersion, this.apiProvider);
            Assert.assertEquals((int)getEndpointApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in get Endpoints Response Code");
            JSONObject getEndpointJsonObject = new JSONObject(getEndpointApiResponse.getData());
            Assert.assertFalse((boolean)getEndpointJsonObject.getBoolean("error"), (String)"Error in End point Urls Response");
            JSONArray getEndPointUrlsJsonArray = getEndpointJsonObject.getJSONArray("endpointURLs");
            block1: for (int index = 0; index < getEndPointUrlsJsonArray.length(); ++index) {
                if (!getEndPointUrlsJsonArray.getJSONObject(index).getString("environmentURLs").contains(apiContext)) continue;
                isEndpointUrlValid = true;
                Assert.assertTrue((boolean)getEndPointUrlsJsonArray.getJSONObject(index).getString("environmentName").equalsIgnoreCase(environmentName), (String)"Error in environment Name");
                Assert.assertTrue((boolean)getEndPointUrlsJsonArray.getJSONObject(index).getString("environmentType").equalsIgnoreCase(environmentType), (String)"Error in environment Type");
                JSONArray environmentUrlsArray = getEndPointUrlsJsonArray.getJSONObject(index).getJSONArray("environmentURLs");
                HashMap<String, String> urlMap = new HashMap<String, String>();
                for (int mapIndex = 0; mapIndex < environmentUrlsArray.length(); ++mapIndex) {
                    String jsonArrayElement = environmentUrlsArray.getString(mapIndex);
                    String[] keyValue = jsonArrayElement.split("=");
                    urlMap.put(keyValue[0], keyValue[1]);
                    URL url = new URL(keyValue[1]);
                    if (keyValue[0].equals("https")) {
                        isHttpsUrlAvailable = true;
                        Assert.assertEquals((String)url.getProtocol(), (String)keyValue[0], (String)"Error in URL Protocol");
                        Assert.assertEquals((String)url.getPath(), (String)"/endpointtestapi/1.0.0", (String)"Error in URL Path");
                    } else if (keyValue[0].equals("http")) {
                        isHttpUrlAvailable = true;
                        Assert.assertEquals((String)url.getProtocol(), (String)keyValue[0], (String)"Error in URL Protocol");
                        Assert.assertEquals((String)url.getPath(), (String)"/endpointtestapi/1.0.0", (String)"Error in URL Path");
                    }
                    if (isHttpsUrlAvailable && isHttpUrlAvailable) continue block1;
                }
            }
            break;
        }
        Assert.assertTrue((boolean)isHttpsUrlAvailable, (String)"Error: Https Url is mismatched");
        Assert.assertTrue((boolean)isHttpUrlAvailable, (String)"Error: Http Url is mismatched");
        Assert.assertTrue((boolean)isEndpointUrlValid, (String)"Error: EndPoint Url is not found");
        Assert.assertTrue((boolean)isApiAvailable, (String)"Error: Api is not available in Store");
    }

    @Test(description="Add Comments", dependsOnMethods={"getAllEndpointUrlsTest"})
    public void addCommentTest() throws Exception {
        this.apiProvider = this.storeContext.getContextTenant().getContextUser().getUserName();
        String comment = "testComment";
        HttpResponse addCommentResponse = this.apiStore.addComment(apiName, apiVersion, this.apiProvider, comment);
        Assert.assertEquals((int)addCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Add Comment Response");
        JSONObject addCommentJsonObject = new JSONObject(addCommentResponse.getData());
        Assert.assertFalse((boolean)addCommentJsonObject.getBoolean("error"), (String)"Error in Add Comment Response");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse deleteApiResponse = this.apiPublisher.deleteAPI(apiName, apiVersion, this.apiProvider);
        Assert.assertEquals((int)deleteApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Delete API Response");
        JSONObject deleteApiJsonObject = new JSONObject(deleteApiResponse.getData());
        Assert.assertFalse((boolean)deleteApiJsonObject.getBoolean("error"), (String)"Error in Delete API");
        super.cleanUp();
    }
}

