/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class APIMANAGER4373BrokenAPIInStoreTestCase
extends APIMIntegrationBaseTest {
    private final String USER_PASSWORD = "123123";
    private final String PERMISSION_LOGIN = "/permission/admin/login";
    private final String PERMISSION_API_SUBSCRIBE = "/permission/admin/manage/api/subscribe";
    private final String FIRST_USER = "APIMANAGER4373_user";
    private final String FIRST_ROLE = "APIMANAGER4373_role1";
    private final String SECOND_ROLE = "APIMANAGER4373_role2";
    private final String APP_NAME = "APIMANAGER4373";
    private final String BROKEN_API = "brokenAPI";
    private final String HEALTHY_API = "healthyAPI";
    private final String EP_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private final String API_VERSION = "1.0.0";
    private final String RESTRICTED = "restricted";
    private final String TAG_UPDATED = "updated";
    private String contextUsername = "admin";
    private String contextUserPassword = "admin";
    private UserManagementClient userManagementClient1;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStoreRestClient;
    private String publisherURLHttp;
    private String storeURLHttp;

    @BeforeMethod
    public void init() {
        try {
            super.init();
            this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
            this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
            this.apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
            this.contextUsername = this.keyManagerContext.getContextTenant().getContextUser().getUserName();
            this.contextUserPassword = this.keyManagerContext.getContextTenant().getContextUser().getPassword();
            this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.contextUsername, this.contextUserPassword);
            this.userManagementClient1.addRole("APIMANAGER4373_role1", new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient1.addRole("APIMANAGER4373_role2", new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient1.addUser("APIMANAGER4373_user", "123123", new String[]{"APIMANAGER4373_role1"}, "APIMANAGER4373_user");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while initializing testcase: " + e.getCause()));
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while adding new users: " + e.getCause()));
        }
        catch (UserAdminUserAdminException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while adding new users: " + e.getCause()));
        }
        catch (XPathExpressionException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while retrieving context: " + e.getCause()));
        }
    }

    @Test(groups={"wso2.am"}, description="Test effect of changing the role of subscribed API")
    public void testAPIRoleChangeEffectInStore() throws Exception {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest brokenApiRequest = new APIRequest("brokenAPI", "brokenAPI", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion("1.0.0");
        brokenApiRequest.setProvider(this.contextUsername);
        brokenApiRequest.setVisibility("restricted");
        brokenApiRequest.setRoles("APIMANAGER4373_role1");
        this.apiPublisher.addAPI(brokenApiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("brokenAPI", this.contextUsername, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        APIRequest healthyApiRequest = new APIRequest("healthyAPI", "healthyAPI", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        healthyApiRequest.setVersion("1.0.0");
        healthyApiRequest.setProvider(this.contextUsername);
        healthyApiRequest.setVisibility("restricted");
        healthyApiRequest.setRoles("APIMANAGER4373_role1");
        this.apiPublisher.addAPI(healthyApiRequest);
        updateRequest = new APILifeCycleStateRequest("healthyAPI", this.contextUsername, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(this.contextUsername, "healthyAPI", "1.0.0", "\"isApiExists\":true");
        this.apiStoreRestClient.login("APIMANAGER4373_user", "123123");
        this.apiStoreRestClient.addApplication("APIMANAGER4373", "Unlimited", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("brokenAPI", this.contextUsername);
        subscriptionRequest.setApplicationName("APIMANAGER4373");
        this.apiStoreRestClient.subscribe(subscriptionRequest);
        subscriptionRequest = new SubscriptionRequest("healthyAPI", this.contextUsername);
        subscriptionRequest.setApplicationName("APIMANAGER4373");
        this.apiStoreRestClient.subscribe(subscriptionRequest);
        brokenApiRequest.setRoles("APIMANAGER4373_role2");
        brokenApiRequest.setTags("updated");
        Thread.sleep(1000L);
        this.apiPublisher.updateAPI(brokenApiRequest);
        this.waitForAPIDeployment();
        HttpResponse response = new HttpResponse("", 500);
        try {
            response = this.apiStoreRestClient.getAllSubscriptions();
        }
        catch (Exception e) {
            // empty catch block
        }
        LogFactory.getLog(APIMANAGER4373BrokenAPIInStoreTestCase.class).error((Object)response.getData());
        Assert.assertTrue((boolean)response.getData().contains("healthyAPI"), (String)("Subscription retrieval failed when one API is broken: " + response.getData()));
    }

    @AfterMethod(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStoreRestClient != null) {
            this.apiStoreRestClient.removeAPISubscriptionByName("brokenAPI", "1.0.0", this.contextUsername, "APIMANAGER4373");
            this.apiStoreRestClient.removeAPISubscriptionByName("healthyAPI", "1.0.0", this.contextUsername, "APIMANAGER4373");
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI("brokenAPI", "1.0.0", this.contextUsername);
            this.apiPublisher.deleteAPI("healthyAPI", "1.0.0", this.contextUsername);
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser("APIMANAGER4373_user");
            this.userManagementClient1.deleteRole("APIMANAGER4373_role1");
            this.userManagementClient1.deleteRole("APIMANAGER4373_role2");
        }
        super.cleanUp();
    }
}

