/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class CopyNewVersionTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(CopyNewVersionTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private static final String API_NAME = "NewVersionAPITest";
    private static final String API_CONTEXT = "NewVersionAPI";
    private String version = "1.0.0";
    private String newVersion = "2.0.0";
    private String TAGS = "testtag1, testtag2";
    private String providerName;
    private String visibility = "public";
    private String description = "Test Description";
    private static final String WEB_APP_FILE_NAME = "jaxrs_basic";
    private String tier = "Gold";
    private String resTier = "Ultimate";
    private String endPointType = "http";

    @Factory(dataProvider="userModeDataProvider")
    public CopyNewVersionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String sourcePath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + "jaxrs_basic.war";
        String targetPath = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "webapps";
        FileManager.copyResourceToFileSystem((String)sourcePath, (String)targetPath, (String)"jaxrs_basic.war");
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePath);
        WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)WEB_APP_FILE_NAME);
        log.info((Object)"Web App Deployed");
        String publisherUrlHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherUrlHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Copy new Version")
    public void copyApiNewVersion() throws Exception {
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, "customers/{id}/"));
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(API_NAME, API_CONTEXT, this.version, this.providerName, new URL(endpointUrl));
        apiCreationRequestBean.setEndpointType(this.endPointType);
        apiCreationRequestBean.setTier(this.tier);
        apiCreationRequestBean.setVisibility(this.visibility);
        apiCreationRequestBean.setDescription(this.description);
        apiCreationRequestBean.setTags(this.TAGS);
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Invalid");
        Assert.assertTrue((boolean)apiCreateResponse.getData().contains("{\"error\" : false}"), (String)("Response Data Mismatch Actual: " + apiCreateResponse.getData()));
        HttpResponse newVersionResponse = this.apiPublisher.copyAPI(this.providerName, API_NAME, this.version, this.newVersion, "");
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        HttpResponse apiResponse = this.apiPublisher.getApi(API_NAME, this.providerName, this.newVersion);
        log.info((Object)("API new Version Response" + apiResponse.getData()));
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        Assert.assertTrue((boolean)apiResponse.getData().contains("\"error\" : false"), (String)"Response Data Mismatched");
        JSONObject apiCopyResponse = new JSONObject(apiResponse.getData());
        String newName = apiCopyResponse.getJSONObject("api").getString("name");
        Assert.assertEquals((String)newName, (String)API_NAME, (String)"API Name is not correct");
        String newVersion1 = apiCopyResponse.getJSONObject("api").getString("version");
        Assert.assertEquals((String)newVersion1, (String)this.newVersion, (String)"API Version is not correct");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(API_NAME, this.version, this.providerName);
        this.apiPublisher.deleteAPI(API_NAME, this.newVersion, this.providerName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

