/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.extensions.servers.utils.ClientConnectionUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.utils.FileManipulator;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class DAOTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(DAOTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerName;
    private int port;

    @Factory(dataProvider="userModeDataProvider")
    public DAOTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.port = Integer.parseInt((String)this.publisherContext.getDefaultInstance().getPorts().get("http"));
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        this.providerName = this.user.getUserName();
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    private void copySampleFile(String sourcePath, String destPath) {
        File sourceFile = new File(sourcePath);
        File destFile = new File(destPath);
        try {
            FileManipulator.copyFile((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            log.error((Object)"Error while copying the other into Jaggery server", (Throwable)e);
        }
    }

    private String computeDestPath(String fileName) {
        String serverRoot = System.getProperty("carbon.home");
        String deploymentPath = serverRoot + "/repository/deployment/server/jaggeryapps/testapp";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            log.error((Object)("Error while creating the deployment folder : " + deploymentPath));
        }
        return deploymentPath + File.separator + fileName;
    }

    private String computeSourcePath(String fileName) {
        return this.getAMResourceLocation() + File.separator + "jaggery/" + fileName;
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test case")
    public void testDAOTestCase() throws Exception {
        String APIName = "DAOTestAPI";
        String APIContext = "DAOTestAPI";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        String apiContextAddedValue = APIContext + "/" + APIVersion;
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(this.providerName);
        this.apiPublisher.addAPI(apiRequest);
        this.apiPublisher.deleteAPI(APIName, APIVersion, this.providerName);
        this.apiPublisher.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)this.apiPublisher.getAPI(APIName, this.providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, this.providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((String)apiBean.getId().getApiName(), (String)APIName, (String)"API Name mismatch");
        Assert.assertTrue((boolean)apiBean.getContext().contains(apiContextAddedValue), (String)"API context mismatch");
        Assert.assertEquals((String)apiBean.getId().getVersion(), (String)APIVersion, (String)"API version mismatch");
        Assert.assertEquals((String)apiBean.getId().getProviderName(), (String)this.providerName, (String)"Provider Name mismatch");
        for (String tag : apiBean.getTags()) {
            Assert.assertTrue((boolean)tags.contains(tag), (String)"API tag data mismatched");
        }
        Assert.assertEquals((String)apiBean.getDescription(), (String)description, (String)"API description mismatch");
        this.apiStore.addApplication("DAOTestAPI-Application", "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName("DAOTestAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("DAOTestAPI-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test application object")
    public void testApplication() throws XPathExpressionException {
        String fileName = "testPublisher.jag";
        String sourcePath = this.computeSourcePath(fileName);
        String destinationPath = this.computeDestPath(fileName);
        this.copySampleFile(sourcePath, destinationPath);
        ClientConnectionUtil.waitForPort((int)this.port, (String)"");
        String finalOutput = null;
        try {
            String inputLine;
            URL jaggeryURL = new URL(this.getPublisherURLHttp() + "/testapp/testPublisher.jag");
            URLConnection jaggeryServerConnection = jaggeryURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(jaggeryServerConnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                finalOutput = inputLine;
            }
            in.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test application operations")
    public void testApplicationOperations() throws XPathExpressionException {
        ClientConnectionUtil.waitForPort((int)this.port, (String)"");
        String finalOutput = null;
        try {
            String inputLine;
            URL jaggeryURL = new URL(this.getPublisherURLHttp() + "/testapp/testPublisher.jag");
            URLConnection jaggeryServerConnection = jaggeryURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(jaggeryServerConnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                finalOutput = inputLine;
            }
            in.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("DAOTestAPI-Application");
        super.cleanUp();
    }
}

