/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.utils.FileManipulator;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ErrorMessageTypeTestCase
extends APIMIntegrationBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private static final Log log = LogFactory.getLog(ErrorMessageTypeTestCase.class);
    String gatewaySessionCookie;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.gatewaySessionCookie = this.createSession(this.gatewayContextWrk);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        String destinationPath = this.computeDestinationPathForDataSource("axis2.xml");
        String sourcePath = this.computeAxis2SourceResourcePath("axis2.xml");
        this.copyAxis2ConfigFile(sourcePath, destinationPath);
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "error" + File.separator + "handle" + File.separator + "error-handling-test-synapse.xml", this.gatewayContextWrk, this.gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Error Message format test other")
    public void errorMessageTypeTestCase() throws Exception {
        HttpResponse response = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "stockquote/test/"), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatch");
        Assert.assertTrue((boolean)response.getData().contains("{\"fault\":{"), (String)"Did not receive Json error response");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }

    private String computeDestinationPathForDataSource(String fileName) {
        String serverRoot = System.getProperty("carbon.home");
        String deploymentPath = serverRoot + File.separator + "repository" + File.separator + "conf" + File.separator + "axis2";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            log.error((Object)("Error while creating the deployment folder : " + deploymentPath));
        }
        return deploymentPath + File.separator + fileName;
    }

    private String computeAxis2SourceResourcePath(String fileName) {
        return this.getAMResourceLocation().replace("//", "/") + File.separator + "configFiles" + File.separator + "error" + File.separator + fileName;
    }

    private void copyAxis2ConfigFile(String sourcePath, String destPath) {
        File sourceFile = new File(sourcePath);
        File destFile = new File(destPath);
        try {
            FileManipulator.copyFile((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            log.error((Object)"Error while copying the other into Jaggery server", (Throwable)e);
        }
    }
}

