/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class LoadBalancedEndPointTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(LoadBalancedEndPointTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String apiName = "LoadBalanacedAPITestCase";
    private String context = "LoadBalancedAPI";
    private String version = "1.0.0";
    private String visibility = "public";
    private String providerName;
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private String appTier = "Unlimited";
    private String endPointType = "load_balance";
    private String applicationName = "LoadBalanceAPIApplication";
    private List<APIResourceBean> resourceBeanList;
    private String apiNameSandbox = "SandboxAPITestCase";
    private String contextSandbox = "SandboxAPI";
    private String applicationNameSandbox = "SandboxAPIApplication";
    private String firstProductionEndPoint = "";
    private String secondProductionEndPoint = "";
    private String thirdProductionEndPoint = "";
    private String productionEndpointPrefix = "HelloWSO2 from File ";
    private String gatewayUrl;

    @Factory(dataProvider="userModeDataProvider")
    public LoadBalancedEndPointTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode: " + this.userMode));
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, "name"));
        this.gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-check1_SB", "HelloWSO2 from File 1_Sandbox");
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-check2_SB", "HelloWSO2 from File 2_Sandbox");
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-check3_SB", "HelloWSO2 from File 3_Sandbox");
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-checkOne", "HelloWSO2 from File 1");
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-checkTwo", "HelloWSO2 from File 2");
        LoadBalancedEndPointTestCase.isWebAppDeployed(this.gatewayContextWrk.getContextUrls().getWebAppURL(), "name-checkThree", "HelloWSO2 from File 3");
    }

    @Test(groups={"wso2.am"}, description="Test Load Balance End Points", priority=1)
    public void testCreateApiWithDifferentProductionEndpoints() throws Exception {
        String tags = "LB";
        String description = "LoadBalancedEnd-point";
        this.firstProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkOne";
        this.secondProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkTwo";
        this.thirdProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkThree";
        ArrayList<String> endpointLB = new ArrayList<String>();
        endpointLB.add(this.firstProductionEndPoint);
        endpointLB.add(this.secondProductionEndPoint);
        endpointLB.add(this.thirdProductionEndPoint);
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APICreationRequestBean apiCreateRequestBean = new APICreationRequestBean(this.apiName, this.context, this.version, this.providerName, endpointLB);
        apiCreateRequestBean.setTiersCollection(this.tier);
        apiCreateRequestBean.setResourceBeanList(this.resourceBeanList);
        apiCreateRequestBean.setVisibility(this.visibility);
        apiCreateRequestBean.setTags(tags);
        apiCreateRequestBean.setDescription(description);
        apiCreateRequestBean.setEndpointType(this.endPointType);
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreateRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        JSONObject jsonObject = new JSONObject(apiCreateResponse.getData());
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"Error in API creation");
        HttpResponse verifyApi = this.apiPublisher.getApi(this.apiName, this.providerName, this.version);
        JSONObject verifyApiJsonObject = new JSONObject(verifyApi.getData());
        Assert.assertFalse((boolean)verifyApiJsonObject.getBoolean("error"), (String)"Error in Verify API Response");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.providerName, APILifeCycleState.PUBLISHED);
        HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
        JSONObject statusUpdateJsonObject = new JSONObject(statusUpdateResponse.getData());
        Assert.assertFalse((boolean)statusUpdateJsonObject.getBoolean("error"), (String)"API is not published");
    }

    @Test(groups={"wso2.am"}, description="Verify Round Robin Algorithm by Invoking the Production Endpoint API", dependsOnMethods={"testCreateApiWithDifferentProductionEndpoints"})
    public void testRoundRobinAlgorithmInProductionEndpoints() throws Exception {
        String accessUrl = this.gatewayUrl + this.context + "/" + this.version + "/name";
        this.apiStore.addApplication(this.applicationName, this.appTier, "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.version, this.providerName, this.applicationName, this.tier);
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        JSONObject subscriptionJsonObject = new JSONObject(subscriptionResponse.getData());
        Assert.assertEquals((boolean)subscriptionJsonObject.getBoolean("error"), (boolean)false, (String)"Error in Subscription Response");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator(this.applicationName);
        String responseString = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(responseString);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").getString("accessToken");
        HashMap<String, String> applicationHeader = new HashMap<String, String>();
        applicationHeader.put("Authorization", " Bearer " + accessToken);
        int numberOfEndpoints = 3;
        int requestCount = 10;
        Thread.sleep(80000L);
        for (int requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeader);
            Assert.assertEquals((int)apiInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
            int remainder = requestNumber % numberOfEndpoints;
            if (remainder == 0) {
                log.info((Object)apiInvokeResponse.getData());
                Assert.assertEquals((String)apiInvokeResponse.getData(), (String)(this.productionEndpointPrefix + "3"), (String)("Error in Round Robin Algorithm in cycle " + requestNumber));
                continue;
            }
            log.info((Object)apiInvokeResponse.getData());
            Assert.assertEquals((String)apiInvokeResponse.getData(), (String)(this.productionEndpointPrefix + remainder), (String)("Error in Round Robin Algorithm in Cycle " + requestNumber));
        }
    }

    @Test(groups={"wso2.am"}, description="Test Load balanced function with both Production and Sandbox Endpoints", priority=2)
    public void testCreateApiWithBothProdAndSandboxEndpoints() throws Exception {
        String descriptionSandbox = "SandboxEnd-point";
        String tagsSandbox = "sandbox";
        this.firstProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkOne";
        this.secondProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkTwo";
        this.thirdProductionEndPoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-checkThree";
        ArrayList<String> endpointProd = new ArrayList<String>();
        endpointProd.add(this.firstProductionEndPoint);
        endpointProd.add(this.secondProductionEndPoint);
        endpointProd.add(this.thirdProductionEndPoint);
        String firstSandboxEndpoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-check1_SB";
        String secondSandboxEndpoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-check2_SB";
        String thirdSandboxEndpoint = this.gatewayUrlsWrk.getWebAppURLHttp() + "name-check3_SB";
        ArrayList<String> endpointSandbox = new ArrayList<String>();
        endpointSandbox.add(firstSandboxEndpoint);
        endpointSandbox.add(secondSandboxEndpoint);
        endpointSandbox.add(thirdSandboxEndpoint);
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APICreationRequestBean apiSBCreationRequestBean = new APICreationRequestBean(this.apiNameSandbox, this.contextSandbox, this.version, this.providerName, endpointProd, endpointSandbox);
        apiSBCreationRequestBean.setTiersCollection(this.tier);
        apiSBCreationRequestBean.setResourceBeanList(this.resourceBeanList);
        apiSBCreationRequestBean.setVisibility(this.visibility);
        apiSBCreationRequestBean.setTags(tagsSandbox);
        apiSBCreationRequestBean.setDescription(descriptionSandbox);
        apiSBCreationRequestBean.setEndpointType(this.endPointType);
        HttpResponse apiSBCreateResponse = this.apiPublisher.addAPI(apiSBCreationRequestBean);
        Assert.assertEquals((int)apiSBCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response code");
        JSONObject apiSBCreateJsonObject = new JSONObject(apiSBCreateResponse.getData());
        Assert.assertFalse((boolean)apiSBCreateJsonObject.getBoolean("error"), (String)"Response Data is Mismatched in API Creation");
        HttpResponse verifyAPI = this.apiPublisher.getAPI(this.apiNameSandbox, this.providerName, this.version);
        Assert.assertEquals((int)verifyAPI.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        JSONObject verifyApiJSONObject = new JSONObject(verifyAPI.getData());
        Assert.assertFalse((boolean)verifyApiJSONObject.getBoolean("error"), (String)"API is not exists");
        APILifeCycleStateRequest updateStateRequest = new APILifeCycleStateRequest(this.apiNameSandbox, this.providerName, APILifeCycleState.PUBLISHED);
        HttpResponse stateUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateStateRequest);
        Assert.assertEquals((int)stateUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched in publish API");
        JSONObject apiPublishedJsonObject = new JSONObject(stateUpdateResponse.getData());
        Assert.assertFalse((boolean)apiPublishedJsonObject.getBoolean("error"), (String)"API is not published");
    }

    @Test(groups={"wso2.am"}, description="Verify Round Robin Algorithm by Invoking the Sandbox Endpoint API", dependsOnMethods={"testCreateApiWithBothProdAndSandboxEndpoints"})
    public void testRoundRobinAlgorithmInProductionAndSandboxEndpoints() throws Exception {
        int remainder;
        int requestNumber;
        String webAppSandboxResponsePrefix = "HelloWSO2 from File ";
        String webAppSandboxResponseSuffix = "_Sandbox";
        String accessUrl = this.gatewayUrl + this.contextSandbox + "/" + this.version + "/name";
        this.apiStore.addApplication(this.applicationNameSandbox, this.appTier, "", "");
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiNameSandbox, this.version, this.providerName, this.applicationNameSandbox, this.tier);
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject subscriptionJsonObject = new JSONObject(subscriptionResponse.getData());
        Assert.assertFalse((boolean)subscriptionJsonObject.getBoolean("error"), (String)"Error in Subscription Response");
        APPKeyRequestGenerator appKeyRequestGeneratorProduction = new APPKeyRequestGenerator(this.applicationNameSandbox);
        String responseStringProductionEndpoint = this.apiStore.generateApplicationKey(appKeyRequestGeneratorProduction).getData();
        JSONObject productionEndpointJsonObject = new JSONObject(responseStringProductionEndpoint);
        String accessTokenProduction = productionEndpointJsonObject.getJSONObject("data").getJSONObject("key").getString("accessToken");
        HashMap<String, String> applicationHeaderProduction = new HashMap<String, String>();
        applicationHeaderProduction.put("Authorization", " Bearer " + accessTokenProduction);
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator(this.applicationNameSandbox);
        appKeyRequestGenerator.setKeyType("SANDBOX");
        String responseString = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(responseString);
        String accessTokenSandbox = jsonObject.getJSONObject("data").getJSONObject("key").getString("accessToken");
        HashMap<String, String> applicationHeaderSandbox = new HashMap<String, String>();
        applicationHeaderSandbox.put("Authorization", " Bearer " + accessTokenSandbox);
        int requestCount = 10;
        int numberOfProductionEndpoints = 3;
        int numberOfSandboxEndpoints = 3;
        Thread.sleep(80000L);
        for (requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiProductionInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeaderProduction);
            Assert.assertEquals((int)apiProductionInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched in Production API invoke");
            remainder = requestNumber % numberOfProductionEndpoints;
            if (remainder == 0) {
                log.info((Object)apiProductionInvokeResponse.getData());
                Assert.assertEquals((String)apiProductionInvokeResponse.getData(), (String)(this.productionEndpointPrefix + "3"), (String)"Error in Round Robin Algorithm in cycle ");
                continue;
            }
            log.info((Object)apiProductionInvokeResponse.getData());
            Assert.assertEquals((String)apiProductionInvokeResponse.getData(), (String)(this.productionEndpointPrefix + remainder), (String)("Error in Production Endpoint Round Robin Algorithm in request: " + requestNumber));
        }
        for (requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiSandboxInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeaderSandbox);
            Assert.assertEquals((int)apiSandboxInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch in Sandbox Endpoint invoke");
            remainder = requestNumber % numberOfSandboxEndpoints;
            if (remainder == 0) {
                log.info((Object)apiSandboxInvokeResponse.getData());
                Assert.assertEquals((String)apiSandboxInvokeResponse.getData(), (String)(webAppSandboxResponsePrefix + "3" + webAppSandboxResponseSuffix), (String)"Error in Round Robin Algorithm in cycle ");
                continue;
            }
            log.info((Object)apiSandboxInvokeResponse.getData());
            Assert.assertEquals((String)apiSandboxInvokeResponse.getData(), (String)(webAppSandboxResponsePrefix + remainder + webAppSandboxResponseSuffix), (String)("Error in Round Robin Algorithm in Cycle " + requestNumber));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeAPISubscriptionByName(this.apiName, this.version, this.providerName, this.applicationName);
        this.apiStore.removeAPISubscriptionByName(this.apiNameSandbox, this.version, this.providerName, this.applicationNameSandbox);
        this.apiStore.removeApplication(this.applicationName);
        this.apiStore.removeApplication(this.applicationNameSandbox);
        this.apiPublisher.deleteAPI(this.apiName, this.version, this.providerName);
        this.apiPublisher.deleteAPI(this.apiNameSandbox, this.version, this.providerName);
        super.cleanUp();
    }

    public static void isWebAppDeployed(String webAppURL, String webAppName, String expectedResponse) {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 90000L;
        HttpResponse response = null;
        while (waitTime > System.currentTimeMillis()) {
            try {
                response = HttpRequestUtil.sendGetRequest((String)(webAppURL + "/" + webAppName + "/name"), null);
            }
            catch (IOException ignore) {
                log.info((Object)("WAIT for webapp deployment :" + webAppName));
            }
            if (response == null) continue;
            if (response.getData().contains(expectedResponse)) {
                log.info((Object)("WEB_APP :" + webAppName + " found"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
    }
}

