/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;

public class LocationHeaderTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(LocationHeaderTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api_loc_header.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Check whether the Location header is correct")
    public void testAPIWithLocationHeader() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.verifyResponse(response);
        String apiName = "LocationHeaderAPI";
        String apiVersion = "1.0.0";
        String apiContext = "locheader";
        String endpointUrl = this.getAPIInvocationURLHttp("response");
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        response = this.apiPublisher.addAPI(apiRequest);
        this.verifyResponse(response);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(response);
        response = this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.verifyResponse(response);
        response = this.apiStore.addApplication("LocHeaderAPP", "Unlimited", "", "");
        this.verifyResponse(response);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.user.getUserName(), "LocHeaderAPP", "Unlimited");
        response = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(response);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("LocHeaderAPP");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject responseJson = new JSONObject(responseString);
        String accessToken = responseJson.getJSONObject("data").getJSONObject("key").getString("accessToken");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext, apiVersion);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet get = new HttpGet(apiInvocationUrl);
        get.addHeader((Header)new BasicHeader("Authorization", "Bearer " + accessToken));
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
        Header locationHeader = httpResponse.getFirstHeader("Location");
        Assert.assertFalse((boolean)locationHeader.getValue().endsWith("//abc/domain"), (String)"Location header contains additional / character");
        Assert.assertTrue((boolean)locationHeader.getValue().endsWith("/abc/domain"), (String)("Unexpected Location header. Expected to end with /abc/domain but received " + locationHeader));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

