/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ScriptMediatorTestCase
extends APIMIntegrationBaseTest {
    private String APIName = "ScriptMediatorAPI";
    private String APIVersion = "1.0";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "scriptmediator" + File.separator + "script_mediator_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Check whether the script mediator works when a null object is returned in the json")
    public void testScriptMediatorWithNullObject() throws Exception {
        String endpoint = this.getGatewayURLNhttp() + "script/1.0/test";
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.APIName, this.APIVersion, "\"isApiExists\":true");
        HttpResponse response = HttpRequestUtil.doGet((String)endpoint, new HashMap());
        Assert.assertNotNull((Object)response, (String)"Received null response from script mediator endpoint");
        JSONObject jsonResponse = new JSONObject(response.getData());
        Assert.assertEquals((String)jsonResponse.getString("name"), (String)"testName", (String)"Did not find the expected string. Probably the backend failed to respond");
        Assert.assertEquals((String)jsonResponse.getString("checkNull"), (String)"null", (String)("Expected 'null' but received " + jsonResponse.getString("checkNull")));
    }
}

