/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TagsRatingCommentTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @Factory(dataProvider="userModeDataProvider")
    public TagsRatingCommentTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Comment Rating Test case")
    public void testTagsRatingCommentTestCase() throws Exception {
        String APIName = "CommentRatingAPI";
        String APIContext = "commentRating";
        String tags = "youtube, video, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        String apiContextAddedValue = APIContext + "/" + APIVersion;
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        this.apiPublisher.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)this.apiPublisher.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((String)apiBean.getId().getApiName(), (String)APIName, (String)"API Name mismatch");
        if (!this.gatewayContextMgt.getContextTenant().getDomain().equals("carbon.super")) {
            apiContextAddedValue = "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/" + apiContextAddedValue;
        }
        Assert.assertEquals((String)apiBean.getContext().trim().substring(apiBean.getContext().indexOf("/") + 1), (String)apiContextAddedValue, (String)"API context mismatch");
        Assert.assertEquals((String)apiBean.getId().getVersion(), (String)APIVersion, (String)"API version mismatch");
        Assert.assertEquals((String)apiBean.getId().getProviderName(), (String)providerName, (String)"Provider Name mismatch");
        for (String tag : apiBean.getTags()) {
            Assert.assertTrue((boolean)tags.contains(tag), (String)"API tag data mismatched");
        }
        Assert.assertEquals((String)apiBean.getDescription(), (String)description, (String)"API description mismatch");
        this.apiStore.addApplication("CommentRatingAPI-Application", "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName("CommentRatingAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        this.apiStore.getAllPublishedAPIs();
        this.apiStore.getAllApplications();
        this.apiStore.getPublishedAPIsByApplication("CommentRatingAPI-Application");
        this.apiStore.isRatingActivated();
        this.apiStore.addRatingToAPI(APIName, APIVersion, providerName, "4");
        this.apiStore.removeRatingFromAPI(APIName, APIVersion, providerName);
        this.apiStore.getAllDocumentationOfAPI(APIName, APIVersion, providerName);
        this.apiStore.getPublishedAPIsByApplication("CommentRatingAPI-Application-Wrong");
        this.apiStore.isRatingActivated();
        this.apiStore.addRatingToAPI("NoAPI", APIVersion, providerName, "4");
        this.apiStore.removeRatingFromAPI("NoAPI", APIVersion, providerName);
        this.apiStore.getAllDocumentationOfAPI("NoAPI", APIVersion, providerName);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("CommentRatingAPI-Application");
        super.cleanUp();
    }
}

