/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.prototype;

import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.bean.APIImplementationBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM24VisibilityOfPrototypedAPIOfDifferentViewInStoreTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM24PrototypedAPI";
    private final String apiVersion = "1.0.0";
    private final String apiTags = "pizza, order, pizza-menu";
    private final String superUser = "carbon.super";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private APIIdentifier apiIdentifierStore;
    private APIIdentifier apiIdentifierPublisher;
    private String apiProvider;
    private String apiEndPointUrl;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + "pizzashack-api-1.0.0/api/";
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierPublisher = new APIIdentifier(this.apiProvider, "APIM24PrototypedAPI", "1.0.0");
        this.apiIdentifierStore = new APIIdentifier(this.apiProvider, "APIM24PrototypedAPI", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Open already Saved API in design stage and Deploy it as a prototype and check the visibility of prototyped API In store")
    public void testOpenAlreadySavedAPIAndDeployedAsAPrototyped() throws Exception {
        String apiContext = "apim24prototypedApi";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        APIDesignBean apiDesignBean = new APIDesignBean("APIM24PrototypedAPI", apiContext, "1.0.0", apiDescription, "pizza, order, pizza-menu");
        HttpResponse apiDesignResponse = this.apiPublisher.designAPI(apiDesignBean);
        Assert.assertEquals((int)apiDesignResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM24PrototypedAPIis not Designed as expected");
        Assert.assertTrue((boolean)apiDesignResponse.getData().contains("\"error\" : false"), (String)"APIM24PrototypedAPIis not created as expected");
        APIImplementationBean apiImplementationBean = new APIImplementationBean("APIM24PrototypedAPI", "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiImplementationBean.setSwagger(apiDesignBean.getSwagger());
        HttpResponse apiImplementationResponse = this.apiPublisher.implement(apiImplementationBean);
        Assert.assertEquals((int)apiImplementationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM24PrototypedAPIis not Implemented as expected");
        Assert.assertTrue((boolean)apiImplementationResponse.getData().contains("\"error\" : false"), (String)"APIM24PrototypedAPIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM24PrototypedAPI", this.apiProvider, APILifeCycleState.PROTOTYPED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PROTOTYPED"), (String)"APIM24PrototypedAPI status not updated as Prototyped");
        List implementedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisher, (List)implementedAPIList), (String)"APIM24PrototypedAPI is not visible in API Publisher.");
        Thread.sleep(20000L);
        HttpResponse apiResponse = this.apiStore.getPrototypedAPI("carbon.super");
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiResponse.getData().contains("APIM24PrototypedAPI"), (String)"APIM24PrototypedAPI is not visible as Prototyped API");
    }

    @Test(groups={"wso2.am"}, description="API deployed as a prototype and check the visibility in general store", dependsOnMethods={"testOpenAlreadySavedAPIAndDeployedAsAPrototyped"})
    public void testPrototypedAPIVisibilityInGeneralAPI() throws APIManagerIntegrationTestException {
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStore, (List)publishedAPIList), (String)"APIM24PrototypedAPIis not in general Store.");
    }

    @Test(groups={"wso2.am"}, description="API deployed as a prototype and check the visibility in Recently Added list in store", dependsOnMethods={"testOpenAlreadySavedAPIAndDeployedAsAPrototyped"})
    public void testPrototypedAPIVisibilityInRecentlyAddedList() throws APIManagerIntegrationTestException {
        String apiLimit = "5";
        List recentlyAddedAPIIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getRecentlyAddedAPIs("carbon.super", apiLimit));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStore, (List)recentlyAddedAPIIList), (String)"APIM24PrototypedAPIis visible in Recently added API List.");
    }

    @Test(groups={"wso2.am"}, description="API deployed as a prototype and check the tags of API visibility in Tag list in store", dependsOnMethods={"testOpenAlreadySavedAPIAndDeployedAsAPrototyped"})
    public void testTagsOfPrototypedAPIVisibilityInTagList() throws APIManagerIntegrationTestException {
        HttpResponse tagResponse = this.apiStore.getAllTags();
        Assert.assertFalse((boolean)tagResponse.getData().contains("pizza, order, pizza-menu"), (String)"Tags ofAPIM24PrototypedAPI PizzaAPI are visible in Tag List.");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException, JSONException {
        this.apiPublisher.deleteAPI("APIM24PrototypedAPI", "1.0.0", this.apiProvider);
    }
}

