/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM623AddDocumentationToAnAPIWithDocTypePublicForumThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM623PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProvider;
    private String apiEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM623AddDocumentationToAnAPIWithDocTypePublicForumThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type  public forum And Source Url through the publisher rest API ")
    public void testAddDocumentToAnAPIPublicInline() throws Exception {
        String apiContext = "apim623PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag623-1, tag623-2";
        String docName = "APIM611PublisherTestHowTo-Inline-summary";
        String docType = "public forum";
        String sourceType = "URL";
        String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM623PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api623b");
        apiCreationRequestBean.setBizOwnerMail("api623b@ee.com");
        apiCreationRequestBean.setTechOwner("api623t");
        apiCreationRequestBean.setTechOwnerMail("api623t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM623PublisherTestis not created as expected");
        HttpResponse apiResponsePublisher = this.apiPublisher.getAPI("APIM623PublisherTest", this.apiProvider, "1.0.0");
        JSONObject jsonObject = new JSONObject(apiResponsePublisher.getData());
        JSONObject apiObject = new JSONObject(jsonObject.getString("api"));
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM623PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("name").equals("APIM623PublisherTest"), (String)"APIM623PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("status").equals("CREATED"), (String)"Status of the APIM623PublisherTestis not a valid status");
        HttpResponse docResponse = this.apiPublisher.addDocument("APIM623PublisherTest", "1.0.0", this.apiProvider, docName, docType, sourceType, docUrl, "Testing", "", "", null);
        JSONObject jsonObjectDoc1 = new JSONObject(docResponse.getData());
        Assert.assertFalse((boolean)jsonObjectDoc1.getBoolean("error"), (String)"Error when adding document with source Url to the API");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("APIM623PublisherTest", "1.0.0", this.apiProvider);
        super.cleanUp();
    }
}

